<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemFulfillmentItem StructType
 * @subpackage Structs
 */
class ItemFulfillmentItem extends AbstractStructBase
{
    /**
     * The jobName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $jobName;
    /**
     * The itemReceive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemReceive;
    /**
     * The itemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The onHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $onHand;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The unitsDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitsDisplay;
    /**
     * The createPo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createPo;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The poNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $poNum;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The orderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLine;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityRemaining;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The shipGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shipGroup;
    /**
     * The itemIsFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemIsFulfilled;
    /**
     * The shipAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddress;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ItemFulfillmentItem
     * @uses ItemFulfillmentItem::setJobName()
     * @uses ItemFulfillmentItem::setItemReceive()
     * @uses ItemFulfillmentItem::setItemName()
     * @uses ItemFulfillmentItem::setDescription()
     * @uses ItemFulfillmentItem::setDepartment()
     * @uses ItemFulfillmentItem::setClass()
     * @uses ItemFulfillmentItem::setLocation()
     * @uses ItemFulfillmentItem::setOnHand()
     * @uses ItemFulfillmentItem::setQuantity()
     * @uses ItemFulfillmentItem::setUnitsDisplay()
     * @uses ItemFulfillmentItem::setCreatePo()
     * @uses ItemFulfillmentItem::setInventoryDetail()
     * @uses ItemFulfillmentItem::setBinNumbers()
     * @uses ItemFulfillmentItem::setSerialNumbers()
     * @uses ItemFulfillmentItem::setPoNum()
     * @uses ItemFulfillmentItem::setItem()
     * @uses ItemFulfillmentItem::setOrderLine()
     * @uses ItemFulfillmentItem::setQuantityRemaining()
     * @uses ItemFulfillmentItem::setOptions()
     * @uses ItemFulfillmentItem::setShipGroup()
     * @uses ItemFulfillmentItem::setItemIsFulfilled()
     * @uses ItemFulfillmentItem::setShipAddress()
     * @uses ItemFulfillmentItem::setShipMethod()
     * @uses ItemFulfillmentItem::setCustomFieldList()
     * @param string $jobName
     * @param bool $itemReceive
     * @param string $itemName
     * @param string $description
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param float $onHand
     * @param float $quantity
     * @param string $unitsDisplay
     * @param string $createPo
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $binNumbers
     * @param string $serialNumbers
     * @param string $poNum
     * @param \StructType\RecordRef $item
     * @param int $orderLine
     * @param float $quantityRemaining
     * @param \StructType\CustomFieldList $options
     * @param int $shipGroup
     * @param bool $itemIsFulfilled
     * @param \StructType\RecordRef $shipAddress
     * @param \StructType\RecordRef $shipMethod
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($jobName = null, $itemReceive = null, $itemName = null, $description = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $onHand = null, $quantity = null, $unitsDisplay = null, $createPo = null, \StructType\InventoryDetail $inventoryDetail = null, $binNumbers = null, $serialNumbers = null, $poNum = null, \StructType\RecordRef $item = null, $orderLine = null, $quantityRemaining = null, \StructType\CustomFieldList $options = null, $shipGroup = null, $itemIsFulfilled = null, \StructType\RecordRef $shipAddress = null, \StructType\RecordRef $shipMethod = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setJobName($jobName)
            ->setItemReceive($itemReceive)
            ->setItemName($itemName)
            ->setDescription($description)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setOnHand($onHand)
            ->setQuantity($quantity)
            ->setUnitsDisplay($unitsDisplay)
            ->setCreatePo($createPo)
            ->setInventoryDetail($inventoryDetail)
            ->setBinNumbers($binNumbers)
            ->setSerialNumbers($serialNumbers)
            ->setPoNum($poNum)
            ->setItem($item)
            ->setOrderLine($orderLine)
            ->setQuantityRemaining($quantityRemaining)
            ->setOptions($options)
            ->setShipGroup($shipGroup)
            ->setItemIsFulfilled($itemIsFulfilled)
            ->setShipAddress($shipAddress)
            ->setShipMethod($shipMethod)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get jobName value
     * @return string|null
     */
    public function getJobName()
    {
        return $this->jobName;
    }
    /**
     * Set jobName value
     * @param string $jobName
     * @return \StructType\ItemFulfillmentItem
     */
    public function setJobName($jobName = null)
    {
        // validation for constraint: string
        if (!is_null($jobName) && !is_string($jobName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobName, true), gettype($jobName)), __LINE__);
        }
        $this->jobName = $jobName;
        return $this;
    }
    /**
     * Get itemReceive value
     * @return bool|null
     */
    public function getItemReceive()
    {
        return $this->itemReceive;
    }
    /**
     * Set itemReceive value
     * @param bool $itemReceive
     * @return \StructType\ItemFulfillmentItem
     */
    public function setItemReceive($itemReceive = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemReceive) && !is_bool($itemReceive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemReceive, true), gettype($itemReceive)), __LINE__);
        }
        $this->itemReceive = $itemReceive;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\ItemFulfillmentItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ItemFulfillmentItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\ItemFulfillmentItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\ItemFulfillmentItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ItemFulfillmentItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get onHand value
     * @return float|null
     */
    public function getOnHand()
    {
        return $this->onHand;
    }
    /**
     * Set onHand value
     * @param float $onHand
     * @return \StructType\ItemFulfillmentItem
     */
    public function setOnHand($onHand = null)
    {
        // validation for constraint: float
        if (!is_null($onHand) && !(is_float($onHand) || is_numeric($onHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onHand, true), gettype($onHand)), __LINE__);
        }
        $this->onHand = $onHand;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\ItemFulfillmentItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get unitsDisplay value
     * @return string|null
     */
    public function getUnitsDisplay()
    {
        return $this->unitsDisplay;
    }
    /**
     * Set unitsDisplay value
     * @param string $unitsDisplay
     * @return \StructType\ItemFulfillmentItem
     */
    public function setUnitsDisplay($unitsDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($unitsDisplay) && !is_string($unitsDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitsDisplay, true), gettype($unitsDisplay)), __LINE__);
        }
        $this->unitsDisplay = $unitsDisplay;
        return $this;
    }
    /**
     * Get createPo value
     * @return string|null
     */
    public function getCreatePo()
    {
        return $this->createPo;
    }
    /**
     * Set createPo value
     * @param string $createPo
     * @return \StructType\ItemFulfillmentItem
     */
    public function setCreatePo($createPo = null)
    {
        // validation for constraint: string
        if (!is_null($createPo) && !is_string($createPo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createPo, true), gettype($createPo)), __LINE__);
        }
        $this->createPo = $createPo;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\ItemFulfillmentItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\ItemFulfillmentItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\ItemFulfillmentItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get poNum value
     * @return string|null
     */
    public function getPoNum()
    {
        return $this->poNum;
    }
    /**
     * Set poNum value
     * @param string $poNum
     * @return \StructType\ItemFulfillmentItem
     */
    public function setPoNum($poNum = null)
    {
        // validation for constraint: string
        if (!is_null($poNum) && !is_string($poNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNum, true), gettype($poNum)), __LINE__);
        }
        $this->poNum = $poNum;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\ItemFulfillmentItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get orderLine value
     * @return int|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * Set orderLine value
     * @param int $orderLine
     * @return \StructType\ItemFulfillmentItem
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !(is_int($orderLine) || ctype_digit($orderLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLine, true), gettype($orderLine)), __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return float|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * Set quantityRemaining value
     * @param float $quantityRemaining
     * @return \StructType\ItemFulfillmentItem
     */
    public function setQuantityRemaining($quantityRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($quantityRemaining) && !(is_float($quantityRemaining) || is_numeric($quantityRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityRemaining, true), gettype($quantityRemaining)), __LINE__);
        }
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\ItemFulfillmentItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get shipGroup value
     * @return int|null
     */
    public function getShipGroup()
    {
        return $this->shipGroup;
    }
    /**
     * Set shipGroup value
     * @param int $shipGroup
     * @return \StructType\ItemFulfillmentItem
     */
    public function setShipGroup($shipGroup = null)
    {
        // validation for constraint: int
        if (!is_null($shipGroup) && !(is_int($shipGroup) || ctype_digit($shipGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipGroup, true), gettype($shipGroup)), __LINE__);
        }
        $this->shipGroup = $shipGroup;
        return $this;
    }
    /**
     * Get itemIsFulfilled value
     * @return bool|null
     */
    public function getItemIsFulfilled()
    {
        return $this->itemIsFulfilled;
    }
    /**
     * Set itemIsFulfilled value
     * @param bool $itemIsFulfilled
     * @return \StructType\ItemFulfillmentItem
     */
    public function setItemIsFulfilled($itemIsFulfilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemIsFulfilled) && !is_bool($itemIsFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemIsFulfilled, true), gettype($itemIsFulfilled)), __LINE__);
        }
        $this->itemIsFulfilled = $itemIsFulfilled;
        return $this;
    }
    /**
     * Get shipAddress value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddress()
    {
        return $this->shipAddress;
    }
    /**
     * Set shipAddress value
     * @param \StructType\RecordRef $shipAddress
     * @return \StructType\ItemFulfillmentItem
     */
    public function setShipAddress(\StructType\RecordRef $shipAddress = null)
    {
        $this->shipAddress = $shipAddress;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\ItemFulfillmentItem
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ItemFulfillmentItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
