<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemBinNumberSearchRowBasic StructType
 * @subpackage Structs
 */
class ItemBinNumberSearchRowBasic extends SearchRowBasic
{
    /**
     * The binNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $binNumber;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $location;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityAvailable;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityOnHand;
    /**
     * Constructor method for ItemBinNumberSearchRowBasic
     * @uses ItemBinNumberSearchRowBasic::setBinNumber()
     * @uses ItemBinNumberSearchRowBasic::setLocation()
     * @uses ItemBinNumberSearchRowBasic::setQuantityAvailable()
     * @uses ItemBinNumberSearchRowBasic::setQuantityOnHand()
     * @param \StructType\SearchColumnSelectField[] $binNumber
     * @param \StructType\SearchColumnSelectField[] $location
     * @param \StructType\SearchColumnDoubleField[] $quantityAvailable
     * @param \StructType\SearchColumnDoubleField[] $quantityOnHand
     */
    public function __construct(array $binNumber = array(), array $location = array(), array $quantityAvailable = array(), array $quantityOnHand = array())
    {
        $this
            ->setBinNumber($binNumber)
            ->setLocation($location)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOnHand($quantityOnHand);
    }
    /**
     * Get binNumber value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getBinNumber()
    {
        return $this->binNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setBinNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBinNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBinNumberForArrayConstraintsFromSetBinNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemBinNumberSearchRowBasicBinNumberItem) {
            // validation for constraint: itemType
            if (!$itemBinNumberSearchRowBasicBinNumberItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemBinNumberSearchRowBasicBinNumberItem) ? get_class($itemBinNumberSearchRowBasicBinNumberItem) : sprintf('%s(%s)', gettype($itemBinNumberSearchRowBasicBinNumberItem), var_export($itemBinNumberSearchRowBasicBinNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The binNumber property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set binNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $binNumber
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function setBinNumber(array $binNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($binNumberArrayErrorMessage = self::validateBinNumberForArrayConstraintsFromSetBinNumber($binNumber))) {
            throw new \InvalidArgumentException($binNumberArrayErrorMessage, __LINE__);
        }
        $this->binNumber = $binNumber;
        return $this;
    }
    /**
     * Add item to binNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function addToBinNumber(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The binNumber property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->binNumber[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemBinNumberSearchRowBasicLocationItem) {
            // validation for constraint: itemType
            if (!$itemBinNumberSearchRowBasicLocationItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($itemBinNumberSearchRowBasicLocationItem) ? get_class($itemBinNumberSearchRowBasicLocationItem) : sprintf('%s(%s)', gettype($itemBinNumberSearchRowBasicLocationItem), var_export($itemBinNumberSearchRowBasicLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $location
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function addToLocation(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityAvailable method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityAvailableForArrayConstraintsFromSetQuantityAvailable(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemBinNumberSearchRowBasicQuantityAvailableItem) {
            // validation for constraint: itemType
            if (!$itemBinNumberSearchRowBasicQuantityAvailableItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($itemBinNumberSearchRowBasicQuantityAvailableItem) ? get_class($itemBinNumberSearchRowBasicQuantityAvailableItem) : sprintf('%s(%s)', gettype($itemBinNumberSearchRowBasicQuantityAvailableItem), var_export($itemBinNumberSearchRowBasicQuantityAvailableItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityAvailable property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityAvailable value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityAvailable
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function setQuantityAvailable(array $quantityAvailable = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityAvailableArrayErrorMessage = self::validateQuantityAvailableForArrayConstraintsFromSetQuantityAvailable($quantityAvailable))) {
            throw new \InvalidArgumentException($quantityAvailableArrayErrorMessage, __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Add item to quantityAvailable value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function addToQuantityAvailable(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityAvailable property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityAvailable[] = $item;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityOnHand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityOnHand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityOnHandForArrayConstraintsFromSetQuantityOnHand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemBinNumberSearchRowBasicQuantityOnHandItem) {
            // validation for constraint: itemType
            if (!$itemBinNumberSearchRowBasicQuantityOnHandItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($itemBinNumberSearchRowBasicQuantityOnHandItem) ? get_class($itemBinNumberSearchRowBasicQuantityOnHandItem) : sprintf('%s(%s)', gettype($itemBinNumberSearchRowBasicQuantityOnHandItem), var_export($itemBinNumberSearchRowBasicQuantityOnHandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityOnHand property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityOnHand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityOnHand
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function setQuantityOnHand(array $quantityOnHand = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityOnHandArrayErrorMessage = self::validateQuantityOnHandForArrayConstraintsFromSetQuantityOnHand($quantityOnHand))) {
            throw new \InvalidArgumentException($quantityOnHandArrayErrorMessage, __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Add item to quantityOnHand value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ItemBinNumberSearchRowBasic
     */
    public function addToQuantityOnHand(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityOnHand property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityOnHand[] = $item;
        return $this;
    }
}
