<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemAvailabilityList StructType
 * @subpackage Structs
 */
class ItemAvailabilityList extends AbstractStructBase
{
    /**
     * The itemAvailability
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ItemAvailability[]
     */
    public $itemAvailability;
    /**
     * Constructor method for ItemAvailabilityList
     * @uses ItemAvailabilityList::setItemAvailability()
     * @param \StructType\ItemAvailability[] $itemAvailability
     */
    public function __construct(array $itemAvailability = array())
    {
        $this
            ->setItemAvailability($itemAvailability);
    }
    /**
     * Get itemAvailability value
     * @return \StructType\ItemAvailability[]|null
     */
    public function getItemAvailability()
    {
        return $this->itemAvailability;
    }
    /**
     * This method is responsible for validating the values passed to the setItemAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemAvailabilityForArrayConstraintsFromSetItemAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemAvailabilityListItemAvailabilityItem) {
            // validation for constraint: itemType
            if (!$itemAvailabilityListItemAvailabilityItem instanceof \StructType\ItemAvailability) {
                $invalidValues[] = is_object($itemAvailabilityListItemAvailabilityItem) ? get_class($itemAvailabilityListItemAvailabilityItem) : sprintf('%s(%s)', gettype($itemAvailabilityListItemAvailabilityItem), var_export($itemAvailabilityListItemAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemAvailability property can only contain items of type \StructType\ItemAvailability, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemAvailability value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemAvailability[] $itemAvailability
     * @return \StructType\ItemAvailabilityList
     */
    public function setItemAvailability(array $itemAvailability = array())
    {
        // validation for constraint: array
        if ('' !== ($itemAvailabilityArrayErrorMessage = self::validateItemAvailabilityForArrayConstraintsFromSetItemAvailability($itemAvailability))) {
            throw new \InvalidArgumentException($itemAvailabilityArrayErrorMessage, __LINE__);
        }
        $this->itemAvailability = $itemAvailability;
        return $this;
    }
    /**
     * Add item to itemAvailability value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemAvailability $item
     * @return \StructType\ItemAvailabilityList
     */
    public function addToItemAvailability(\StructType\ItemAvailability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemAvailability) {
            throw new \InvalidArgumentException(sprintf('The itemAvailability property can only contain items of type \StructType\ItemAvailability, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemAvailability[] = $item;
        return $this;
    }
}
