<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemAvailabilityFilter StructType
 * @subpackage Structs
 */
class ItemAvailabilityFilter extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RecordRefList
     */
    public $item;
    /**
     * The lastQtyAvailableChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastQtyAvailableChange;
    /**
     * Constructor method for ItemAvailabilityFilter
     * @uses ItemAvailabilityFilter::setItem()
     * @uses ItemAvailabilityFilter::setLastQtyAvailableChange()
     * @param \StructType\RecordRefList $item
     * @param string $lastQtyAvailableChange
     */
    public function __construct(\StructType\RecordRefList $item = null, $lastQtyAvailableChange = null)
    {
        $this
            ->setItem($item)
            ->setLastQtyAvailableChange($lastQtyAvailableChange);
    }
    /**
     * Get item value
     * @return \StructType\RecordRefList
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRefList $item
     * @return \StructType\ItemAvailabilityFilter
     */
    public function setItem(\StructType\RecordRefList $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get lastQtyAvailableChange value
     * @return string|null
     */
    public function getLastQtyAvailableChange()
    {
        return $this->lastQtyAvailableChange;
    }
    /**
     * Set lastQtyAvailableChange value
     * @param string $lastQtyAvailableChange
     * @return \StructType\ItemAvailabilityFilter
     */
    public function setLastQtyAvailableChange($lastQtyAvailableChange = null)
    {
        // validation for constraint: string
        if (!is_null($lastQtyAvailableChange) && !is_string($lastQtyAvailableChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastQtyAvailableChange, true), gettype($lastQtyAvailableChange)), __LINE__);
        }
        $this->lastQtyAvailableChange = $lastQtyAvailableChange;
        return $this;
    }
}
