<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemAccountingBookDetailList StructType
 * @subpackage Structs
 */
class ItemAccountingBookDetailList extends AbstractStructBase
{
    /**
     * The itemAccountingBookDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetail[]
     */
    public $itemAccountingBookDetail;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemAccountingBookDetailList
     * @uses ItemAccountingBookDetailList::setItemAccountingBookDetail()
     * @uses ItemAccountingBookDetailList::setReplaceAll()
     * @param \StructType\ItemAccountingBookDetail[] $itemAccountingBookDetail
     * @param bool $replaceAll
     */
    public function __construct(array $itemAccountingBookDetail = array(), $replaceAll = true)
    {
        $this
            ->setItemAccountingBookDetail($itemAccountingBookDetail)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemAccountingBookDetail value
     * @return \StructType\ItemAccountingBookDetail[]|null
     */
    public function getItemAccountingBookDetail()
    {
        return $this->itemAccountingBookDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setItemAccountingBookDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemAccountingBookDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemAccountingBookDetailForArrayConstraintsFromSetItemAccountingBookDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemAccountingBookDetailListItemAccountingBookDetailItem) {
            // validation for constraint: itemType
            if (!$itemAccountingBookDetailListItemAccountingBookDetailItem instanceof \StructType\ItemAccountingBookDetail) {
                $invalidValues[] = is_object($itemAccountingBookDetailListItemAccountingBookDetailItem) ? get_class($itemAccountingBookDetailListItemAccountingBookDetailItem) : sprintf('%s(%s)', gettype($itemAccountingBookDetailListItemAccountingBookDetailItem), var_export($itemAccountingBookDetailListItemAccountingBookDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemAccountingBookDetail property can only contain items of type \StructType\ItemAccountingBookDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemAccountingBookDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemAccountingBookDetail[] $itemAccountingBookDetail
     * @return \StructType\ItemAccountingBookDetailList
     */
    public function setItemAccountingBookDetail(array $itemAccountingBookDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($itemAccountingBookDetailArrayErrorMessage = self::validateItemAccountingBookDetailForArrayConstraintsFromSetItemAccountingBookDetail($itemAccountingBookDetail))) {
            throw new \InvalidArgumentException($itemAccountingBookDetailArrayErrorMessage, __LINE__);
        }
        $this->itemAccountingBookDetail = $itemAccountingBookDetail;
        return $this;
    }
    /**
     * Add item to itemAccountingBookDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemAccountingBookDetail $item
     * @return \StructType\ItemAccountingBookDetailList
     */
    public function addToItemAccountingBookDetail(\StructType\ItemAccountingBookDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemAccountingBookDetail) {
            throw new \InvalidArgumentException(sprintf('The itemAccountingBookDetail property can only contain items of type \StructType\ItemAccountingBookDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemAccountingBookDetail[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemAccountingBookDetailList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
