<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemAccountMappingSearchRow StructType
 * @subpackage Structs
 */
class ItemAccountMappingSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountMappingSearchRowBasic
     */
    public $basic;
    /**
     * The classJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ClassificationSearchRowBasic
     */
    public $classJoin;
    /**
     * The departmentJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DepartmentSearchRowBasic
     */
    public $departmentJoin;
    /**
     * The destinationAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountSearchRowBasic
     */
    public $destinationAccountJoin;
    /**
     * The locationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationSearchRowBasic
     */
    public $locationJoin;
    /**
     * The sourceAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountSearchRowBasic
     */
    public $sourceAccountJoin;
    /**
     * The subsidiaryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubsidiarySearchRowBasic
     */
    public $subsidiaryJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for ItemAccountMappingSearchRow
     * @uses ItemAccountMappingSearchRow::setBasic()
     * @uses ItemAccountMappingSearchRow::setClassJoin()
     * @uses ItemAccountMappingSearchRow::setDepartmentJoin()
     * @uses ItemAccountMappingSearchRow::setDestinationAccountJoin()
     * @uses ItemAccountMappingSearchRow::setLocationJoin()
     * @uses ItemAccountMappingSearchRow::setSourceAccountJoin()
     * @uses ItemAccountMappingSearchRow::setSubsidiaryJoin()
     * @uses ItemAccountMappingSearchRow::setCustomSearchJoin()
     * @param \StructType\ItemAccountMappingSearchRowBasic $basic
     * @param \StructType\ClassificationSearchRowBasic $classJoin
     * @param \StructType\DepartmentSearchRowBasic $departmentJoin
     * @param \StructType\AccountSearchRowBasic $destinationAccountJoin
     * @param \StructType\LocationSearchRowBasic $locationJoin
     * @param \StructType\AccountSearchRowBasic $sourceAccountJoin
     * @param \StructType\SubsidiarySearchRowBasic $subsidiaryJoin
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\ItemAccountMappingSearchRowBasic $basic = null, \StructType\ClassificationSearchRowBasic $classJoin = null, \StructType\DepartmentSearchRowBasic $departmentJoin = null, \StructType\AccountSearchRowBasic $destinationAccountJoin = null, \StructType\LocationSearchRowBasic $locationJoin = null, \StructType\AccountSearchRowBasic $sourceAccountJoin = null, \StructType\SubsidiarySearchRowBasic $subsidiaryJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setClassJoin($classJoin)
            ->setDepartmentJoin($departmentJoin)
            ->setDestinationAccountJoin($destinationAccountJoin)
            ->setLocationJoin($locationJoin)
            ->setSourceAccountJoin($sourceAccountJoin)
            ->setSubsidiaryJoin($subsidiaryJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\ItemAccountMappingSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\ItemAccountMappingSearchRowBasic $basic
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setBasic(\StructType\ItemAccountMappingSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get classJoin value
     * @return \StructType\ClassificationSearchRowBasic|null
     */
    public function getClassJoin()
    {
        return $this->classJoin;
    }
    /**
     * Set classJoin value
     * @param \StructType\ClassificationSearchRowBasic $classJoin
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setClassJoin(\StructType\ClassificationSearchRowBasic $classJoin = null)
    {
        $this->classJoin = $classJoin;
        return $this;
    }
    /**
     * Get departmentJoin value
     * @return \StructType\DepartmentSearchRowBasic|null
     */
    public function getDepartmentJoin()
    {
        return $this->departmentJoin;
    }
    /**
     * Set departmentJoin value
     * @param \StructType\DepartmentSearchRowBasic $departmentJoin
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setDepartmentJoin(\StructType\DepartmentSearchRowBasic $departmentJoin = null)
    {
        $this->departmentJoin = $departmentJoin;
        return $this;
    }
    /**
     * Get destinationAccountJoin value
     * @return \StructType\AccountSearchRowBasic|null
     */
    public function getDestinationAccountJoin()
    {
        return $this->destinationAccountJoin;
    }
    /**
     * Set destinationAccountJoin value
     * @param \StructType\AccountSearchRowBasic $destinationAccountJoin
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setDestinationAccountJoin(\StructType\AccountSearchRowBasic $destinationAccountJoin = null)
    {
        $this->destinationAccountJoin = $destinationAccountJoin;
        return $this;
    }
    /**
     * Get locationJoin value
     * @return \StructType\LocationSearchRowBasic|null
     */
    public function getLocationJoin()
    {
        return $this->locationJoin;
    }
    /**
     * Set locationJoin value
     * @param \StructType\LocationSearchRowBasic $locationJoin
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setLocationJoin(\StructType\LocationSearchRowBasic $locationJoin = null)
    {
        $this->locationJoin = $locationJoin;
        return $this;
    }
    /**
     * Get sourceAccountJoin value
     * @return \StructType\AccountSearchRowBasic|null
     */
    public function getSourceAccountJoin()
    {
        return $this->sourceAccountJoin;
    }
    /**
     * Set sourceAccountJoin value
     * @param \StructType\AccountSearchRowBasic $sourceAccountJoin
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setSourceAccountJoin(\StructType\AccountSearchRowBasic $sourceAccountJoin = null)
    {
        $this->sourceAccountJoin = $sourceAccountJoin;
        return $this;
    }
    /**
     * Get subsidiaryJoin value
     * @return \StructType\SubsidiarySearchRowBasic|null
     */
    public function getSubsidiaryJoin()
    {
        return $this->subsidiaryJoin;
    }
    /**
     * Set subsidiaryJoin value
     * @param \StructType\SubsidiarySearchRowBasic $subsidiaryJoin
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setSubsidiaryJoin(\StructType\SubsidiarySearchRowBasic $subsidiaryJoin = null)
    {
        $this->subsidiaryJoin = $subsidiaryJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemAccountMappingSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$itemAccountMappingSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($itemAccountMappingSearchRowCustomSearchJoinItem) ? get_class($itemAccountMappingSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($itemAccountMappingSearchRowCustomSearchJoinItem), var_export($itemAccountMappingSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\ItemAccountMappingSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
