<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueVersion StructType
 * @subpackage Structs
 */
class IssueVersion extends AbstractStructBase
{
    /**
     * The primary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $primary;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $version;
    /**
     * The build
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $build;
    /**
     * Constructor method for IssueVersion
     * @uses IssueVersion::setPrimary()
     * @uses IssueVersion::setVersion()
     * @uses IssueVersion::setBuild()
     * @param bool $primary
     * @param \StructType\RecordRef $version
     * @param \StructType\RecordRef $build
     */
    public function __construct($primary = null, \StructType\RecordRef $version = null, \StructType\RecordRef $build = null)
    {
        $this
            ->setPrimary($primary)
            ->setVersion($version)
            ->setBuild($build);
    }
    /**
     * Get primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param bool $primary
     * @return \StructType\IssueVersion
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary) && !is_bool($primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary, true), gettype($primary)), __LINE__);
        }
        $this->primary = $primary;
        return $this;
    }
    /**
     * Get version value
     * @return \StructType\RecordRef|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param \StructType\RecordRef $version
     * @return \StructType\IssueVersion
     */
    public function setVersion(\StructType\RecordRef $version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get build value
     * @return \StructType\RecordRef|null
     */
    public function getBuild()
    {
        return $this->build;
    }
    /**
     * Set build value
     * @param \StructType\RecordRef $build
     * @return \StructType\IssueVersion
     */
    public function setBuild(\StructType\RecordRef $build = null)
    {
        $this->build = $build;
        return $this;
    }
}
