<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssueRelatedIssuesList StructType
 * @subpackage Structs
 */
class IssueRelatedIssuesList extends AbstractStructBase
{
    /**
     * The issueRelatedIssues
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IssueRelatedIssues[]
     */
    public $issueRelatedIssues;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for IssueRelatedIssuesList
     * @uses IssueRelatedIssuesList::setIssueRelatedIssues()
     * @uses IssueRelatedIssuesList::setReplaceAll()
     * @param \StructType\IssueRelatedIssues[] $issueRelatedIssues
     * @param bool $replaceAll
     */
    public function __construct(array $issueRelatedIssues = array(), $replaceAll = true)
    {
        $this
            ->setIssueRelatedIssues($issueRelatedIssues)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get issueRelatedIssues value
     * @return \StructType\IssueRelatedIssues[]|null
     */
    public function getIssueRelatedIssues()
    {
        return $this->issueRelatedIssues;
    }
    /**
     * This method is responsible for validating the values passed to the setIssueRelatedIssues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssueRelatedIssues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIssueRelatedIssuesForArrayConstraintsFromSetIssueRelatedIssues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issueRelatedIssuesListIssueRelatedIssuesItem) {
            // validation for constraint: itemType
            if (!$issueRelatedIssuesListIssueRelatedIssuesItem instanceof \StructType\IssueRelatedIssues) {
                $invalidValues[] = is_object($issueRelatedIssuesListIssueRelatedIssuesItem) ? get_class($issueRelatedIssuesListIssueRelatedIssuesItem) : sprintf('%s(%s)', gettype($issueRelatedIssuesListIssueRelatedIssuesItem), var_export($issueRelatedIssuesListIssueRelatedIssuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The issueRelatedIssues property can only contain items of type \StructType\IssueRelatedIssues, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set issueRelatedIssues value
     * @throws \InvalidArgumentException
     * @param \StructType\IssueRelatedIssues[] $issueRelatedIssues
     * @return \StructType\IssueRelatedIssuesList
     */
    public function setIssueRelatedIssues(array $issueRelatedIssues = array())
    {
        // validation for constraint: array
        if ('' !== ($issueRelatedIssuesArrayErrorMessage = self::validateIssueRelatedIssuesForArrayConstraintsFromSetIssueRelatedIssues($issueRelatedIssues))) {
            throw new \InvalidArgumentException($issueRelatedIssuesArrayErrorMessage, __LINE__);
        }
        $this->issueRelatedIssues = $issueRelatedIssues;
        return $this;
    }
    /**
     * Add item to issueRelatedIssues value
     * @throws \InvalidArgumentException
     * @param \StructType\IssueRelatedIssues $item
     * @return \StructType\IssueRelatedIssuesList
     */
    public function addToIssueRelatedIssues(\StructType\IssueRelatedIssues $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IssueRelatedIssues) {
            throw new \InvalidArgumentException(sprintf('The issueRelatedIssues property can only contain items of type \StructType\IssueRelatedIssues, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->issueRelatedIssues[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\IssueRelatedIssuesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
