<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceItemCostList StructType
 * @subpackage Structs
 */
class InvoiceItemCostList extends AbstractStructBase
{
    /**
     * The itemCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoiceItemCost[]
     */
    public $itemCost;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InvoiceItemCostList
     * @uses InvoiceItemCostList::setItemCost()
     * @uses InvoiceItemCostList::setReplaceAll()
     * @param \StructType\InvoiceItemCost[] $itemCost
     * @param bool $replaceAll
     */
    public function __construct(array $itemCost = array(), $replaceAll = true)
    {
        $this
            ->setItemCost($itemCost)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemCost value
     * @return \StructType\InvoiceItemCost[]|null
     */
    public function getItemCost()
    {
        return $this->itemCost;
    }
    /**
     * This method is responsible for validating the values passed to the setItemCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemCostForArrayConstraintsFromSetItemCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceItemCostListItemCostItem) {
            // validation for constraint: itemType
            if (!$invoiceItemCostListItemCostItem instanceof \StructType\InvoiceItemCost) {
                $invalidValues[] = is_object($invoiceItemCostListItemCostItem) ? get_class($invoiceItemCostListItemCostItem) : sprintf('%s(%s)', gettype($invoiceItemCostListItemCostItem), var_export($invoiceItemCostListItemCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemCost property can only contain items of type \StructType\InvoiceItemCost, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemCost value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceItemCost[] $itemCost
     * @return \StructType\InvoiceItemCostList
     */
    public function setItemCost(array $itemCost = array())
    {
        // validation for constraint: array
        if ('' !== ($itemCostArrayErrorMessage = self::validateItemCostForArrayConstraintsFromSetItemCost($itemCost))) {
            throw new \InvalidArgumentException($itemCostArrayErrorMessage, __LINE__);
        }
        $this->itemCost = $itemCost;
        return $this;
    }
    /**
     * Add item to itemCost value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceItemCost $item
     * @return \StructType\InvoiceItemCostList
     */
    public function addToItemCost(\StructType\InvoiceItemCost $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceItemCost) {
            throw new \InvalidArgumentException(sprintf('The itemCost property can only contain items of type \StructType\InvoiceItemCost, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemCost[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InvoiceItemCostList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
