<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * Meta information extracted from the WSDL
 * - type: tranSales:Invoice
 * @subpackage Structs
 */
class Invoice extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nextApprover;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The billingAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingAccount;
    /**
     * The recurringBill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $recurringBill;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The opportunity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $opportunity;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The terms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terms;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The discountDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountDate;
    /**
     * The discountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAmount;
    /**
     * The salesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRep;
    /**
     * The contribPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contribPct;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $leadSource;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The otherRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $otherRefNum;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The salesEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesEffectiveDate;
    /**
     * The excludeCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeCommission;
    /**
     * The totalCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalCostEstimate;
    /**
     * The estGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfit;
    /**
     * The estGrossProfitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfitPercent;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecStartDate;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecEndDate;
    /**
     * The amountPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountPaid;
    /**
     * The amountRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountRemaining;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The onCreditHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $onCreditHold;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $promoCode;
    /**
     * The discountItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $discountItem;
    /**
     * The discountRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountRate;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The taxItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxItem;
    /**
     * The taxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The toBeEmailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeEmailed;
    /**
     * The toBeFaxed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeFaxed;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The messageSel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $messageSel;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The shipIsResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIsResidential;
    /**
     * The shipAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddressList;
    /**
     * The fob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fob;
    /**
     * The shipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipDate;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The shippingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTax1Rate;
    /**
     * The shippingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingTax2Rate;
    /**
     * The shippingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shippingTaxCode;
    /**
     * The handlingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $handlingTaxCode;
    /**
     * The handlingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTax1Rate;
    /**
     * The handlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingCost;
    /**
     * The handlingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingTax2Rate;
    /**
     * The trackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trackingNumbers;
    /**
     * The linkedTrackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkedTrackingNumbers;
    /**
     * The salesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesGroup;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The canHaveStackable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $canHaveStackable;
    /**
     * The revenueStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revenueStatus;
    /**
     * The recognizedRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recognizedRevenue;
    /**
     * The deferredRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $deferredRevenue;
    /**
     * The revRecOnRevCommitment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $revRecOnRevCommitment;
    /**
     * The syncSalesTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncSalesTeams;
    /**
     * The discountTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountTotal;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The altShippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altShippingCost;
    /**
     * The altHandlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altHandlingCost;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The expCostDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expCostDiscount;
    /**
     * The itemCostDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemCostDiscount;
    /**
     * The timeDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $timeDiscount;
    /**
     * The expCostDiscRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expCostDiscRate;
    /**
     * The itemCostDiscRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemCostDiscRate;
    /**
     * The timeDiscRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeDiscRate;
    /**
     * The expCostDiscAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expCostDiscAmount;
    /**
     * The expCostTaxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expCostTaxRate1;
    /**
     * The expCostTaxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expCostTaxRate2;
    /**
     * The itemCostDiscAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $itemCostDiscAmount;
    /**
     * The expCostTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expCostTaxCode;
    /**
     * The expCostDiscTax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expCostDiscTax1Amt;
    /**
     * The itemCostTaxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $itemCostTaxRate1;
    /**
     * The timeDiscAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $timeDiscAmount;
    /**
     * The itemCostTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemCostTaxCode;
    /**
     * The expCostDiscTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $expCostDiscTaxable;
    /**
     * The itemCostDiscTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemCostDiscTaxable;
    /**
     * The itemCostTaxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $itemCostTaxRate2;
    /**
     * The itemCostDiscTax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $itemCostDiscTax1Amt;
    /**
     * The itemCostDiscPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemCostDiscPrint;
    /**
     * The timeDiscTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $timeDiscTaxable;
    /**
     * The timeTaxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $timeTaxRate1;
    /**
     * The expCostDiscPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $expCostDiscPrint;
    /**
     * The timeTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $timeTaxCode;
    /**
     * The timeDiscPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $timeDiscPrint;
    /**
     * The giftCertApplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertApplied;
    /**
     * The timeDiscTax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $timeDiscTax1Amt;
    /**
     * The tranIsVsoeBundle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $tranIsVsoeBundle;
    /**
     * The timeTaxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $timeTaxRate2;
    /**
     * The vsoeAutoCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeAutoCalc;
    /**
     * The syncPartnerTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncPartnerTeams;
    /**
     * The salesTeamList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceSalesTeamList
     */
    public $salesTeamList;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoicePartnersList
     */
    public $partnersList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceItemList
     */
    public $itemList;
    /**
     * The itemCostList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceItemCostList
     */
    public $itemCostList;
    /**
     * The giftCertRedemptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GiftCertRedemptionList
     */
    public $giftCertRedemptionList;
    /**
     * The promotionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionsList
     */
    public $promotionsList;
    /**
     * The expCostList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceExpCostList
     */
    public $expCostList;
    /**
     * The timeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceTimeList
     */
    public $timeList;
    /**
     * The shipGroupList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceShipGroupList
     */
    public $shipGroupList;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setCreatedDate()
     * @uses Invoice::setLastModifiedDate()
     * @uses Invoice::setNexus()
     * @uses Invoice::setSubsidiaryTaxRegNum()
     * @uses Invoice::setTaxRegOverride()
     * @uses Invoice::setTaxDetailsOverride()
     * @uses Invoice::setCustomForm()
     * @uses Invoice::setNextApprover()
     * @uses Invoice::setEntity()
     * @uses Invoice::setBillingAccount()
     * @uses Invoice::setRecurringBill()
     * @uses Invoice::setTranDate()
     * @uses Invoice::setTranId()
     * @uses Invoice::setEntityTaxRegNum()
     * @uses Invoice::setTaxPointDate()
     * @uses Invoice::setSource()
     * @uses Invoice::setCreatedFrom()
     * @uses Invoice::setPostingPeriod()
     * @uses Invoice::setOpportunity()
     * @uses Invoice::setDepartment()
     * @uses Invoice::setClass()
     * @uses Invoice::setTerms()
     * @uses Invoice::setLocation()
     * @uses Invoice::setSubsidiary()
     * @uses Invoice::setCurrency()
     * @uses Invoice::setDueDate()
     * @uses Invoice::setDiscountDate()
     * @uses Invoice::setDiscountAmount()
     * @uses Invoice::setSalesRep()
     * @uses Invoice::setContribPct()
     * @uses Invoice::setPartner()
     * @uses Invoice::setLeadSource()
     * @uses Invoice::setStartDate()
     * @uses Invoice::setEndDate()
     * @uses Invoice::setOtherRefNum()
     * @uses Invoice::setMemo()
     * @uses Invoice::setSalesEffectiveDate()
     * @uses Invoice::setExcludeCommission()
     * @uses Invoice::setTotalCostEstimate()
     * @uses Invoice::setEstGrossProfit()
     * @uses Invoice::setEstGrossProfitPercent()
     * @uses Invoice::setRevRecSchedule()
     * @uses Invoice::setRevRecStartDate()
     * @uses Invoice::setRevRecEndDate()
     * @uses Invoice::setAmountPaid()
     * @uses Invoice::setAmountRemaining()
     * @uses Invoice::setBalance()
     * @uses Invoice::setAccount()
     * @uses Invoice::setOnCreditHold()
     * @uses Invoice::setExchangeRate()
     * @uses Invoice::setCurrencyName()
     * @uses Invoice::setPromoCode()
     * @uses Invoice::setDiscountItem()
     * @uses Invoice::setDiscountRate()
     * @uses Invoice::setIsTaxable()
     * @uses Invoice::setTaxItem()
     * @uses Invoice::setTaxRate()
     * @uses Invoice::setToBePrinted()
     * @uses Invoice::setToBeEmailed()
     * @uses Invoice::setToBeFaxed()
     * @uses Invoice::setFax()
     * @uses Invoice::setMessageSel()
     * @uses Invoice::setMessage()
     * @uses Invoice::setBillingAddress()
     * @uses Invoice::setBillAddressList()
     * @uses Invoice::setShippingAddress()
     * @uses Invoice::setShipIsResidential()
     * @uses Invoice::setShipAddressList()
     * @uses Invoice::setFob()
     * @uses Invoice::setShipDate()
     * @uses Invoice::setShipMethod()
     * @uses Invoice::setShippingCost()
     * @uses Invoice::setShippingTax1Rate()
     * @uses Invoice::setShippingTax2Rate()
     * @uses Invoice::setShippingTaxCode()
     * @uses Invoice::setHandlingTaxCode()
     * @uses Invoice::setHandlingTax1Rate()
     * @uses Invoice::setHandlingCost()
     * @uses Invoice::setHandlingTax2Rate()
     * @uses Invoice::setTrackingNumbers()
     * @uses Invoice::setLinkedTrackingNumbers()
     * @uses Invoice::setSalesGroup()
     * @uses Invoice::setSubTotal()
     * @uses Invoice::setCanHaveStackable()
     * @uses Invoice::setRevenueStatus()
     * @uses Invoice::setRecognizedRevenue()
     * @uses Invoice::setDeferredRevenue()
     * @uses Invoice::setRevRecOnRevCommitment()
     * @uses Invoice::setSyncSalesTeams()
     * @uses Invoice::setDiscountTotal()
     * @uses Invoice::setTaxTotal()
     * @uses Invoice::setAltShippingCost()
     * @uses Invoice::setAltHandlingCost()
     * @uses Invoice::setTotal()
     * @uses Invoice::setStatus()
     * @uses Invoice::setJob()
     * @uses Invoice::setBillingSchedule()
     * @uses Invoice::setEmail()
     * @uses Invoice::setTax2Total()
     * @uses Invoice::setVatRegNum()
     * @uses Invoice::setExpCostDiscount()
     * @uses Invoice::setItemCostDiscount()
     * @uses Invoice::setTimeDiscount()
     * @uses Invoice::setExpCostDiscRate()
     * @uses Invoice::setItemCostDiscRate()
     * @uses Invoice::setTimeDiscRate()
     * @uses Invoice::setExpCostDiscAmount()
     * @uses Invoice::setExpCostTaxRate1()
     * @uses Invoice::setExpCostTaxRate2()
     * @uses Invoice::setItemCostDiscAmount()
     * @uses Invoice::setExpCostTaxCode()
     * @uses Invoice::setExpCostDiscTax1Amt()
     * @uses Invoice::setItemCostTaxRate1()
     * @uses Invoice::setTimeDiscAmount()
     * @uses Invoice::setItemCostTaxCode()
     * @uses Invoice::setExpCostDiscTaxable()
     * @uses Invoice::setItemCostDiscTaxable()
     * @uses Invoice::setItemCostTaxRate2()
     * @uses Invoice::setItemCostDiscTax1Amt()
     * @uses Invoice::setItemCostDiscPrint()
     * @uses Invoice::setTimeDiscTaxable()
     * @uses Invoice::setTimeTaxRate1()
     * @uses Invoice::setExpCostDiscPrint()
     * @uses Invoice::setTimeTaxCode()
     * @uses Invoice::setTimeDiscPrint()
     * @uses Invoice::setGiftCertApplied()
     * @uses Invoice::setTimeDiscTax1Amt()
     * @uses Invoice::setTranIsVsoeBundle()
     * @uses Invoice::setTimeTaxRate2()
     * @uses Invoice::setVsoeAutoCalc()
     * @uses Invoice::setSyncPartnerTeams()
     * @uses Invoice::setSalesTeamList()
     * @uses Invoice::setPartnersList()
     * @uses Invoice::setItemList()
     * @uses Invoice::setItemCostList()
     * @uses Invoice::setGiftCertRedemptionList()
     * @uses Invoice::setPromotionsList()
     * @uses Invoice::setExpCostList()
     * @uses Invoice::setTimeList()
     * @uses Invoice::setShipGroupList()
     * @uses Invoice::setApprovalStatus()
     * @uses Invoice::setAccountingBookDetailList()
     * @uses Invoice::setTaxDetailsList()
     * @uses Invoice::setCustomFieldList()
     * @uses Invoice::setInternalId()
     * @uses Invoice::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $nextApprover
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $billingAccount
     * @param bool $recurringBill
     * @param string $tranDate
     * @param string $tranId
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param string $source
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $opportunity
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $terms
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $currency
     * @param string $dueDate
     * @param string $discountDate
     * @param float $discountAmount
     * @param \StructType\RecordRef $salesRep
     * @param string $contribPct
     * @param \StructType\RecordRef $partner
     * @param \StructType\RecordRef $leadSource
     * @param string $startDate
     * @param string $endDate
     * @param string $otherRefNum
     * @param string $memo
     * @param string $salesEffectiveDate
     * @param bool $excludeCommission
     * @param float $totalCostEstimate
     * @param float $estGrossProfit
     * @param float $estGrossProfitPercent
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $revRecStartDate
     * @param string $revRecEndDate
     * @param float $amountPaid
     * @param float $amountRemaining
     * @param float $balance
     * @param \StructType\RecordRef $account
     * @param string $onCreditHold
     * @param float $exchangeRate
     * @param string $currencyName
     * @param \StructType\RecordRef $promoCode
     * @param \StructType\RecordRef $discountItem
     * @param string $discountRate
     * @param bool $isTaxable
     * @param \StructType\RecordRef $taxItem
     * @param float $taxRate
     * @param bool $toBePrinted
     * @param bool $toBeEmailed
     * @param bool $toBeFaxed
     * @param string $fax
     * @param \StructType\RecordRef $messageSel
     * @param string $message
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\Address $shippingAddress
     * @param bool $shipIsResidential
     * @param \StructType\RecordRef $shipAddressList
     * @param string $fob
     * @param string $shipDate
     * @param \StructType\RecordRef $shipMethod
     * @param float $shippingCost
     * @param float $shippingTax1Rate
     * @param string $shippingTax2Rate
     * @param \StructType\RecordRef $shippingTaxCode
     * @param \StructType\RecordRef $handlingTaxCode
     * @param float $handlingTax1Rate
     * @param float $handlingCost
     * @param string $handlingTax2Rate
     * @param string $trackingNumbers
     * @param string $linkedTrackingNumbers
     * @param \StructType\RecordRef $salesGroup
     * @param float $subTotal
     * @param bool $canHaveStackable
     * @param string $revenueStatus
     * @param float $recognizedRevenue
     * @param float $deferredRevenue
     * @param bool $revRecOnRevCommitment
     * @param bool $syncSalesTeams
     * @param float $discountTotal
     * @param float $taxTotal
     * @param float $altShippingCost
     * @param float $altHandlingCost
     * @param float $total
     * @param string $status
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $billingSchedule
     * @param string $email
     * @param float $tax2Total
     * @param string $vatRegNum
     * @param \StructType\RecordRef $expCostDiscount
     * @param \StructType\RecordRef $itemCostDiscount
     * @param \StructType\RecordRef $timeDiscount
     * @param string $expCostDiscRate
     * @param string $itemCostDiscRate
     * @param string $timeDiscRate
     * @param float $expCostDiscAmount
     * @param float $expCostTaxRate1
     * @param float $expCostTaxRate2
     * @param float $itemCostDiscAmount
     * @param \StructType\RecordRef $expCostTaxCode
     * @param float $expCostDiscTax1Amt
     * @param float $itemCostTaxRate1
     * @param float $timeDiscAmount
     * @param \StructType\RecordRef $itemCostTaxCode
     * @param bool $expCostDiscTaxable
     * @param bool $itemCostDiscTaxable
     * @param float $itemCostTaxRate2
     * @param float $itemCostDiscTax1Amt
     * @param bool $itemCostDiscPrint
     * @param bool $timeDiscTaxable
     * @param float $timeTaxRate1
     * @param bool $expCostDiscPrint
     * @param \StructType\RecordRef $timeTaxCode
     * @param bool $timeDiscPrint
     * @param float $giftCertApplied
     * @param float $timeDiscTax1Amt
     * @param bool $tranIsVsoeBundle
     * @param float $timeTaxRate2
     * @param bool $vsoeAutoCalc
     * @param bool $syncPartnerTeams
     * @param \StructType\InvoiceSalesTeamList $salesTeamList
     * @param \StructType\InvoicePartnersList $partnersList
     * @param \StructType\InvoiceItemList $itemList
     * @param \StructType\InvoiceItemCostList $itemCostList
     * @param \StructType\GiftCertRedemptionList $giftCertRedemptionList
     * @param \StructType\PromotionsList $promotionsList
     * @param \StructType\InvoiceExpCostList $expCostList
     * @param \StructType\InvoiceTimeList $timeList
     * @param \StructType\InvoiceShipGroupList $shipGroupList
     * @param \StructType\RecordRef $approvalStatus
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $nextApprover = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $billingAccount = null, $recurringBill = null, $tranDate = null, $tranId = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, $source = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $opportunity = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $terms = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $currency = null, $dueDate = null, $discountDate = null, $discountAmount = null, \StructType\RecordRef $salesRep = null, $contribPct = null, \StructType\RecordRef $partner = null, \StructType\RecordRef $leadSource = null, $startDate = null, $endDate = null, $otherRefNum = null, $memo = null, $salesEffectiveDate = null, $excludeCommission = null, $totalCostEstimate = null, $estGrossProfit = null, $estGrossProfitPercent = null, \StructType\RecordRef $revRecSchedule = null, $revRecStartDate = null, $revRecEndDate = null, $amountPaid = null, $amountRemaining = null, $balance = null, \StructType\RecordRef $account = null, $onCreditHold = null, $exchangeRate = null, $currencyName = null, \StructType\RecordRef $promoCode = null, \StructType\RecordRef $discountItem = null, $discountRate = null, $isTaxable = null, \StructType\RecordRef $taxItem = null, $taxRate = null, $toBePrinted = null, $toBeEmailed = null, $toBeFaxed = null, $fax = null, \StructType\RecordRef $messageSel = null, $message = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, \StructType\Address $shippingAddress = null, $shipIsResidential = null, \StructType\RecordRef $shipAddressList = null, $fob = null, $shipDate = null, \StructType\RecordRef $shipMethod = null, $shippingCost = null, $shippingTax1Rate = null, $shippingTax2Rate = null, \StructType\RecordRef $shippingTaxCode = null, \StructType\RecordRef $handlingTaxCode = null, $handlingTax1Rate = null, $handlingCost = null, $handlingTax2Rate = null, $trackingNumbers = null, $linkedTrackingNumbers = null, \StructType\RecordRef $salesGroup = null, $subTotal = null, $canHaveStackable = null, $revenueStatus = null, $recognizedRevenue = null, $deferredRevenue = null, $revRecOnRevCommitment = null, $syncSalesTeams = null, $discountTotal = null, $taxTotal = null, $altShippingCost = null, $altHandlingCost = null, $total = null, $status = null, \StructType\RecordRef $job = null, \StructType\RecordRef $billingSchedule = null, $email = null, $tax2Total = null, $vatRegNum = null, \StructType\RecordRef $expCostDiscount = null, \StructType\RecordRef $itemCostDiscount = null, \StructType\RecordRef $timeDiscount = null, $expCostDiscRate = null, $itemCostDiscRate = null, $timeDiscRate = null, $expCostDiscAmount = null, $expCostTaxRate1 = null, $expCostTaxRate2 = null, $itemCostDiscAmount = null, \StructType\RecordRef $expCostTaxCode = null, $expCostDiscTax1Amt = null, $itemCostTaxRate1 = null, $timeDiscAmount = null, \StructType\RecordRef $itemCostTaxCode = null, $expCostDiscTaxable = null, $itemCostDiscTaxable = null, $itemCostTaxRate2 = null, $itemCostDiscTax1Amt = null, $itemCostDiscPrint = null, $timeDiscTaxable = null, $timeTaxRate1 = null, $expCostDiscPrint = null, \StructType\RecordRef $timeTaxCode = null, $timeDiscPrint = null, $giftCertApplied = null, $timeDiscTax1Amt = null, $tranIsVsoeBundle = null, $timeTaxRate2 = null, $vsoeAutoCalc = null, $syncPartnerTeams = null, \StructType\InvoiceSalesTeamList $salesTeamList = null, \StructType\InvoicePartnersList $partnersList = null, \StructType\InvoiceItemList $itemList = null, \StructType\InvoiceItemCostList $itemCostList = null, \StructType\GiftCertRedemptionList $giftCertRedemptionList = null, \StructType\PromotionsList $promotionsList = null, \StructType\InvoiceExpCostList $expCostList = null, \StructType\InvoiceTimeList $timeList = null, \StructType\InvoiceShipGroupList $shipGroupList = null, \StructType\RecordRef $approvalStatus = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setNextApprover($nextApprover)
            ->setEntity($entity)
            ->setBillingAccount($billingAccount)
            ->setRecurringBill($recurringBill)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setSource($source)
            ->setCreatedFrom($createdFrom)
            ->setPostingPeriod($postingPeriod)
            ->setOpportunity($opportunity)
            ->setDepartment($department)
            ->setClass($class)
            ->setTerms($terms)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setCurrency($currency)
            ->setDueDate($dueDate)
            ->setDiscountDate($discountDate)
            ->setDiscountAmount($discountAmount)
            ->setSalesRep($salesRep)
            ->setContribPct($contribPct)
            ->setPartner($partner)
            ->setLeadSource($leadSource)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setOtherRefNum($otherRefNum)
            ->setMemo($memo)
            ->setSalesEffectiveDate($salesEffectiveDate)
            ->setExcludeCommission($excludeCommission)
            ->setTotalCostEstimate($totalCostEstimate)
            ->setEstGrossProfit($estGrossProfit)
            ->setEstGrossProfitPercent($estGrossProfitPercent)
            ->setRevRecSchedule($revRecSchedule)
            ->setRevRecStartDate($revRecStartDate)
            ->setRevRecEndDate($revRecEndDate)
            ->setAmountPaid($amountPaid)
            ->setAmountRemaining($amountRemaining)
            ->setBalance($balance)
            ->setAccount($account)
            ->setOnCreditHold($onCreditHold)
            ->setExchangeRate($exchangeRate)
            ->setCurrencyName($currencyName)
            ->setPromoCode($promoCode)
            ->setDiscountItem($discountItem)
            ->setDiscountRate($discountRate)
            ->setIsTaxable($isTaxable)
            ->setTaxItem($taxItem)
            ->setTaxRate($taxRate)
            ->setToBePrinted($toBePrinted)
            ->setToBeEmailed($toBeEmailed)
            ->setToBeFaxed($toBeFaxed)
            ->setFax($fax)
            ->setMessageSel($messageSel)
            ->setMessage($message)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setShippingAddress($shippingAddress)
            ->setShipIsResidential($shipIsResidential)
            ->setShipAddressList($shipAddressList)
            ->setFob($fob)
            ->setShipDate($shipDate)
            ->setShipMethod($shipMethod)
            ->setShippingCost($shippingCost)
            ->setShippingTax1Rate($shippingTax1Rate)
            ->setShippingTax2Rate($shippingTax2Rate)
            ->setShippingTaxCode($shippingTaxCode)
            ->setHandlingTaxCode($handlingTaxCode)
            ->setHandlingTax1Rate($handlingTax1Rate)
            ->setHandlingCost($handlingCost)
            ->setHandlingTax2Rate($handlingTax2Rate)
            ->setTrackingNumbers($trackingNumbers)
            ->setLinkedTrackingNumbers($linkedTrackingNumbers)
            ->setSalesGroup($salesGroup)
            ->setSubTotal($subTotal)
            ->setCanHaveStackable($canHaveStackable)
            ->setRevenueStatus($revenueStatus)
            ->setRecognizedRevenue($recognizedRevenue)
            ->setDeferredRevenue($deferredRevenue)
            ->setRevRecOnRevCommitment($revRecOnRevCommitment)
            ->setSyncSalesTeams($syncSalesTeams)
            ->setDiscountTotal($discountTotal)
            ->setTaxTotal($taxTotal)
            ->setAltShippingCost($altShippingCost)
            ->setAltHandlingCost($altHandlingCost)
            ->setTotal($total)
            ->setStatus($status)
            ->setJob($job)
            ->setBillingSchedule($billingSchedule)
            ->setEmail($email)
            ->setTax2Total($tax2Total)
            ->setVatRegNum($vatRegNum)
            ->setExpCostDiscount($expCostDiscount)
            ->setItemCostDiscount($itemCostDiscount)
            ->setTimeDiscount($timeDiscount)
            ->setExpCostDiscRate($expCostDiscRate)
            ->setItemCostDiscRate($itemCostDiscRate)
            ->setTimeDiscRate($timeDiscRate)
            ->setExpCostDiscAmount($expCostDiscAmount)
            ->setExpCostTaxRate1($expCostTaxRate1)
            ->setExpCostTaxRate2($expCostTaxRate2)
            ->setItemCostDiscAmount($itemCostDiscAmount)
            ->setExpCostTaxCode($expCostTaxCode)
            ->setExpCostDiscTax1Amt($expCostDiscTax1Amt)
            ->setItemCostTaxRate1($itemCostTaxRate1)
            ->setTimeDiscAmount($timeDiscAmount)
            ->setItemCostTaxCode($itemCostTaxCode)
            ->setExpCostDiscTaxable($expCostDiscTaxable)
            ->setItemCostDiscTaxable($itemCostDiscTaxable)
            ->setItemCostTaxRate2($itemCostTaxRate2)
            ->setItemCostDiscTax1Amt($itemCostDiscTax1Amt)
            ->setItemCostDiscPrint($itemCostDiscPrint)
            ->setTimeDiscTaxable($timeDiscTaxable)
            ->setTimeTaxRate1($timeTaxRate1)
            ->setExpCostDiscPrint($expCostDiscPrint)
            ->setTimeTaxCode($timeTaxCode)
            ->setTimeDiscPrint($timeDiscPrint)
            ->setGiftCertApplied($giftCertApplied)
            ->setTimeDiscTax1Amt($timeDiscTax1Amt)
            ->setTranIsVsoeBundle($tranIsVsoeBundle)
            ->setTimeTaxRate2($timeTaxRate2)
            ->setVsoeAutoCalc($vsoeAutoCalc)
            ->setSyncPartnerTeams($syncPartnerTeams)
            ->setSalesTeamList($salesTeamList)
            ->setPartnersList($partnersList)
            ->setItemList($itemList)
            ->setItemCostList($itemCostList)
            ->setGiftCertRedemptionList($giftCertRedemptionList)
            ->setPromotionsList($promotionsList)
            ->setExpCostList($expCostList)
            ->setTimeList($timeList)
            ->setShipGroupList($shipGroupList)
            ->setApprovalStatus($approvalStatus)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Invoice
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Invoice
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\Invoice
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\Invoice
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\Invoice
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\Invoice
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Invoice
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\RecordRef|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * Set nextApprover value
     * @param \StructType\RecordRef $nextApprover
     * @return \StructType\Invoice
     */
    public function setNextApprover(\StructType\RecordRef $nextApprover = null)
    {
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\Invoice
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get billingAccount value
     * @return \StructType\RecordRef|null
     */
    public function getBillingAccount()
    {
        return $this->billingAccount;
    }
    /**
     * Set billingAccount value
     * @param \StructType\RecordRef $billingAccount
     * @return \StructType\Invoice
     */
    public function setBillingAccount(\StructType\RecordRef $billingAccount = null)
    {
        $this->billingAccount = $billingAccount;
        return $this;
    }
    /**
     * Get recurringBill value
     * @return bool|null
     */
    public function getRecurringBill()
    {
        return $this->recurringBill;
    }
    /**
     * Set recurringBill value
     * @param bool $recurringBill
     * @return \StructType\Invoice
     */
    public function setRecurringBill($recurringBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($recurringBill) && !is_bool($recurringBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recurringBill, true), gettype($recurringBill)), __LINE__);
        }
        $this->recurringBill = $recurringBill;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\Invoice
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\Invoice
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\Invoice
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\Invoice
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\Invoice
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\Invoice
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\Invoice
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get opportunity value
     * @return \StructType\RecordRef|null
     */
    public function getOpportunity()
    {
        return $this->opportunity;
    }
    /**
     * Set opportunity value
     * @param \StructType\RecordRef $opportunity
     * @return \StructType\Invoice
     */
    public function setOpportunity(\StructType\RecordRef $opportunity = null)
    {
        $this->opportunity = $opportunity;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Invoice
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Invoice
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get terms value
     * @return \StructType\RecordRef|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param \StructType\RecordRef $terms
     * @return \StructType\Invoice
     */
    public function setTerms(\StructType\RecordRef $terms = null)
    {
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Invoice
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Invoice
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Invoice
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\Invoice
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get discountDate value
     * @return string|null
     */
    public function getDiscountDate()
    {
        return $this->discountDate;
    }
    /**
     * Set discountDate value
     * @param string $discountDate
     * @return \StructType\Invoice
     */
    public function setDiscountDate($discountDate = null)
    {
        // validation for constraint: string
        if (!is_null($discountDate) && !is_string($discountDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountDate, true), gettype($discountDate)), __LINE__);
        }
        $this->discountDate = $discountDate;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param float $discountAmount
     * @return \StructType\Invoice
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get salesRep value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRep()
    {
        return $this->salesRep;
    }
    /**
     * Set salesRep value
     * @param \StructType\RecordRef $salesRep
     * @return \StructType\Invoice
     */
    public function setSalesRep(\StructType\RecordRef $salesRep = null)
    {
        $this->salesRep = $salesRep;
        return $this;
    }
    /**
     * Get contribPct value
     * @return string|null
     */
    public function getContribPct()
    {
        return $this->contribPct;
    }
    /**
     * Set contribPct value
     * @param string $contribPct
     * @return \StructType\Invoice
     */
    public function setContribPct($contribPct = null)
    {
        // validation for constraint: string
        if (!is_null($contribPct) && !is_string($contribPct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contribPct, true), gettype($contribPct)), __LINE__);
        }
        $this->contribPct = $contribPct;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\Invoice
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\RecordRef|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\RecordRef $leadSource
     * @return \StructType\Invoice
     */
    public function setLeadSource(\StructType\RecordRef $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Invoice
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Invoice
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get otherRefNum value
     * @return string|null
     */
    public function getOtherRefNum()
    {
        return $this->otherRefNum;
    }
    /**
     * Set otherRefNum value
     * @param string $otherRefNum
     * @return \StructType\Invoice
     */
    public function setOtherRefNum($otherRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($otherRefNum) && !is_string($otherRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRefNum, true), gettype($otherRefNum)), __LINE__);
        }
        $this->otherRefNum = $otherRefNum;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\Invoice
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get salesEffectiveDate value
     * @return string|null
     */
    public function getSalesEffectiveDate()
    {
        return $this->salesEffectiveDate;
    }
    /**
     * Set salesEffectiveDate value
     * @param string $salesEffectiveDate
     * @return \StructType\Invoice
     */
    public function setSalesEffectiveDate($salesEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($salesEffectiveDate) && !is_string($salesEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesEffectiveDate, true), gettype($salesEffectiveDate)), __LINE__);
        }
        $this->salesEffectiveDate = $salesEffectiveDate;
        return $this;
    }
    /**
     * Get excludeCommission value
     * @return bool|null
     */
    public function getExcludeCommission()
    {
        return $this->excludeCommission;
    }
    /**
     * Set excludeCommission value
     * @param bool $excludeCommission
     * @return \StructType\Invoice
     */
    public function setExcludeCommission($excludeCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeCommission) && !is_bool($excludeCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeCommission, true), gettype($excludeCommission)), __LINE__);
        }
        $this->excludeCommission = $excludeCommission;
        return $this;
    }
    /**
     * Get totalCostEstimate value
     * @return float|null
     */
    public function getTotalCostEstimate()
    {
        return $this->totalCostEstimate;
    }
    /**
     * Set totalCostEstimate value
     * @param float $totalCostEstimate
     * @return \StructType\Invoice
     */
    public function setTotalCostEstimate($totalCostEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($totalCostEstimate) && !(is_float($totalCostEstimate) || is_numeric($totalCostEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCostEstimate, true), gettype($totalCostEstimate)), __LINE__);
        }
        $this->totalCostEstimate = $totalCostEstimate;
        return $this;
    }
    /**
     * Get estGrossProfit value
     * @return float|null
     */
    public function getEstGrossProfit()
    {
        return $this->estGrossProfit;
    }
    /**
     * Set estGrossProfit value
     * @param float $estGrossProfit
     * @return \StructType\Invoice
     */
    public function setEstGrossProfit($estGrossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfit) && !(is_float($estGrossProfit) || is_numeric($estGrossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfit, true), gettype($estGrossProfit)), __LINE__);
        }
        $this->estGrossProfit = $estGrossProfit;
        return $this;
    }
    /**
     * Get estGrossProfitPercent value
     * @return float|null
     */
    public function getEstGrossProfitPercent()
    {
        return $this->estGrossProfitPercent;
    }
    /**
     * Set estGrossProfitPercent value
     * @param float $estGrossProfitPercent
     * @return \StructType\Invoice
     */
    public function setEstGrossProfitPercent($estGrossProfitPercent = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfitPercent) && !(is_float($estGrossProfitPercent) || is_numeric($estGrossProfitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfitPercent, true), gettype($estGrossProfitPercent)), __LINE__);
        }
        $this->estGrossProfitPercent = $estGrossProfitPercent;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\Invoice
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return string|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * Set revRecStartDate value
     * @param string $revRecStartDate
     * @return \StructType\Invoice
     */
    public function setRevRecStartDate($revRecStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecStartDate) && !is_string($revRecStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecStartDate, true), gettype($revRecStartDate)), __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return string|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * Set revRecEndDate value
     * @param string $revRecEndDate
     * @return \StructType\Invoice
     */
    public function setRevRecEndDate($revRecEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecEndDate) && !is_string($revRecEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecEndDate, true), gettype($revRecEndDate)), __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Get amountPaid value
     * @return float|null
     */
    public function getAmountPaid()
    {
        return $this->amountPaid;
    }
    /**
     * Set amountPaid value
     * @param float $amountPaid
     * @return \StructType\Invoice
     */
    public function setAmountPaid($amountPaid = null)
    {
        // validation for constraint: float
        if (!is_null($amountPaid) && !(is_float($amountPaid) || is_numeric($amountPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountPaid, true), gettype($amountPaid)), __LINE__);
        }
        $this->amountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get amountRemaining value
     * @return float|null
     */
    public function getAmountRemaining()
    {
        return $this->amountRemaining;
    }
    /**
     * Set amountRemaining value
     * @param float $amountRemaining
     * @return \StructType\Invoice
     */
    public function setAmountRemaining($amountRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($amountRemaining) && !(is_float($amountRemaining) || is_numeric($amountRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountRemaining, true), gettype($amountRemaining)), __LINE__);
        }
        $this->amountRemaining = $amountRemaining;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\Invoice
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\Invoice
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get onCreditHold value
     * @return string|null
     */
    public function getOnCreditHold()
    {
        return $this->onCreditHold;
    }
    /**
     * Set onCreditHold value
     * @param string $onCreditHold
     * @return \StructType\Invoice
     */
    public function setOnCreditHold($onCreditHold = null)
    {
        // validation for constraint: string
        if (!is_null($onCreditHold) && !is_string($onCreditHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onCreditHold, true), gettype($onCreditHold)), __LINE__);
        }
        $this->onCreditHold = $onCreditHold;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Invoice
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\Invoice
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get promoCode value
     * @return \StructType\RecordRef|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param \StructType\RecordRef $promoCode
     * @return \StructType\Invoice
     */
    public function setPromoCode(\StructType\RecordRef $promoCode = null)
    {
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get discountItem value
     * @return \StructType\RecordRef|null
     */
    public function getDiscountItem()
    {
        return $this->discountItem;
    }
    /**
     * Set discountItem value
     * @param \StructType\RecordRef $discountItem
     * @return \StructType\Invoice
     */
    public function setDiscountItem(\StructType\RecordRef $discountItem = null)
    {
        $this->discountItem = $discountItem;
        return $this;
    }
    /**
     * Get discountRate value
     * @return string|null
     */
    public function getDiscountRate()
    {
        return $this->discountRate;
    }
    /**
     * Set discountRate value
     * @param string $discountRate
     * @return \StructType\Invoice
     */
    public function setDiscountRate($discountRate = null)
    {
        // validation for constraint: string
        if (!is_null($discountRate) && !is_string($discountRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountRate, true), gettype($discountRate)), __LINE__);
        }
        $this->discountRate = $discountRate;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\Invoice
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get taxItem value
     * @return \StructType\RecordRef|null
     */
    public function getTaxItem()
    {
        return $this->taxItem;
    }
    /**
     * Set taxItem value
     * @param \StructType\RecordRef $taxItem
     * @return \StructType\Invoice
     */
    public function setTaxItem(\StructType\RecordRef $taxItem = null)
    {
        $this->taxItem = $taxItem;
        return $this;
    }
    /**
     * Get taxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * Set taxRate value
     * @param float $taxRate
     * @return \StructType\Invoice
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\Invoice
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get toBeEmailed value
     * @return bool|null
     */
    public function getToBeEmailed()
    {
        return $this->toBeEmailed;
    }
    /**
     * Set toBeEmailed value
     * @param bool $toBeEmailed
     * @return \StructType\Invoice
     */
    public function setToBeEmailed($toBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeEmailed) && !is_bool($toBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeEmailed, true), gettype($toBeEmailed)), __LINE__);
        }
        $this->toBeEmailed = $toBeEmailed;
        return $this;
    }
    /**
     * Get toBeFaxed value
     * @return bool|null
     */
    public function getToBeFaxed()
    {
        return $this->toBeFaxed;
    }
    /**
     * Set toBeFaxed value
     * @param bool $toBeFaxed
     * @return \StructType\Invoice
     */
    public function setToBeFaxed($toBeFaxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeFaxed) && !is_bool($toBeFaxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeFaxed, true), gettype($toBeFaxed)), __LINE__);
        }
        $this->toBeFaxed = $toBeFaxed;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Invoice
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get messageSel value
     * @return \StructType\RecordRef|null
     */
    public function getMessageSel()
    {
        return $this->messageSel;
    }
    /**
     * Set messageSel value
     * @param \StructType\RecordRef $messageSel
     * @return \StructType\Invoice
     */
    public function setMessageSel(\StructType\RecordRef $messageSel = null)
    {
        $this->messageSel = $messageSel;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Invoice
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\Invoice
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\Invoice
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\Invoice
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shipIsResidential value
     * @return bool|null
     */
    public function getShipIsResidential()
    {
        return $this->shipIsResidential;
    }
    /**
     * Set shipIsResidential value
     * @param bool $shipIsResidential
     * @return \StructType\Invoice
     */
    public function setShipIsResidential($shipIsResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIsResidential) && !is_bool($shipIsResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIsResidential, true), gettype($shipIsResidential)), __LINE__);
        }
        $this->shipIsResidential = $shipIsResidential;
        return $this;
    }
    /**
     * Get shipAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddressList()
    {
        return $this->shipAddressList;
    }
    /**
     * Set shipAddressList value
     * @param \StructType\RecordRef $shipAddressList
     * @return \StructType\Invoice
     */
    public function setShipAddressList(\StructType\RecordRef $shipAddressList = null)
    {
        $this->shipAddressList = $shipAddressList;
        return $this;
    }
    /**
     * Get fob value
     * @return string|null
     */
    public function getFob()
    {
        return $this->fob;
    }
    /**
     * Set fob value
     * @param string $fob
     * @return \StructType\Invoice
     */
    public function setFob($fob = null)
    {
        // validation for constraint: string
        if (!is_null($fob) && !is_string($fob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fob, true), gettype($fob)), __LINE__);
        }
        $this->fob = $fob;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\Invoice
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\Invoice
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\Invoice
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get shippingTax1Rate value
     * @return float|null
     */
    public function getShippingTax1Rate()
    {
        return $this->shippingTax1Rate;
    }
    /**
     * Set shippingTax1Rate value
     * @param float $shippingTax1Rate
     * @return \StructType\Invoice
     */
    public function setShippingTax1Rate($shippingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTax1Rate) && !(is_float($shippingTax1Rate) || is_numeric($shippingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTax1Rate, true), gettype($shippingTax1Rate)), __LINE__);
        }
        $this->shippingTax1Rate = $shippingTax1Rate;
        return $this;
    }
    /**
     * Get shippingTax2Rate value
     * @return string|null
     */
    public function getShippingTax2Rate()
    {
        return $this->shippingTax2Rate;
    }
    /**
     * Set shippingTax2Rate value
     * @param string $shippingTax2Rate
     * @return \StructType\Invoice
     */
    public function setShippingTax2Rate($shippingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingTax2Rate) && !is_string($shippingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingTax2Rate, true), gettype($shippingTax2Rate)), __LINE__);
        }
        $this->shippingTax2Rate = $shippingTax2Rate;
        return $this;
    }
    /**
     * Get shippingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getShippingTaxCode()
    {
        return $this->shippingTaxCode;
    }
    /**
     * Set shippingTaxCode value
     * @param \StructType\RecordRef $shippingTaxCode
     * @return \StructType\Invoice
     */
    public function setShippingTaxCode(\StructType\RecordRef $shippingTaxCode = null)
    {
        $this->shippingTaxCode = $shippingTaxCode;
        return $this;
    }
    /**
     * Get handlingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getHandlingTaxCode()
    {
        return $this->handlingTaxCode;
    }
    /**
     * Set handlingTaxCode value
     * @param \StructType\RecordRef $handlingTaxCode
     * @return \StructType\Invoice
     */
    public function setHandlingTaxCode(\StructType\RecordRef $handlingTaxCode = null)
    {
        $this->handlingTaxCode = $handlingTaxCode;
        return $this;
    }
    /**
     * Get handlingTax1Rate value
     * @return float|null
     */
    public function getHandlingTax1Rate()
    {
        return $this->handlingTax1Rate;
    }
    /**
     * Set handlingTax1Rate value
     * @param float $handlingTax1Rate
     * @return \StructType\Invoice
     */
    public function setHandlingTax1Rate($handlingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTax1Rate) && !(is_float($handlingTax1Rate) || is_numeric($handlingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTax1Rate, true), gettype($handlingTax1Rate)), __LINE__);
        }
        $this->handlingTax1Rate = $handlingTax1Rate;
        return $this;
    }
    /**
     * Get handlingCost value
     * @return float|null
     */
    public function getHandlingCost()
    {
        return $this->handlingCost;
    }
    /**
     * Set handlingCost value
     * @param float $handlingCost
     * @return \StructType\Invoice
     */
    public function setHandlingCost($handlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($handlingCost) && !(is_float($handlingCost) || is_numeric($handlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingCost, true), gettype($handlingCost)), __LINE__);
        }
        $this->handlingCost = $handlingCost;
        return $this;
    }
    /**
     * Get handlingTax2Rate value
     * @return string|null
     */
    public function getHandlingTax2Rate()
    {
        return $this->handlingTax2Rate;
    }
    /**
     * Set handlingTax2Rate value
     * @param string $handlingTax2Rate
     * @return \StructType\Invoice
     */
    public function setHandlingTax2Rate($handlingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($handlingTax2Rate) && !is_string($handlingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingTax2Rate, true), gettype($handlingTax2Rate)), __LINE__);
        }
        $this->handlingTax2Rate = $handlingTax2Rate;
        return $this;
    }
    /**
     * Get trackingNumbers value
     * @return string|null
     */
    public function getTrackingNumbers()
    {
        return $this->trackingNumbers;
    }
    /**
     * Set trackingNumbers value
     * @param string $trackingNumbers
     * @return \StructType\Invoice
     */
    public function setTrackingNumbers($trackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumbers) && !is_string($trackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumbers, true), gettype($trackingNumbers)), __LINE__);
        }
        $this->trackingNumbers = $trackingNumbers;
        return $this;
    }
    /**
     * Get linkedTrackingNumbers value
     * @return string|null
     */
    public function getLinkedTrackingNumbers()
    {
        return $this->linkedTrackingNumbers;
    }
    /**
     * Set linkedTrackingNumbers value
     * @param string $linkedTrackingNumbers
     * @return \StructType\Invoice
     */
    public function setLinkedTrackingNumbers($linkedTrackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($linkedTrackingNumbers) && !is_string($linkedTrackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedTrackingNumbers, true), gettype($linkedTrackingNumbers)), __LINE__);
        }
        $this->linkedTrackingNumbers = $linkedTrackingNumbers;
        return $this;
    }
    /**
     * Get salesGroup value
     * @return \StructType\RecordRef|null
     */
    public function getSalesGroup()
    {
        return $this->salesGroup;
    }
    /**
     * Set salesGroup value
     * @param \StructType\RecordRef $salesGroup
     * @return \StructType\Invoice
     */
    public function setSalesGroup(\StructType\RecordRef $salesGroup = null)
    {
        $this->salesGroup = $salesGroup;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\Invoice
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get canHaveStackable value
     * @return bool|null
     */
    public function getCanHaveStackable()
    {
        return $this->canHaveStackable;
    }
    /**
     * Set canHaveStackable value
     * @param bool $canHaveStackable
     * @return \StructType\Invoice
     */
    public function setCanHaveStackable($canHaveStackable = null)
    {
        // validation for constraint: boolean
        if (!is_null($canHaveStackable) && !is_bool($canHaveStackable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canHaveStackable, true), gettype($canHaveStackable)), __LINE__);
        }
        $this->canHaveStackable = $canHaveStackable;
        return $this;
    }
    /**
     * Get revenueStatus value
     * @return string|null
     */
    public function getRevenueStatus()
    {
        return $this->revenueStatus;
    }
    /**
     * Set revenueStatus value
     * @uses \EnumType\RevenueStatus::valueIsValid()
     * @uses \EnumType\RevenueStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $revenueStatus
     * @return \StructType\Invoice
     */
    public function setRevenueStatus($revenueStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RevenueStatus::valueIsValid($revenueStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RevenueStatus', is_array($revenueStatus) ? implode(', ', $revenueStatus) : var_export($revenueStatus, true), implode(', ', \EnumType\RevenueStatus::getValidValues())), __LINE__);
        }
        $this->revenueStatus = $revenueStatus;
        return $this;
    }
    /**
     * Get recognizedRevenue value
     * @return float|null
     */
    public function getRecognizedRevenue()
    {
        return $this->recognizedRevenue;
    }
    /**
     * Set recognizedRevenue value
     * @param float $recognizedRevenue
     * @return \StructType\Invoice
     */
    public function setRecognizedRevenue($recognizedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($recognizedRevenue) && !(is_float($recognizedRevenue) || is_numeric($recognizedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recognizedRevenue, true), gettype($recognizedRevenue)), __LINE__);
        }
        $this->recognizedRevenue = $recognizedRevenue;
        return $this;
    }
    /**
     * Get deferredRevenue value
     * @return float|null
     */
    public function getDeferredRevenue()
    {
        return $this->deferredRevenue;
    }
    /**
     * Set deferredRevenue value
     * @param float $deferredRevenue
     * @return \StructType\Invoice
     */
    public function setDeferredRevenue($deferredRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($deferredRevenue) && !(is_float($deferredRevenue) || is_numeric($deferredRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deferredRevenue, true), gettype($deferredRevenue)), __LINE__);
        }
        $this->deferredRevenue = $deferredRevenue;
        return $this;
    }
    /**
     * Get revRecOnRevCommitment value
     * @return bool|null
     */
    public function getRevRecOnRevCommitment()
    {
        return $this->revRecOnRevCommitment;
    }
    /**
     * Set revRecOnRevCommitment value
     * @param bool $revRecOnRevCommitment
     * @return \StructType\Invoice
     */
    public function setRevRecOnRevCommitment($revRecOnRevCommitment = null)
    {
        // validation for constraint: boolean
        if (!is_null($revRecOnRevCommitment) && !is_bool($revRecOnRevCommitment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($revRecOnRevCommitment, true), gettype($revRecOnRevCommitment)), __LINE__);
        }
        $this->revRecOnRevCommitment = $revRecOnRevCommitment;
        return $this;
    }
    /**
     * Get syncSalesTeams value
     * @return bool|null
     */
    public function getSyncSalesTeams()
    {
        return $this->syncSalesTeams;
    }
    /**
     * Set syncSalesTeams value
     * @param bool $syncSalesTeams
     * @return \StructType\Invoice
     */
    public function setSyncSalesTeams($syncSalesTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncSalesTeams) && !is_bool($syncSalesTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncSalesTeams, true), gettype($syncSalesTeams)), __LINE__);
        }
        $this->syncSalesTeams = $syncSalesTeams;
        return $this;
    }
    /**
     * Get discountTotal value
     * @return float|null
     */
    public function getDiscountTotal()
    {
        return $this->discountTotal;
    }
    /**
     * Set discountTotal value
     * @param float $discountTotal
     * @return \StructType\Invoice
     */
    public function setDiscountTotal($discountTotal = null)
    {
        // validation for constraint: float
        if (!is_null($discountTotal) && !(is_float($discountTotal) || is_numeric($discountTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountTotal, true), gettype($discountTotal)), __LINE__);
        }
        $this->discountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\Invoice
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get altShippingCost value
     * @return float|null
     */
    public function getAltShippingCost()
    {
        return $this->altShippingCost;
    }
    /**
     * Set altShippingCost value
     * @param float $altShippingCost
     * @return \StructType\Invoice
     */
    public function setAltShippingCost($altShippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altShippingCost) && !(is_float($altShippingCost) || is_numeric($altShippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altShippingCost, true), gettype($altShippingCost)), __LINE__);
        }
        $this->altShippingCost = $altShippingCost;
        return $this;
    }
    /**
     * Get altHandlingCost value
     * @return float|null
     */
    public function getAltHandlingCost()
    {
        return $this->altHandlingCost;
    }
    /**
     * Set altHandlingCost value
     * @param float $altHandlingCost
     * @return \StructType\Invoice
     */
    public function setAltHandlingCost($altHandlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altHandlingCost) && !(is_float($altHandlingCost) || is_numeric($altHandlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altHandlingCost, true), gettype($altHandlingCost)), __LINE__);
        }
        $this->altHandlingCost = $altHandlingCost;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\Invoice
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Invoice
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\Invoice
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\Invoice
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Invoice
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\Invoice
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\Invoice
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get expCostDiscount value
     * @return \StructType\RecordRef|null
     */
    public function getExpCostDiscount()
    {
        return $this->expCostDiscount;
    }
    /**
     * Set expCostDiscount value
     * @param \StructType\RecordRef $expCostDiscount
     * @return \StructType\Invoice
     */
    public function setExpCostDiscount(\StructType\RecordRef $expCostDiscount = null)
    {
        $this->expCostDiscount = $expCostDiscount;
        return $this;
    }
    /**
     * Get itemCostDiscount value
     * @return \StructType\RecordRef|null
     */
    public function getItemCostDiscount()
    {
        return $this->itemCostDiscount;
    }
    /**
     * Set itemCostDiscount value
     * @param \StructType\RecordRef $itemCostDiscount
     * @return \StructType\Invoice
     */
    public function setItemCostDiscount(\StructType\RecordRef $itemCostDiscount = null)
    {
        $this->itemCostDiscount = $itemCostDiscount;
        return $this;
    }
    /**
     * Get timeDiscount value
     * @return \StructType\RecordRef|null
     */
    public function getTimeDiscount()
    {
        return $this->timeDiscount;
    }
    /**
     * Set timeDiscount value
     * @param \StructType\RecordRef $timeDiscount
     * @return \StructType\Invoice
     */
    public function setTimeDiscount(\StructType\RecordRef $timeDiscount = null)
    {
        $this->timeDiscount = $timeDiscount;
        return $this;
    }
    /**
     * Get expCostDiscRate value
     * @return string|null
     */
    public function getExpCostDiscRate()
    {
        return $this->expCostDiscRate;
    }
    /**
     * Set expCostDiscRate value
     * @param string $expCostDiscRate
     * @return \StructType\Invoice
     */
    public function setExpCostDiscRate($expCostDiscRate = null)
    {
        // validation for constraint: string
        if (!is_null($expCostDiscRate) && !is_string($expCostDiscRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expCostDiscRate, true), gettype($expCostDiscRate)), __LINE__);
        }
        $this->expCostDiscRate = $expCostDiscRate;
        return $this;
    }
    /**
     * Get itemCostDiscRate value
     * @return string|null
     */
    public function getItemCostDiscRate()
    {
        return $this->itemCostDiscRate;
    }
    /**
     * Set itemCostDiscRate value
     * @param string $itemCostDiscRate
     * @return \StructType\Invoice
     */
    public function setItemCostDiscRate($itemCostDiscRate = null)
    {
        // validation for constraint: string
        if (!is_null($itemCostDiscRate) && !is_string($itemCostDiscRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCostDiscRate, true), gettype($itemCostDiscRate)), __LINE__);
        }
        $this->itemCostDiscRate = $itemCostDiscRate;
        return $this;
    }
    /**
     * Get timeDiscRate value
     * @return string|null
     */
    public function getTimeDiscRate()
    {
        return $this->timeDiscRate;
    }
    /**
     * Set timeDiscRate value
     * @param string $timeDiscRate
     * @return \StructType\Invoice
     */
    public function setTimeDiscRate($timeDiscRate = null)
    {
        // validation for constraint: string
        if (!is_null($timeDiscRate) && !is_string($timeDiscRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDiscRate, true), gettype($timeDiscRate)), __LINE__);
        }
        $this->timeDiscRate = $timeDiscRate;
        return $this;
    }
    /**
     * Get expCostDiscAmount value
     * @return float|null
     */
    public function getExpCostDiscAmount()
    {
        return $this->expCostDiscAmount;
    }
    /**
     * Set expCostDiscAmount value
     * @param float $expCostDiscAmount
     * @return \StructType\Invoice
     */
    public function setExpCostDiscAmount($expCostDiscAmount = null)
    {
        // validation for constraint: float
        if (!is_null($expCostDiscAmount) && !(is_float($expCostDiscAmount) || is_numeric($expCostDiscAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expCostDiscAmount, true), gettype($expCostDiscAmount)), __LINE__);
        }
        $this->expCostDiscAmount = $expCostDiscAmount;
        return $this;
    }
    /**
     * Get expCostTaxRate1 value
     * @return float|null
     */
    public function getExpCostTaxRate1()
    {
        return $this->expCostTaxRate1;
    }
    /**
     * Set expCostTaxRate1 value
     * @param float $expCostTaxRate1
     * @return \StructType\Invoice
     */
    public function setExpCostTaxRate1($expCostTaxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($expCostTaxRate1) && !(is_float($expCostTaxRate1) || is_numeric($expCostTaxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expCostTaxRate1, true), gettype($expCostTaxRate1)), __LINE__);
        }
        $this->expCostTaxRate1 = $expCostTaxRate1;
        return $this;
    }
    /**
     * Get expCostTaxRate2 value
     * @return float|null
     */
    public function getExpCostTaxRate2()
    {
        return $this->expCostTaxRate2;
    }
    /**
     * Set expCostTaxRate2 value
     * @param float $expCostTaxRate2
     * @return \StructType\Invoice
     */
    public function setExpCostTaxRate2($expCostTaxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($expCostTaxRate2) && !(is_float($expCostTaxRate2) || is_numeric($expCostTaxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expCostTaxRate2, true), gettype($expCostTaxRate2)), __LINE__);
        }
        $this->expCostTaxRate2 = $expCostTaxRate2;
        return $this;
    }
    /**
     * Get itemCostDiscAmount value
     * @return float|null
     */
    public function getItemCostDiscAmount()
    {
        return $this->itemCostDiscAmount;
    }
    /**
     * Set itemCostDiscAmount value
     * @param float $itemCostDiscAmount
     * @return \StructType\Invoice
     */
    public function setItemCostDiscAmount($itemCostDiscAmount = null)
    {
        // validation for constraint: float
        if (!is_null($itemCostDiscAmount) && !(is_float($itemCostDiscAmount) || is_numeric($itemCostDiscAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemCostDiscAmount, true), gettype($itemCostDiscAmount)), __LINE__);
        }
        $this->itemCostDiscAmount = $itemCostDiscAmount;
        return $this;
    }
    /**
     * Get expCostTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getExpCostTaxCode()
    {
        return $this->expCostTaxCode;
    }
    /**
     * Set expCostTaxCode value
     * @param \StructType\RecordRef $expCostTaxCode
     * @return \StructType\Invoice
     */
    public function setExpCostTaxCode(\StructType\RecordRef $expCostTaxCode = null)
    {
        $this->expCostTaxCode = $expCostTaxCode;
        return $this;
    }
    /**
     * Get expCostDiscTax1Amt value
     * @return float|null
     */
    public function getExpCostDiscTax1Amt()
    {
        return $this->expCostDiscTax1Amt;
    }
    /**
     * Set expCostDiscTax1Amt value
     * @param float $expCostDiscTax1Amt
     * @return \StructType\Invoice
     */
    public function setExpCostDiscTax1Amt($expCostDiscTax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($expCostDiscTax1Amt) && !(is_float($expCostDiscTax1Amt) || is_numeric($expCostDiscTax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expCostDiscTax1Amt, true), gettype($expCostDiscTax1Amt)), __LINE__);
        }
        $this->expCostDiscTax1Amt = $expCostDiscTax1Amt;
        return $this;
    }
    /**
     * Get itemCostTaxRate1 value
     * @return float|null
     */
    public function getItemCostTaxRate1()
    {
        return $this->itemCostTaxRate1;
    }
    /**
     * Set itemCostTaxRate1 value
     * @param float $itemCostTaxRate1
     * @return \StructType\Invoice
     */
    public function setItemCostTaxRate1($itemCostTaxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($itemCostTaxRate1) && !(is_float($itemCostTaxRate1) || is_numeric($itemCostTaxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemCostTaxRate1, true), gettype($itemCostTaxRate1)), __LINE__);
        }
        $this->itemCostTaxRate1 = $itemCostTaxRate1;
        return $this;
    }
    /**
     * Get timeDiscAmount value
     * @return float|null
     */
    public function getTimeDiscAmount()
    {
        return $this->timeDiscAmount;
    }
    /**
     * Set timeDiscAmount value
     * @param float $timeDiscAmount
     * @return \StructType\Invoice
     */
    public function setTimeDiscAmount($timeDiscAmount = null)
    {
        // validation for constraint: float
        if (!is_null($timeDiscAmount) && !(is_float($timeDiscAmount) || is_numeric($timeDiscAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timeDiscAmount, true), gettype($timeDiscAmount)), __LINE__);
        }
        $this->timeDiscAmount = $timeDiscAmount;
        return $this;
    }
    /**
     * Get itemCostTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getItemCostTaxCode()
    {
        return $this->itemCostTaxCode;
    }
    /**
     * Set itemCostTaxCode value
     * @param \StructType\RecordRef $itemCostTaxCode
     * @return \StructType\Invoice
     */
    public function setItemCostTaxCode(\StructType\RecordRef $itemCostTaxCode = null)
    {
        $this->itemCostTaxCode = $itemCostTaxCode;
        return $this;
    }
    /**
     * Get expCostDiscTaxable value
     * @return bool|null
     */
    public function getExpCostDiscTaxable()
    {
        return $this->expCostDiscTaxable;
    }
    /**
     * Set expCostDiscTaxable value
     * @param bool $expCostDiscTaxable
     * @return \StructType\Invoice
     */
    public function setExpCostDiscTaxable($expCostDiscTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($expCostDiscTaxable) && !is_bool($expCostDiscTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expCostDiscTaxable, true), gettype($expCostDiscTaxable)), __LINE__);
        }
        $this->expCostDiscTaxable = $expCostDiscTaxable;
        return $this;
    }
    /**
     * Get itemCostDiscTaxable value
     * @return bool|null
     */
    public function getItemCostDiscTaxable()
    {
        return $this->itemCostDiscTaxable;
    }
    /**
     * Set itemCostDiscTaxable value
     * @param bool $itemCostDiscTaxable
     * @return \StructType\Invoice
     */
    public function setItemCostDiscTaxable($itemCostDiscTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemCostDiscTaxable) && !is_bool($itemCostDiscTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemCostDiscTaxable, true), gettype($itemCostDiscTaxable)), __LINE__);
        }
        $this->itemCostDiscTaxable = $itemCostDiscTaxable;
        return $this;
    }
    /**
     * Get itemCostTaxRate2 value
     * @return float|null
     */
    public function getItemCostTaxRate2()
    {
        return $this->itemCostTaxRate2;
    }
    /**
     * Set itemCostTaxRate2 value
     * @param float $itemCostTaxRate2
     * @return \StructType\Invoice
     */
    public function setItemCostTaxRate2($itemCostTaxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($itemCostTaxRate2) && !(is_float($itemCostTaxRate2) || is_numeric($itemCostTaxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemCostTaxRate2, true), gettype($itemCostTaxRate2)), __LINE__);
        }
        $this->itemCostTaxRate2 = $itemCostTaxRate2;
        return $this;
    }
    /**
     * Get itemCostDiscTax1Amt value
     * @return float|null
     */
    public function getItemCostDiscTax1Amt()
    {
        return $this->itemCostDiscTax1Amt;
    }
    /**
     * Set itemCostDiscTax1Amt value
     * @param float $itemCostDiscTax1Amt
     * @return \StructType\Invoice
     */
    public function setItemCostDiscTax1Amt($itemCostDiscTax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($itemCostDiscTax1Amt) && !(is_float($itemCostDiscTax1Amt) || is_numeric($itemCostDiscTax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemCostDiscTax1Amt, true), gettype($itemCostDiscTax1Amt)), __LINE__);
        }
        $this->itemCostDiscTax1Amt = $itemCostDiscTax1Amt;
        return $this;
    }
    /**
     * Get itemCostDiscPrint value
     * @return bool|null
     */
    public function getItemCostDiscPrint()
    {
        return $this->itemCostDiscPrint;
    }
    /**
     * Set itemCostDiscPrint value
     * @param bool $itemCostDiscPrint
     * @return \StructType\Invoice
     */
    public function setItemCostDiscPrint($itemCostDiscPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemCostDiscPrint) && !is_bool($itemCostDiscPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemCostDiscPrint, true), gettype($itemCostDiscPrint)), __LINE__);
        }
        $this->itemCostDiscPrint = $itemCostDiscPrint;
        return $this;
    }
    /**
     * Get timeDiscTaxable value
     * @return bool|null
     */
    public function getTimeDiscTaxable()
    {
        return $this->timeDiscTaxable;
    }
    /**
     * Set timeDiscTaxable value
     * @param bool $timeDiscTaxable
     * @return \StructType\Invoice
     */
    public function setTimeDiscTaxable($timeDiscTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($timeDiscTaxable) && !is_bool($timeDiscTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($timeDiscTaxable, true), gettype($timeDiscTaxable)), __LINE__);
        }
        $this->timeDiscTaxable = $timeDiscTaxable;
        return $this;
    }
    /**
     * Get timeTaxRate1 value
     * @return float|null
     */
    public function getTimeTaxRate1()
    {
        return $this->timeTaxRate1;
    }
    /**
     * Set timeTaxRate1 value
     * @param float $timeTaxRate1
     * @return \StructType\Invoice
     */
    public function setTimeTaxRate1($timeTaxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($timeTaxRate1) && !(is_float($timeTaxRate1) || is_numeric($timeTaxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timeTaxRate1, true), gettype($timeTaxRate1)), __LINE__);
        }
        $this->timeTaxRate1 = $timeTaxRate1;
        return $this;
    }
    /**
     * Get expCostDiscPrint value
     * @return bool|null
     */
    public function getExpCostDiscPrint()
    {
        return $this->expCostDiscPrint;
    }
    /**
     * Set expCostDiscPrint value
     * @param bool $expCostDiscPrint
     * @return \StructType\Invoice
     */
    public function setExpCostDiscPrint($expCostDiscPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($expCostDiscPrint) && !is_bool($expCostDiscPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expCostDiscPrint, true), gettype($expCostDiscPrint)), __LINE__);
        }
        $this->expCostDiscPrint = $expCostDiscPrint;
        return $this;
    }
    /**
     * Get timeTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTimeTaxCode()
    {
        return $this->timeTaxCode;
    }
    /**
     * Set timeTaxCode value
     * @param \StructType\RecordRef $timeTaxCode
     * @return \StructType\Invoice
     */
    public function setTimeTaxCode(\StructType\RecordRef $timeTaxCode = null)
    {
        $this->timeTaxCode = $timeTaxCode;
        return $this;
    }
    /**
     * Get timeDiscPrint value
     * @return bool|null
     */
    public function getTimeDiscPrint()
    {
        return $this->timeDiscPrint;
    }
    /**
     * Set timeDiscPrint value
     * @param bool $timeDiscPrint
     * @return \StructType\Invoice
     */
    public function setTimeDiscPrint($timeDiscPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($timeDiscPrint) && !is_bool($timeDiscPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($timeDiscPrint, true), gettype($timeDiscPrint)), __LINE__);
        }
        $this->timeDiscPrint = $timeDiscPrint;
        return $this;
    }
    /**
     * Get giftCertApplied value
     * @return float|null
     */
    public function getGiftCertApplied()
    {
        return $this->giftCertApplied;
    }
    /**
     * Set giftCertApplied value
     * @param float $giftCertApplied
     * @return \StructType\Invoice
     */
    public function setGiftCertApplied($giftCertApplied = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertApplied) && !(is_float($giftCertApplied) || is_numeric($giftCertApplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertApplied, true), gettype($giftCertApplied)), __LINE__);
        }
        $this->giftCertApplied = $giftCertApplied;
        return $this;
    }
    /**
     * Get timeDiscTax1Amt value
     * @return float|null
     */
    public function getTimeDiscTax1Amt()
    {
        return $this->timeDiscTax1Amt;
    }
    /**
     * Set timeDiscTax1Amt value
     * @param float $timeDiscTax1Amt
     * @return \StructType\Invoice
     */
    public function setTimeDiscTax1Amt($timeDiscTax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($timeDiscTax1Amt) && !(is_float($timeDiscTax1Amt) || is_numeric($timeDiscTax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timeDiscTax1Amt, true), gettype($timeDiscTax1Amt)), __LINE__);
        }
        $this->timeDiscTax1Amt = $timeDiscTax1Amt;
        return $this;
    }
    /**
     * Get tranIsVsoeBundle value
     * @return bool|null
     */
    public function getTranIsVsoeBundle()
    {
        return $this->tranIsVsoeBundle;
    }
    /**
     * Set tranIsVsoeBundle value
     * @param bool $tranIsVsoeBundle
     * @return \StructType\Invoice
     */
    public function setTranIsVsoeBundle($tranIsVsoeBundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($tranIsVsoeBundle) && !is_bool($tranIsVsoeBundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tranIsVsoeBundle, true), gettype($tranIsVsoeBundle)), __LINE__);
        }
        $this->tranIsVsoeBundle = $tranIsVsoeBundle;
        return $this;
    }
    /**
     * Get timeTaxRate2 value
     * @return float|null
     */
    public function getTimeTaxRate2()
    {
        return $this->timeTaxRate2;
    }
    /**
     * Set timeTaxRate2 value
     * @param float $timeTaxRate2
     * @return \StructType\Invoice
     */
    public function setTimeTaxRate2($timeTaxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($timeTaxRate2) && !(is_float($timeTaxRate2) || is_numeric($timeTaxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timeTaxRate2, true), gettype($timeTaxRate2)), __LINE__);
        }
        $this->timeTaxRate2 = $timeTaxRate2;
        return $this;
    }
    /**
     * Get vsoeAutoCalc value
     * @return bool|null
     */
    public function getVsoeAutoCalc()
    {
        return $this->vsoeAutoCalc;
    }
    /**
     * Set vsoeAutoCalc value
     * @param bool $vsoeAutoCalc
     * @return \StructType\Invoice
     */
    public function setVsoeAutoCalc($vsoeAutoCalc = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeAutoCalc) && !is_bool($vsoeAutoCalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeAutoCalc, true), gettype($vsoeAutoCalc)), __LINE__);
        }
        $this->vsoeAutoCalc = $vsoeAutoCalc;
        return $this;
    }
    /**
     * Get syncPartnerTeams value
     * @return bool|null
     */
    public function getSyncPartnerTeams()
    {
        return $this->syncPartnerTeams;
    }
    /**
     * Set syncPartnerTeams value
     * @param bool $syncPartnerTeams
     * @return \StructType\Invoice
     */
    public function setSyncPartnerTeams($syncPartnerTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncPartnerTeams) && !is_bool($syncPartnerTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncPartnerTeams, true), gettype($syncPartnerTeams)), __LINE__);
        }
        $this->syncPartnerTeams = $syncPartnerTeams;
        return $this;
    }
    /**
     * Get salesTeamList value
     * @return \StructType\InvoiceSalesTeamList|null
     */
    public function getSalesTeamList()
    {
        return $this->salesTeamList;
    }
    /**
     * Set salesTeamList value
     * @param \StructType\InvoiceSalesTeamList $salesTeamList
     * @return \StructType\Invoice
     */
    public function setSalesTeamList(\StructType\InvoiceSalesTeamList $salesTeamList = null)
    {
        $this->salesTeamList = $salesTeamList;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\InvoicePartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\InvoicePartnersList $partnersList
     * @return \StructType\Invoice
     */
    public function setPartnersList(\StructType\InvoicePartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\InvoiceItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\InvoiceItemList $itemList
     * @return \StructType\Invoice
     */
    public function setItemList(\StructType\InvoiceItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get itemCostList value
     * @return \StructType\InvoiceItemCostList|null
     */
    public function getItemCostList()
    {
        return $this->itemCostList;
    }
    /**
     * Set itemCostList value
     * @param \StructType\InvoiceItemCostList $itemCostList
     * @return \StructType\Invoice
     */
    public function setItemCostList(\StructType\InvoiceItemCostList $itemCostList = null)
    {
        $this->itemCostList = $itemCostList;
        return $this;
    }
    /**
     * Get giftCertRedemptionList value
     * @return \StructType\GiftCertRedemptionList|null
     */
    public function getGiftCertRedemptionList()
    {
        return $this->giftCertRedemptionList;
    }
    /**
     * Set giftCertRedemptionList value
     * @param \StructType\GiftCertRedemptionList $giftCertRedemptionList
     * @return \StructType\Invoice
     */
    public function setGiftCertRedemptionList(\StructType\GiftCertRedemptionList $giftCertRedemptionList = null)
    {
        $this->giftCertRedemptionList = $giftCertRedemptionList;
        return $this;
    }
    /**
     * Get promotionsList value
     * @return \StructType\PromotionsList|null
     */
    public function getPromotionsList()
    {
        return $this->promotionsList;
    }
    /**
     * Set promotionsList value
     * @param \StructType\PromotionsList $promotionsList
     * @return \StructType\Invoice
     */
    public function setPromotionsList(\StructType\PromotionsList $promotionsList = null)
    {
        $this->promotionsList = $promotionsList;
        return $this;
    }
    /**
     * Get expCostList value
     * @return \StructType\InvoiceExpCostList|null
     */
    public function getExpCostList()
    {
        return $this->expCostList;
    }
    /**
     * Set expCostList value
     * @param \StructType\InvoiceExpCostList $expCostList
     * @return \StructType\Invoice
     */
    public function setExpCostList(\StructType\InvoiceExpCostList $expCostList = null)
    {
        $this->expCostList = $expCostList;
        return $this;
    }
    /**
     * Get timeList value
     * @return \StructType\InvoiceTimeList|null
     */
    public function getTimeList()
    {
        return $this->timeList;
    }
    /**
     * Set timeList value
     * @param \StructType\InvoiceTimeList $timeList
     * @return \StructType\Invoice
     */
    public function setTimeList(\StructType\InvoiceTimeList $timeList = null)
    {
        $this->timeList = $timeList;
        return $this;
    }
    /**
     * Get shipGroupList value
     * @return \StructType\InvoiceShipGroupList|null
     */
    public function getShipGroupList()
    {
        return $this->shipGroupList;
    }
    /**
     * Set shipGroupList value
     * @param \StructType\InvoiceShipGroupList $shipGroupList
     * @return \StructType\Invoice
     */
    public function setShipGroupList(\StructType\InvoiceShipGroupList $shipGroupList = null)
    {
        $this->shipGroupList = $shipGroupList;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\Invoice
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\Invoice
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\Invoice
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Invoice
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Invoice
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Invoice
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
