<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryNumberSearchRow StructType
 * @subpackage Structs
 */
class InventoryNumberSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryNumberSearchRowBasic
     */
    public $basic;
    /**
     * The itemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchRowBasic
     */
    public $itemJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchRowBasic
     */
    public $userJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for InventoryNumberSearchRow
     * @uses InventoryNumberSearchRow::setBasic()
     * @uses InventoryNumberSearchRow::setItemJoin()
     * @uses InventoryNumberSearchRow::setUserJoin()
     * @uses InventoryNumberSearchRow::setCustomSearchJoin()
     * @param \StructType\InventoryNumberSearchRowBasic $basic
     * @param \StructType\ItemSearchRowBasic $itemJoin
     * @param \StructType\EmployeeSearchRowBasic $userJoin
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\InventoryNumberSearchRowBasic $basic = null, \StructType\ItemSearchRowBasic $itemJoin = null, \StructType\EmployeeSearchRowBasic $userJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setItemJoin($itemJoin)
            ->setUserJoin($userJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\InventoryNumberSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\InventoryNumberSearchRowBasic $basic
     * @return \StructType\InventoryNumberSearchRow
     */
    public function setBasic(\StructType\InventoryNumberSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get itemJoin value
     * @return \StructType\ItemSearchRowBasic|null
     */
    public function getItemJoin()
    {
        return $this->itemJoin;
    }
    /**
     * Set itemJoin value
     * @param \StructType\ItemSearchRowBasic $itemJoin
     * @return \StructType\InventoryNumberSearchRow
     */
    public function setItemJoin(\StructType\ItemSearchRowBasic $itemJoin = null)
    {
        $this->itemJoin = $itemJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchRowBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchRowBasic $userJoin
     * @return \StructType\InventoryNumberSearchRow
     */
    public function setUserJoin(\StructType\EmployeeSearchRowBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryNumberSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$inventoryNumberSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($inventoryNumberSearchRowCustomSearchJoinItem) ? get_class($inventoryNumberSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($inventoryNumberSearchRowCustomSearchJoinItem), var_export($inventoryNumberSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\InventoryNumberSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\InventoryNumberSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
