<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryNumberLocations StructType
 * @subpackage Structs
 */
class InventoryNumberLocations extends AbstractStructBase
{
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityOnOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnOrder;
    /**
     * The quantityInTransit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityInTransit;
    /**
     * Constructor method for InventoryNumberLocations
     * @uses InventoryNumberLocations::setLocation()
     * @uses InventoryNumberLocations::setQuantityOnHand()
     * @uses InventoryNumberLocations::setQuantityAvailable()
     * @uses InventoryNumberLocations::setQuantityOnOrder()
     * @uses InventoryNumberLocations::setQuantityInTransit()
     * @param string $location
     * @param float $quantityOnHand
     * @param float $quantityAvailable
     * @param float $quantityOnOrder
     * @param float $quantityInTransit
     */
    public function __construct($location = null, $quantityOnHand = null, $quantityAvailable = null, $quantityOnOrder = null, $quantityInTransit = null)
    {
        $this
            ->setLocation($location)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOnOrder($quantityOnOrder)
            ->setQuantityInTransit($quantityInTransit);
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\InventoryNumberLocations
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\InventoryNumberLocations
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\InventoryNumberLocations
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityOnOrder value
     * @return float|null
     */
    public function getQuantityOnOrder()
    {
        return $this->quantityOnOrder;
    }
    /**
     * Set quantityOnOrder value
     * @param float $quantityOnOrder
     * @return \StructType\InventoryNumberLocations
     */
    public function setQuantityOnOrder($quantityOnOrder = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnOrder) && !(is_float($quantityOnOrder) || is_numeric($quantityOnOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnOrder, true), gettype($quantityOnOrder)), __LINE__);
        }
        $this->quantityOnOrder = $quantityOnOrder;
        return $this;
    }
    /**
     * Get quantityInTransit value
     * @return float|null
     */
    public function getQuantityInTransit()
    {
        return $this->quantityInTransit;
    }
    /**
     * Set quantityInTransit value
     * @param float $quantityInTransit
     * @return \StructType\InventoryNumberLocations
     */
    public function setQuantityInTransit($quantityInTransit = null)
    {
        // validation for constraint: float
        if (!is_null($quantityInTransit) && !(is_float($quantityInTransit) || is_numeric($quantityInTransit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityInTransit, true), gettype($quantityInTransit)), __LINE__);
        }
        $this->quantityInTransit = $quantityInTransit;
        return $this;
    }
}
