<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryNumber StructType
 * @subpackage Structs
 */
class InventoryNumber extends Record
{
    /**
     * The inventoryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inventoryNumber;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $units;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The locationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryNumberLocationsList
     */
    public $locationsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for InventoryNumber
     * @uses InventoryNumber::setInventoryNumber()
     * @uses InventoryNumber::setItem()
     * @uses InventoryNumber::setStatus()
     * @uses InventoryNumber::setUnits()
     * @uses InventoryNumber::setExpirationDate()
     * @uses InventoryNumber::setMemo()
     * @uses InventoryNumber::setLocationsList()
     * @uses InventoryNumber::setCustomFieldList()
     * @uses InventoryNumber::setInternalId()
     * @uses InventoryNumber::setExternalId()
     * @param string $inventoryNumber
     * @param \StructType\RecordRef $item
     * @param string $status
     * @param string $units
     * @param string $expirationDate
     * @param string $memo
     * @param \StructType\InventoryNumberLocationsList $locationsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($inventoryNumber = null, \StructType\RecordRef $item = null, $status = null, $units = null, $expirationDate = null, $memo = null, \StructType\InventoryNumberLocationsList $locationsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setInventoryNumber($inventoryNumber)
            ->setItem($item)
            ->setStatus($status)
            ->setUnits($units)
            ->setExpirationDate($expirationDate)
            ->setMemo($memo)
            ->setLocationsList($locationsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get inventoryNumber value
     * @return string|null
     */
    public function getInventoryNumber()
    {
        return $this->inventoryNumber;
    }
    /**
     * Set inventoryNumber value
     * @param string $inventoryNumber
     * @return \StructType\InventoryNumber
     */
    public function setInventoryNumber($inventoryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryNumber) && !is_string($inventoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryNumber, true), gettype($inventoryNumber)), __LINE__);
        }
        $this->inventoryNumber = $inventoryNumber;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\InventoryNumber
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\InventoryNumber
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param string $units
     * @return \StructType\InventoryNumber
     */
    public function setUnits($units = null)
    {
        // validation for constraint: string
        if (!is_null($units) && !is_string($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\InventoryNumber
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\InventoryNumber
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get locationsList value
     * @return \StructType\InventoryNumberLocationsList|null
     */
    public function getLocationsList()
    {
        return $this->locationsList;
    }
    /**
     * Set locationsList value
     * @param \StructType\InventoryNumberLocationsList $locationsList
     * @return \StructType\InventoryNumber
     */
    public function setLocationsList(\StructType\InventoryNumberLocationsList $locationsList = null)
    {
        $this->locationsList = $locationsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\InventoryNumber
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\InventoryNumber
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\InventoryNumber
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
