<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemBinNumber StructType
 * @subpackage Structs
 */
class InventoryItemBinNumber extends AbstractStructBase
{
    /**
     * The binNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $binNumber;
    /**
     * The onHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $onHand;
    /**
     * The onHandAvail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $onHandAvail;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The preferredBin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $preferredBin;
    /**
     * Constructor method for InventoryItemBinNumber
     * @uses InventoryItemBinNumber::setBinNumber()
     * @uses InventoryItemBinNumber::setOnHand()
     * @uses InventoryItemBinNumber::setOnHandAvail()
     * @uses InventoryItemBinNumber::setLocation()
     * @uses InventoryItemBinNumber::setPreferredBin()
     * @param \StructType\RecordRef $binNumber
     * @param string $onHand
     * @param string $onHandAvail
     * @param string $location
     * @param bool $preferredBin
     */
    public function __construct(\StructType\RecordRef $binNumber = null, $onHand = null, $onHandAvail = null, $location = null, $preferredBin = null)
    {
        $this
            ->setBinNumber($binNumber)
            ->setOnHand($onHand)
            ->setOnHandAvail($onHandAvail)
            ->setLocation($location)
            ->setPreferredBin($preferredBin);
    }
    /**
     * Get binNumber value
     * @return \StructType\RecordRef|null
     */
    public function getBinNumber()
    {
        return $this->binNumber;
    }
    /**
     * Set binNumber value
     * @param \StructType\RecordRef $binNumber
     * @return \StructType\InventoryItemBinNumber
     */
    public function setBinNumber(\StructType\RecordRef $binNumber = null)
    {
        $this->binNumber = $binNumber;
        return $this;
    }
    /**
     * Get onHand value
     * @return string|null
     */
    public function getOnHand()
    {
        return $this->onHand;
    }
    /**
     * Set onHand value
     * @param string $onHand
     * @return \StructType\InventoryItemBinNumber
     */
    public function setOnHand($onHand = null)
    {
        // validation for constraint: string
        if (!is_null($onHand) && !is_string($onHand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onHand, true), gettype($onHand)), __LINE__);
        }
        $this->onHand = $onHand;
        return $this;
    }
    /**
     * Get onHandAvail value
     * @return string|null
     */
    public function getOnHandAvail()
    {
        return $this->onHandAvail;
    }
    /**
     * Set onHandAvail value
     * @param string $onHandAvail
     * @return \StructType\InventoryItemBinNumber
     */
    public function setOnHandAvail($onHandAvail = null)
    {
        // validation for constraint: string
        if (!is_null($onHandAvail) && !is_string($onHandAvail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onHandAvail, true), gettype($onHandAvail)), __LINE__);
        }
        $this->onHandAvail = $onHandAvail;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\InventoryItemBinNumber
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get preferredBin value
     * @return bool|null
     */
    public function getPreferredBin()
    {
        return $this->preferredBin;
    }
    /**
     * Set preferredBin value
     * @param bool $preferredBin
     * @return \StructType\InventoryItemBinNumber
     */
    public function setPreferredBin($preferredBin = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredBin) && !is_bool($preferredBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferredBin, true), gettype($preferredBin)), __LINE__);
        }
        $this->preferredBin = $preferredBin;
        return $this;
    }
}
