<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryCostRevaluationCostComponent StructType
 * @subpackage Structs
 */
class InventoryCostRevaluationCostComponent extends AbstractStructBase
{
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The componentItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $componentItem;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $costCategory;
    /**
     * Constructor method for InventoryCostRevaluationCostComponent
     * @uses InventoryCostRevaluationCostComponent::setCost()
     * @uses InventoryCostRevaluationCostComponent::setComponentItem()
     * @uses InventoryCostRevaluationCostComponent::setQuantity()
     * @uses InventoryCostRevaluationCostComponent::setUnits()
     * @uses InventoryCostRevaluationCostComponent::setCostCategory()
     * @param float $cost
     * @param \StructType\RecordRef $componentItem
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param \StructType\RecordRef $costCategory
     */
    public function __construct($cost = null, \StructType\RecordRef $componentItem = null, $quantity = null, \StructType\RecordRef $units = null, \StructType\RecordRef $costCategory = null)
    {
        $this
            ->setCost($cost)
            ->setComponentItem($componentItem)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setCostCategory($costCategory);
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\InventoryCostRevaluationCostComponent
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get componentItem value
     * @return \StructType\RecordRef|null
     */
    public function getComponentItem()
    {
        return $this->componentItem;
    }
    /**
     * Set componentItem value
     * @param \StructType\RecordRef $componentItem
     * @return \StructType\InventoryCostRevaluationCostComponent
     */
    public function setComponentItem(\StructType\RecordRef $componentItem = null)
    {
        $this->componentItem = $componentItem;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\InventoryCostRevaluationCostComponent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\InventoryCostRevaluationCostComponent
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get costCategory value
     * @return \StructType\RecordRef|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param \StructType\RecordRef $costCategory
     * @return \StructType\InventoryCostRevaluationCostComponent
     */
    public function setCostCategory(\StructType\RecordRef $costCategory = null)
    {
        $this->costCategory = $costCategory;
        return $this;
    }
}
