<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryAssignment StructType
 * @subpackage Structs
 */
class InventoryAssignment extends AbstractStructBase
{
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The issueInventoryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueInventoryNumber;
    /**
     * The receiptInventoryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $receiptInventoryNumber;
    /**
     * The binNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $binNumber;
    /**
     * The toBinNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $toBinNumber;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The inventoryStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $inventoryStatus;
    /**
     * The toInventoryStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $toInventoryStatus;
    /**
     * Constructor method for InventoryAssignment
     * @uses InventoryAssignment::setInternalId()
     * @uses InventoryAssignment::setIssueInventoryNumber()
     * @uses InventoryAssignment::setReceiptInventoryNumber()
     * @uses InventoryAssignment::setBinNumber()
     * @uses InventoryAssignment::setToBinNumber()
     * @uses InventoryAssignment::setQuantity()
     * @uses InventoryAssignment::setExpirationDate()
     * @uses InventoryAssignment::setQuantityAvailable()
     * @uses InventoryAssignment::setInventoryStatus()
     * @uses InventoryAssignment::setToInventoryStatus()
     * @param string $internalId
     * @param \StructType\RecordRef $issueInventoryNumber
     * @param string $receiptInventoryNumber
     * @param \StructType\RecordRef $binNumber
     * @param \StructType\RecordRef $toBinNumber
     * @param float $quantity
     * @param string $expirationDate
     * @param float $quantityAvailable
     * @param \StructType\RecordRef $inventoryStatus
     * @param \StructType\RecordRef $toInventoryStatus
     */
    public function __construct($internalId = null, \StructType\RecordRef $issueInventoryNumber = null, $receiptInventoryNumber = null, \StructType\RecordRef $binNumber = null, \StructType\RecordRef $toBinNumber = null, $quantity = null, $expirationDate = null, $quantityAvailable = null, \StructType\RecordRef $inventoryStatus = null, \StructType\RecordRef $toInventoryStatus = null)
    {
        $this
            ->setInternalId($internalId)
            ->setIssueInventoryNumber($issueInventoryNumber)
            ->setReceiptInventoryNumber($receiptInventoryNumber)
            ->setBinNumber($binNumber)
            ->setToBinNumber($toBinNumber)
            ->setQuantity($quantity)
            ->setExpirationDate($expirationDate)
            ->setQuantityAvailable($quantityAvailable)
            ->setInventoryStatus($inventoryStatus)
            ->setToInventoryStatus($toInventoryStatus);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\InventoryAssignment
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get issueInventoryNumber value
     * @return \StructType\RecordRef|null
     */
    public function getIssueInventoryNumber()
    {
        return $this->issueInventoryNumber;
    }
    /**
     * Set issueInventoryNumber value
     * @param \StructType\RecordRef $issueInventoryNumber
     * @return \StructType\InventoryAssignment
     */
    public function setIssueInventoryNumber(\StructType\RecordRef $issueInventoryNumber = null)
    {
        $this->issueInventoryNumber = $issueInventoryNumber;
        return $this;
    }
    /**
     * Get receiptInventoryNumber value
     * @return string|null
     */
    public function getReceiptInventoryNumber()
    {
        return $this->receiptInventoryNumber;
    }
    /**
     * Set receiptInventoryNumber value
     * @param string $receiptInventoryNumber
     * @return \StructType\InventoryAssignment
     */
    public function setReceiptInventoryNumber($receiptInventoryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiptInventoryNumber) && !is_string($receiptInventoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptInventoryNumber, true), gettype($receiptInventoryNumber)), __LINE__);
        }
        $this->receiptInventoryNumber = $receiptInventoryNumber;
        return $this;
    }
    /**
     * Get binNumber value
     * @return \StructType\RecordRef|null
     */
    public function getBinNumber()
    {
        return $this->binNumber;
    }
    /**
     * Set binNumber value
     * @param \StructType\RecordRef $binNumber
     * @return \StructType\InventoryAssignment
     */
    public function setBinNumber(\StructType\RecordRef $binNumber = null)
    {
        $this->binNumber = $binNumber;
        return $this;
    }
    /**
     * Get toBinNumber value
     * @return \StructType\RecordRef|null
     */
    public function getToBinNumber()
    {
        return $this->toBinNumber;
    }
    /**
     * Set toBinNumber value
     * @param \StructType\RecordRef $toBinNumber
     * @return \StructType\InventoryAssignment
     */
    public function setToBinNumber(\StructType\RecordRef $toBinNumber = null)
    {
        $this->toBinNumber = $toBinNumber;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\InventoryAssignment
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\InventoryAssignment
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\InventoryAssignment
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get inventoryStatus value
     * @return \StructType\RecordRef|null
     */
    public function getInventoryStatus()
    {
        return $this->inventoryStatus;
    }
    /**
     * Set inventoryStatus value
     * @param \StructType\RecordRef $inventoryStatus
     * @return \StructType\InventoryAssignment
     */
    public function setInventoryStatus(\StructType\RecordRef $inventoryStatus = null)
    {
        $this->inventoryStatus = $inventoryStatus;
        return $this;
    }
    /**
     * Get toInventoryStatus value
     * @return \StructType\RecordRef|null
     */
    public function getToInventoryStatus()
    {
        return $this->toInventoryStatus;
    }
    /**
     * Set toInventoryStatus value
     * @param \StructType\RecordRef $toInventoryStatus
     * @return \StructType\InventoryAssignment
     */
    public function setToInventoryStatus(\StructType\RecordRef $toInventoryStatus = null)
    {
        $this->toInventoryStatus = $toInventoryStatus;
        return $this;
    }
}
