<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Installment StructType
 * @subpackage Structs
 */
class Installment extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The amountDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountDue;
    /**
     * The seqNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $seqNum;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for Installment
     * @uses Installment::setAmount()
     * @uses Installment::setDueDate()
     * @uses Installment::setAmountDue()
     * @uses Installment::setSeqNum()
     * @uses Installment::setStatus()
     * @param float $amount
     * @param string $dueDate
     * @param float $amountDue
     * @param int $seqNum
     * @param string $status
     */
    public function __construct($amount = null, $dueDate = null, $amountDue = null, $seqNum = null, $status = null)
    {
        $this
            ->setAmount($amount)
            ->setDueDate($dueDate)
            ->setAmountDue($amountDue)
            ->setSeqNum($seqNum)
            ->setStatus($status);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\Installment
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\Installment
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get amountDue value
     * @return float|null
     */
    public function getAmountDue()
    {
        return $this->amountDue;
    }
    /**
     * Set amountDue value
     * @param float $amountDue
     * @return \StructType\Installment
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: float
        if (!is_null($amountDue) && !(is_float($amountDue) || is_numeric($amountDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->amountDue = $amountDue;
        return $this;
    }
    /**
     * Get seqNum value
     * @return int|null
     */
    public function getSeqNum()
    {
        return $this->seqNum;
    }
    /**
     * Set seqNum value
     * @param int $seqNum
     * @return \StructType\Installment
     */
    public function setSeqNum($seqNum = null)
    {
        // validation for constraint: int
        if (!is_null($seqNum) && !(is_int($seqNum) || ctype_digit($seqNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seqNum, true), gettype($seqNum)), __LINE__);
        }
        $this->seqNum = $seqNum;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Installment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
