<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipmentSearchRowBasic StructType
 * @subpackage Structs
 */
class InboundShipmentSearchRowBasic extends SearchRowBasic
{
    /**
     * The actualDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $actualDeliveryDate;
    /**
     * The actualShippingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $actualShippingDate;
    /**
     * The billOfLading
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $billOfLading;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $createdDate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $currency;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $description;
    /**
     * The expectedDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $expectedDeliveryDate;
    /**
     * The expectedRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $expectedRate;
    /**
     * The expectedShippingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $expectedShippingDate;
    /**
     * The externalDocumentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $externalDocumentNumber;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $incoterm;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $item;
    /**
     * The itemEffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $itemEffectiveDate;
    /**
     * The itemExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $itemExchangeRate;
    /**
     * The landedCostAllocationMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $landedCostAllocationMethod;
    /**
     * The landedCostAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $landedCostAmount;
    /**
     * The landedCostCostCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $landedCostCostCategory;
    /**
     * The landedCostCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $landedCostCurrency;
    /**
     * The landedCostEffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $landedCostEffectiveDate;
    /**
     * The landedCostExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $landedCostExchangeRate;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $memo;
    /**
     * The poAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $poAmount;
    /**
     * The poRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $poRate;
    /**
     * The purchaseOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $purchaseOrder;
    /**
     * The quantityBilled
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityBilled;
    /**
     * The quantityExpected
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityExpected;
    /**
     * The quantityReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityReceived;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $quantityRemaining;
    /**
     * The receivingLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $receivingLocation;
    /**
     * The shipmentBaseCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $shipmentBaseCurrency;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $shipmentNumber;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $status;
    /**
     * The totalUnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $totalUnitCost;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $unit;
    /**
     * The unitLandedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitLandedCost;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $vendor;
    /**
     * The vesselNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $vesselNumber;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for InboundShipmentSearchRowBasic
     * @uses InboundShipmentSearchRowBasic::setActualDeliveryDate()
     * @uses InboundShipmentSearchRowBasic::setActualShippingDate()
     * @uses InboundShipmentSearchRowBasic::setBillOfLading()
     * @uses InboundShipmentSearchRowBasic::setCreatedDate()
     * @uses InboundShipmentSearchRowBasic::setCurrency()
     * @uses InboundShipmentSearchRowBasic::setDescription()
     * @uses InboundShipmentSearchRowBasic::setExpectedDeliveryDate()
     * @uses InboundShipmentSearchRowBasic::setExpectedRate()
     * @uses InboundShipmentSearchRowBasic::setExpectedShippingDate()
     * @uses InboundShipmentSearchRowBasic::setExternalDocumentNumber()
     * @uses InboundShipmentSearchRowBasic::setExternalId()
     * @uses InboundShipmentSearchRowBasic::setIncoterm()
     * @uses InboundShipmentSearchRowBasic::setInternalId()
     * @uses InboundShipmentSearchRowBasic::setItem()
     * @uses InboundShipmentSearchRowBasic::setItemEffectiveDate()
     * @uses InboundShipmentSearchRowBasic::setItemExchangeRate()
     * @uses InboundShipmentSearchRowBasic::setLandedCostAllocationMethod()
     * @uses InboundShipmentSearchRowBasic::setLandedCostAmount()
     * @uses InboundShipmentSearchRowBasic::setLandedCostCostCategory()
     * @uses InboundShipmentSearchRowBasic::setLandedCostCurrency()
     * @uses InboundShipmentSearchRowBasic::setLandedCostEffectiveDate()
     * @uses InboundShipmentSearchRowBasic::setLandedCostExchangeRate()
     * @uses InboundShipmentSearchRowBasic::setMemo()
     * @uses InboundShipmentSearchRowBasic::setPoAmount()
     * @uses InboundShipmentSearchRowBasic::setPoRate()
     * @uses InboundShipmentSearchRowBasic::setPurchaseOrder()
     * @uses InboundShipmentSearchRowBasic::setQuantityBilled()
     * @uses InboundShipmentSearchRowBasic::setQuantityExpected()
     * @uses InboundShipmentSearchRowBasic::setQuantityReceived()
     * @uses InboundShipmentSearchRowBasic::setQuantityRemaining()
     * @uses InboundShipmentSearchRowBasic::setReceivingLocation()
     * @uses InboundShipmentSearchRowBasic::setShipmentBaseCurrency()
     * @uses InboundShipmentSearchRowBasic::setShipmentNumber()
     * @uses InboundShipmentSearchRowBasic::setStatus()
     * @uses InboundShipmentSearchRowBasic::setTotalUnitCost()
     * @uses InboundShipmentSearchRowBasic::setUnit()
     * @uses InboundShipmentSearchRowBasic::setUnitLandedCost()
     * @uses InboundShipmentSearchRowBasic::setVendor()
     * @uses InboundShipmentSearchRowBasic::setVesselNumber()
     * @uses InboundShipmentSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnDateField[] $actualDeliveryDate
     * @param \StructType\SearchColumnDateField[] $actualShippingDate
     * @param \StructType\SearchColumnStringField[] $billOfLading
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @param \StructType\SearchColumnSelectField[] $currency
     * @param \StructType\SearchColumnStringField[] $description
     * @param \StructType\SearchColumnDateField[] $expectedDeliveryDate
     * @param \StructType\SearchColumnDoubleField[] $expectedRate
     * @param \StructType\SearchColumnDateField[] $expectedShippingDate
     * @param \StructType\SearchColumnStringField[] $externalDocumentNumber
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $incoterm
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $item
     * @param \StructType\SearchColumnDateField[] $itemEffectiveDate
     * @param \StructType\SearchColumnDoubleField[] $itemExchangeRate
     * @param \StructType\SearchColumnEnumSelectField[] $landedCostAllocationMethod
     * @param \StructType\SearchColumnDoubleField[] $landedCostAmount
     * @param \StructType\SearchColumnSelectField[] $landedCostCostCategory
     * @param \StructType\SearchColumnSelectField[] $landedCostCurrency
     * @param \StructType\SearchColumnDateField[] $landedCostEffectiveDate
     * @param \StructType\SearchColumnDoubleField[] $landedCostExchangeRate
     * @param \StructType\SearchColumnStringField[] $memo
     * @param \StructType\SearchColumnDoubleField[] $poAmount
     * @param \StructType\SearchColumnDoubleField[] $poRate
     * @param \StructType\SearchColumnSelectField[] $purchaseOrder
     * @param \StructType\SearchColumnDoubleField[] $quantityBilled
     * @param \StructType\SearchColumnDoubleField[] $quantityExpected
     * @param \StructType\SearchColumnDoubleField[] $quantityReceived
     * @param \StructType\SearchColumnDoubleField[] $quantityRemaining
     * @param \StructType\SearchColumnSelectField[] $receivingLocation
     * @param \StructType\SearchColumnSelectField[] $shipmentBaseCurrency
     * @param \StructType\SearchColumnStringField[] $shipmentNumber
     * @param \StructType\SearchColumnStringField[] $status
     * @param \StructType\SearchColumnDoubleField[] $totalUnitCost
     * @param \StructType\SearchColumnSelectField[] $unit
     * @param \StructType\SearchColumnDoubleField[] $unitLandedCost
     * @param \StructType\SearchColumnSelectField[] $vendor
     * @param \StructType\SearchColumnStringField[] $vesselNumber
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $actualDeliveryDate = array(), array $actualShippingDate = array(), array $billOfLading = array(), array $createdDate = array(), array $currency = array(), array $description = array(), array $expectedDeliveryDate = array(), array $expectedRate = array(), array $expectedShippingDate = array(), array $externalDocumentNumber = array(), array $externalId = array(), array $incoterm = array(), array $internalId = array(), array $item = array(), array $itemEffectiveDate = array(), array $itemExchangeRate = array(), array $landedCostAllocationMethod = array(), array $landedCostAmount = array(), array $landedCostCostCategory = array(), array $landedCostCurrency = array(), array $landedCostEffectiveDate = array(), array $landedCostExchangeRate = array(), array $memo = array(), array $poAmount = array(), array $poRate = array(), array $purchaseOrder = array(), array $quantityBilled = array(), array $quantityExpected = array(), array $quantityReceived = array(), array $quantityRemaining = array(), array $receivingLocation = array(), array $shipmentBaseCurrency = array(), array $shipmentNumber = array(), array $status = array(), array $totalUnitCost = array(), array $unit = array(), array $unitLandedCost = array(), array $vendor = array(), array $vesselNumber = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualShippingDate($actualShippingDate)
            ->setBillOfLading($billOfLading)
            ->setCreatedDate($createdDate)
            ->setCurrency($currency)
            ->setDescription($description)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setExpectedRate($expectedRate)
            ->setExpectedShippingDate($expectedShippingDate)
            ->setExternalDocumentNumber($externalDocumentNumber)
            ->setExternalId($externalId)
            ->setIncoterm($incoterm)
            ->setInternalId($internalId)
            ->setItem($item)
            ->setItemEffectiveDate($itemEffectiveDate)
            ->setItemExchangeRate($itemExchangeRate)
            ->setLandedCostAllocationMethod($landedCostAllocationMethod)
            ->setLandedCostAmount($landedCostAmount)
            ->setLandedCostCostCategory($landedCostCostCategory)
            ->setLandedCostCurrency($landedCostCurrency)
            ->setLandedCostEffectiveDate($landedCostEffectiveDate)
            ->setLandedCostExchangeRate($landedCostExchangeRate)
            ->setMemo($memo)
            ->setPoAmount($poAmount)
            ->setPoRate($poRate)
            ->setPurchaseOrder($purchaseOrder)
            ->setQuantityBilled($quantityBilled)
            ->setQuantityExpected($quantityExpected)
            ->setQuantityReceived($quantityReceived)
            ->setQuantityRemaining($quantityRemaining)
            ->setReceivingLocation($receivingLocation)
            ->setShipmentBaseCurrency($shipmentBaseCurrency)
            ->setShipmentNumber($shipmentNumber)
            ->setStatus($status)
            ->setTotalUnitCost($totalUnitCost)
            ->setUnit($unit)
            ->setUnitLandedCost($unitLandedCost)
            ->setVendor($vendor)
            ->setVesselNumber($vesselNumber)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get actualDeliveryDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getActualDeliveryDate()
    {
        return $this->actualDeliveryDate;
    }
    /**
     * This method is responsible for validating the values passed to the setActualDeliveryDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualDeliveryDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualDeliveryDateForArrayConstraintsFromSetActualDeliveryDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicActualDeliveryDateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicActualDeliveryDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicActualDeliveryDateItem) ? get_class($inboundShipmentSearchRowBasicActualDeliveryDateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicActualDeliveryDateItem), var_export($inboundShipmentSearchRowBasicActualDeliveryDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The actualDeliveryDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set actualDeliveryDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $actualDeliveryDate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setActualDeliveryDate(array $actualDeliveryDate = array())
    {
        // validation for constraint: array
        if ('' !== ($actualDeliveryDateArrayErrorMessage = self::validateActualDeliveryDateForArrayConstraintsFromSetActualDeliveryDate($actualDeliveryDate))) {
            throw new \InvalidArgumentException($actualDeliveryDateArrayErrorMessage, __LINE__);
        }
        $this->actualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Add item to actualDeliveryDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToActualDeliveryDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The actualDeliveryDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->actualDeliveryDate[] = $item;
        return $this;
    }
    /**
     * Get actualShippingDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getActualShippingDate()
    {
        return $this->actualShippingDate;
    }
    /**
     * This method is responsible for validating the values passed to the setActualShippingDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualShippingDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualShippingDateForArrayConstraintsFromSetActualShippingDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicActualShippingDateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicActualShippingDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicActualShippingDateItem) ? get_class($inboundShipmentSearchRowBasicActualShippingDateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicActualShippingDateItem), var_export($inboundShipmentSearchRowBasicActualShippingDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The actualShippingDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set actualShippingDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $actualShippingDate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setActualShippingDate(array $actualShippingDate = array())
    {
        // validation for constraint: array
        if ('' !== ($actualShippingDateArrayErrorMessage = self::validateActualShippingDateForArrayConstraintsFromSetActualShippingDate($actualShippingDate))) {
            throw new \InvalidArgumentException($actualShippingDateArrayErrorMessage, __LINE__);
        }
        $this->actualShippingDate = $actualShippingDate;
        return $this;
    }
    /**
     * Add item to actualShippingDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToActualShippingDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The actualShippingDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->actualShippingDate[] = $item;
        return $this;
    }
    /**
     * Get billOfLading value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getBillOfLading()
    {
        return $this->billOfLading;
    }
    /**
     * This method is responsible for validating the values passed to the setBillOfLading method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillOfLading method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillOfLadingForArrayConstraintsFromSetBillOfLading(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicBillOfLadingItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicBillOfLadingItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicBillOfLadingItem) ? get_class($inboundShipmentSearchRowBasicBillOfLadingItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicBillOfLadingItem), var_export($inboundShipmentSearchRowBasicBillOfLadingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The billOfLading property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set billOfLading value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $billOfLading
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setBillOfLading(array $billOfLading = array())
    {
        // validation for constraint: array
        if ('' !== ($billOfLadingArrayErrorMessage = self::validateBillOfLadingForArrayConstraintsFromSetBillOfLading($billOfLading))) {
            throw new \InvalidArgumentException($billOfLadingArrayErrorMessage, __LINE__);
        }
        $this->billOfLading = $billOfLading;
        return $this;
    }
    /**
     * Add item to billOfLading value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToBillOfLading(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The billOfLading property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->billOfLading[] = $item;
        return $this;
    }
    /**
     * Get createdDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCreatedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreatedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreatedDateForArrayConstraintsFromSetCreatedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicCreatedDateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicCreatedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicCreatedDateItem) ? get_class($inboundShipmentSearchRowBasicCreatedDateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicCreatedDateItem), var_export($inboundShipmentSearchRowBasicCreatedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setCreatedDate(array $createdDate = array())
    {
        // validation for constraint: array
        if ('' !== ($createdDateArrayErrorMessage = self::validateCreatedDateForArrayConstraintsFromSetCreatedDate($createdDate))) {
            throw new \InvalidArgumentException($createdDateArrayErrorMessage, __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Add item to createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToCreatedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->createdDate[] = $item;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicCurrencyItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicCurrencyItem) ? get_class($inboundShipmentSearchRowBasicCurrencyItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicCurrencyItem), var_export($inboundShipmentSearchRowBasicCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $currency
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicDescriptionItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicDescriptionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicDescriptionItem) ? get_class($inboundShipmentSearchRowBasicDescriptionItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicDescriptionItem), var_export($inboundShipmentSearchRowBasicDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $description
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToDescription(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get expectedDeliveryDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getExpectedDeliveryDate()
    {
        return $this->expectedDeliveryDate;
    }
    /**
     * This method is responsible for validating the values passed to the setExpectedDeliveryDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpectedDeliveryDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpectedDeliveryDateForArrayConstraintsFromSetExpectedDeliveryDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicExpectedDeliveryDateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicExpectedDeliveryDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicExpectedDeliveryDateItem) ? get_class($inboundShipmentSearchRowBasicExpectedDeliveryDateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicExpectedDeliveryDateItem), var_export($inboundShipmentSearchRowBasicExpectedDeliveryDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expectedDeliveryDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expectedDeliveryDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $expectedDeliveryDate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setExpectedDeliveryDate(array $expectedDeliveryDate = array())
    {
        // validation for constraint: array
        if ('' !== ($expectedDeliveryDateArrayErrorMessage = self::validateExpectedDeliveryDateForArrayConstraintsFromSetExpectedDeliveryDate($expectedDeliveryDate))) {
            throw new \InvalidArgumentException($expectedDeliveryDateArrayErrorMessage, __LINE__);
        }
        $this->expectedDeliveryDate = $expectedDeliveryDate;
        return $this;
    }
    /**
     * Add item to expectedDeliveryDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToExpectedDeliveryDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The expectedDeliveryDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expectedDeliveryDate[] = $item;
        return $this;
    }
    /**
     * Get expectedRate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getExpectedRate()
    {
        return $this->expectedRate;
    }
    /**
     * This method is responsible for validating the values passed to the setExpectedRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpectedRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpectedRateForArrayConstraintsFromSetExpectedRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicExpectedRateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicExpectedRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicExpectedRateItem) ? get_class($inboundShipmentSearchRowBasicExpectedRateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicExpectedRateItem), var_export($inboundShipmentSearchRowBasicExpectedRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expectedRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expectedRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $expectedRate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setExpectedRate(array $expectedRate = array())
    {
        // validation for constraint: array
        if ('' !== ($expectedRateArrayErrorMessage = self::validateExpectedRateForArrayConstraintsFromSetExpectedRate($expectedRate))) {
            throw new \InvalidArgumentException($expectedRateArrayErrorMessage, __LINE__);
        }
        $this->expectedRate = $expectedRate;
        return $this;
    }
    /**
     * Add item to expectedRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToExpectedRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The expectedRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expectedRate[] = $item;
        return $this;
    }
    /**
     * Get expectedShippingDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getExpectedShippingDate()
    {
        return $this->expectedShippingDate;
    }
    /**
     * This method is responsible for validating the values passed to the setExpectedShippingDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpectedShippingDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpectedShippingDateForArrayConstraintsFromSetExpectedShippingDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicExpectedShippingDateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicExpectedShippingDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicExpectedShippingDateItem) ? get_class($inboundShipmentSearchRowBasicExpectedShippingDateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicExpectedShippingDateItem), var_export($inboundShipmentSearchRowBasicExpectedShippingDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expectedShippingDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expectedShippingDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $expectedShippingDate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setExpectedShippingDate(array $expectedShippingDate = array())
    {
        // validation for constraint: array
        if ('' !== ($expectedShippingDateArrayErrorMessage = self::validateExpectedShippingDateForArrayConstraintsFromSetExpectedShippingDate($expectedShippingDate))) {
            throw new \InvalidArgumentException($expectedShippingDateArrayErrorMessage, __LINE__);
        }
        $this->expectedShippingDate = $expectedShippingDate;
        return $this;
    }
    /**
     * Add item to expectedShippingDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToExpectedShippingDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The expectedShippingDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expectedShippingDate[] = $item;
        return $this;
    }
    /**
     * Get externalDocumentNumber value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getExternalDocumentNumber()
    {
        return $this->externalDocumentNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalDocumentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalDocumentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalDocumentNumberForArrayConstraintsFromSetExternalDocumentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicExternalDocumentNumberItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicExternalDocumentNumberItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicExternalDocumentNumberItem) ? get_class($inboundShipmentSearchRowBasicExternalDocumentNumberItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicExternalDocumentNumberItem), var_export($inboundShipmentSearchRowBasicExternalDocumentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalDocumentNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalDocumentNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $externalDocumentNumber
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setExternalDocumentNumber(array $externalDocumentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($externalDocumentNumberArrayErrorMessage = self::validateExternalDocumentNumberForArrayConstraintsFromSetExternalDocumentNumber($externalDocumentNumber))) {
            throw new \InvalidArgumentException($externalDocumentNumberArrayErrorMessage, __LINE__);
        }
        $this->externalDocumentNumber = $externalDocumentNumber;
        return $this;
    }
    /**
     * Add item to externalDocumentNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToExternalDocumentNumber(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The externalDocumentNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalDocumentNumber[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicExternalIdItem) ? get_class($inboundShipmentSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicExternalIdItem), var_export($inboundShipmentSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get incoterm value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * This method is responsible for validating the values passed to the setIncoterm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncoterm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncotermForArrayConstraintsFromSetIncoterm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicIncotermItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicIncotermItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicIncotermItem) ? get_class($inboundShipmentSearchRowBasicIncotermItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicIncotermItem), var_export($inboundShipmentSearchRowBasicIncotermItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The incoterm property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set incoterm value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $incoterm
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setIncoterm(array $incoterm = array())
    {
        // validation for constraint: array
        if ('' !== ($incotermArrayErrorMessage = self::validateIncotermForArrayConstraintsFromSetIncoterm($incoterm))) {
            throw new \InvalidArgumentException($incotermArrayErrorMessage, __LINE__);
        }
        $this->incoterm = $incoterm;
        return $this;
    }
    /**
     * Add item to incoterm value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToIncoterm(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The incoterm property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->incoterm[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicInternalIdItem) ? get_class($inboundShipmentSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicInternalIdItem), var_export($inboundShipmentSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicItemItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicItemItem) ? get_class($inboundShipmentSearchRowBasicItemItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicItemItem), var_export($inboundShipmentSearchRowBasicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get itemEffectiveDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getItemEffectiveDate()
    {
        return $this->itemEffectiveDate;
    }
    /**
     * This method is responsible for validating the values passed to the setItemEffectiveDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemEffectiveDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemEffectiveDateForArrayConstraintsFromSetItemEffectiveDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicItemEffectiveDateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicItemEffectiveDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicItemEffectiveDateItem) ? get_class($inboundShipmentSearchRowBasicItemEffectiveDateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicItemEffectiveDateItem), var_export($inboundShipmentSearchRowBasicItemEffectiveDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemEffectiveDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemEffectiveDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $itemEffectiveDate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setItemEffectiveDate(array $itemEffectiveDate = array())
    {
        // validation for constraint: array
        if ('' !== ($itemEffectiveDateArrayErrorMessage = self::validateItemEffectiveDateForArrayConstraintsFromSetItemEffectiveDate($itemEffectiveDate))) {
            throw new \InvalidArgumentException($itemEffectiveDateArrayErrorMessage, __LINE__);
        }
        $this->itemEffectiveDate = $itemEffectiveDate;
        return $this;
    }
    /**
     * Add item to itemEffectiveDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToItemEffectiveDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The itemEffectiveDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemEffectiveDate[] = $item;
        return $this;
    }
    /**
     * Get itemExchangeRate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getItemExchangeRate()
    {
        return $this->itemExchangeRate;
    }
    /**
     * This method is responsible for validating the values passed to the setItemExchangeRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemExchangeRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemExchangeRateForArrayConstraintsFromSetItemExchangeRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicItemExchangeRateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicItemExchangeRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicItemExchangeRateItem) ? get_class($inboundShipmentSearchRowBasicItemExchangeRateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicItemExchangeRateItem), var_export($inboundShipmentSearchRowBasicItemExchangeRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemExchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemExchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $itemExchangeRate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setItemExchangeRate(array $itemExchangeRate = array())
    {
        // validation for constraint: array
        if ('' !== ($itemExchangeRateArrayErrorMessage = self::validateItemExchangeRateForArrayConstraintsFromSetItemExchangeRate($itemExchangeRate))) {
            throw new \InvalidArgumentException($itemExchangeRateArrayErrorMessage, __LINE__);
        }
        $this->itemExchangeRate = $itemExchangeRate;
        return $this;
    }
    /**
     * Add item to itemExchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToItemExchangeRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The itemExchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemExchangeRate[] = $item;
        return $this;
    }
    /**
     * Get landedCostAllocationMethod value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getLandedCostAllocationMethod()
    {
        return $this->landedCostAllocationMethod;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCostAllocationMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCostAllocationMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostAllocationMethodForArrayConstraintsFromSetLandedCostAllocationMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicLandedCostAllocationMethodItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicLandedCostAllocationMethodItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicLandedCostAllocationMethodItem) ? get_class($inboundShipmentSearchRowBasicLandedCostAllocationMethodItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicLandedCostAllocationMethodItem), var_export($inboundShipmentSearchRowBasicLandedCostAllocationMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCostAllocationMethod property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCostAllocationMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $landedCostAllocationMethod
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setLandedCostAllocationMethod(array $landedCostAllocationMethod = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostAllocationMethodArrayErrorMessage = self::validateLandedCostAllocationMethodForArrayConstraintsFromSetLandedCostAllocationMethod($landedCostAllocationMethod))) {
            throw new \InvalidArgumentException($landedCostAllocationMethodArrayErrorMessage, __LINE__);
        }
        $this->landedCostAllocationMethod = $landedCostAllocationMethod;
        return $this;
    }
    /**
     * Add item to landedCostAllocationMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToLandedCostAllocationMethod(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The landedCostAllocationMethod property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCostAllocationMethod[] = $item;
        return $this;
    }
    /**
     * Get landedCostAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getLandedCostAmount()
    {
        return $this->landedCostAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCostAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCostAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostAmountForArrayConstraintsFromSetLandedCostAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicLandedCostAmountItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicLandedCostAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicLandedCostAmountItem) ? get_class($inboundShipmentSearchRowBasicLandedCostAmountItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicLandedCostAmountItem), var_export($inboundShipmentSearchRowBasicLandedCostAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCostAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCostAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $landedCostAmount
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setLandedCostAmount(array $landedCostAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostAmountArrayErrorMessage = self::validateLandedCostAmountForArrayConstraintsFromSetLandedCostAmount($landedCostAmount))) {
            throw new \InvalidArgumentException($landedCostAmountArrayErrorMessage, __LINE__);
        }
        $this->landedCostAmount = $landedCostAmount;
        return $this;
    }
    /**
     * Add item to landedCostAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToLandedCostAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The landedCostAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCostAmount[] = $item;
        return $this;
    }
    /**
     * Get landedCostCostCategory value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLandedCostCostCategory()
    {
        return $this->landedCostCostCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCostCostCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCostCostCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostCostCategoryForArrayConstraintsFromSetLandedCostCostCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicLandedCostCostCategoryItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicLandedCostCostCategoryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicLandedCostCostCategoryItem) ? get_class($inboundShipmentSearchRowBasicLandedCostCostCategoryItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicLandedCostCostCategoryItem), var_export($inboundShipmentSearchRowBasicLandedCostCostCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCostCostCategory property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCostCostCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $landedCostCostCategory
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setLandedCostCostCategory(array $landedCostCostCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostCostCategoryArrayErrorMessage = self::validateLandedCostCostCategoryForArrayConstraintsFromSetLandedCostCostCategory($landedCostCostCategory))) {
            throw new \InvalidArgumentException($landedCostCostCategoryArrayErrorMessage, __LINE__);
        }
        $this->landedCostCostCategory = $landedCostCostCategory;
        return $this;
    }
    /**
     * Add item to landedCostCostCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToLandedCostCostCategory(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The landedCostCostCategory property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCostCostCategory[] = $item;
        return $this;
    }
    /**
     * Get landedCostCurrency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getLandedCostCurrency()
    {
        return $this->landedCostCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCostCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCostCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostCurrencyForArrayConstraintsFromSetLandedCostCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicLandedCostCurrencyItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicLandedCostCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicLandedCostCurrencyItem) ? get_class($inboundShipmentSearchRowBasicLandedCostCurrencyItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicLandedCostCurrencyItem), var_export($inboundShipmentSearchRowBasicLandedCostCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCostCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCostCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $landedCostCurrency
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setLandedCostCurrency(array $landedCostCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostCurrencyArrayErrorMessage = self::validateLandedCostCurrencyForArrayConstraintsFromSetLandedCostCurrency($landedCostCurrency))) {
            throw new \InvalidArgumentException($landedCostCurrencyArrayErrorMessage, __LINE__);
        }
        $this->landedCostCurrency = $landedCostCurrency;
        return $this;
    }
    /**
     * Add item to landedCostCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToLandedCostCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The landedCostCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCostCurrency[] = $item;
        return $this;
    }
    /**
     * Get landedCostEffectiveDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLandedCostEffectiveDate()
    {
        return $this->landedCostEffectiveDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCostEffectiveDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCostEffectiveDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostEffectiveDateForArrayConstraintsFromSetLandedCostEffectiveDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicLandedCostEffectiveDateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicLandedCostEffectiveDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicLandedCostEffectiveDateItem) ? get_class($inboundShipmentSearchRowBasicLandedCostEffectiveDateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicLandedCostEffectiveDateItem), var_export($inboundShipmentSearchRowBasicLandedCostEffectiveDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCostEffectiveDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCostEffectiveDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $landedCostEffectiveDate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setLandedCostEffectiveDate(array $landedCostEffectiveDate = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostEffectiveDateArrayErrorMessage = self::validateLandedCostEffectiveDateForArrayConstraintsFromSetLandedCostEffectiveDate($landedCostEffectiveDate))) {
            throw new \InvalidArgumentException($landedCostEffectiveDateArrayErrorMessage, __LINE__);
        }
        $this->landedCostEffectiveDate = $landedCostEffectiveDate;
        return $this;
    }
    /**
     * Add item to landedCostEffectiveDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToLandedCostEffectiveDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The landedCostEffectiveDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCostEffectiveDate[] = $item;
        return $this;
    }
    /**
     * Get landedCostExchangeRate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getLandedCostExchangeRate()
    {
        return $this->landedCostExchangeRate;
    }
    /**
     * This method is responsible for validating the values passed to the setLandedCostExchangeRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandedCostExchangeRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandedCostExchangeRateForArrayConstraintsFromSetLandedCostExchangeRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicLandedCostExchangeRateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicLandedCostExchangeRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicLandedCostExchangeRateItem) ? get_class($inboundShipmentSearchRowBasicLandedCostExchangeRateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicLandedCostExchangeRateItem), var_export($inboundShipmentSearchRowBasicLandedCostExchangeRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landedCostExchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landedCostExchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $landedCostExchangeRate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setLandedCostExchangeRate(array $landedCostExchangeRate = array())
    {
        // validation for constraint: array
        if ('' !== ($landedCostExchangeRateArrayErrorMessage = self::validateLandedCostExchangeRateForArrayConstraintsFromSetLandedCostExchangeRate($landedCostExchangeRate))) {
            throw new \InvalidArgumentException($landedCostExchangeRateArrayErrorMessage, __LINE__);
        }
        $this->landedCostExchangeRate = $landedCostExchangeRate;
        return $this;
    }
    /**
     * Add item to landedCostExchangeRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToLandedCostExchangeRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The landedCostExchangeRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landedCostExchangeRate[] = $item;
        return $this;
    }
    /**
     * Get memo value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * This method is responsible for validating the values passed to the setMemo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMemo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMemoForArrayConstraintsFromSetMemo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicMemoItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicMemoItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicMemoItem) ? get_class($inboundShipmentSearchRowBasicMemoItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicMemoItem), var_export($inboundShipmentSearchRowBasicMemoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $memo
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setMemo(array $memo = array())
    {
        // validation for constraint: array
        if ('' !== ($memoArrayErrorMessage = self::validateMemoForArrayConstraintsFromSetMemo($memo))) {
            throw new \InvalidArgumentException($memoArrayErrorMessage, __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Add item to memo value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToMemo(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The memo property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->memo[] = $item;
        return $this;
    }
    /**
     * Get poAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPoAmount()
    {
        return $this->poAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setPoAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPoAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePoAmountForArrayConstraintsFromSetPoAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicPoAmountItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicPoAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicPoAmountItem) ? get_class($inboundShipmentSearchRowBasicPoAmountItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicPoAmountItem), var_export($inboundShipmentSearchRowBasicPoAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The poAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set poAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $poAmount
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setPoAmount(array $poAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($poAmountArrayErrorMessage = self::validatePoAmountForArrayConstraintsFromSetPoAmount($poAmount))) {
            throw new \InvalidArgumentException($poAmountArrayErrorMessage, __LINE__);
        }
        $this->poAmount = $poAmount;
        return $this;
    }
    /**
     * Add item to poAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToPoAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The poAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->poAmount[] = $item;
        return $this;
    }
    /**
     * Get poRate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPoRate()
    {
        return $this->poRate;
    }
    /**
     * This method is responsible for validating the values passed to the setPoRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPoRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePoRateForArrayConstraintsFromSetPoRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicPoRateItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicPoRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicPoRateItem) ? get_class($inboundShipmentSearchRowBasicPoRateItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicPoRateItem), var_export($inboundShipmentSearchRowBasicPoRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The poRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set poRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $poRate
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setPoRate(array $poRate = array())
    {
        // validation for constraint: array
        if ('' !== ($poRateArrayErrorMessage = self::validatePoRateForArrayConstraintsFromSetPoRate($poRate))) {
            throw new \InvalidArgumentException($poRateArrayErrorMessage, __LINE__);
        }
        $this->poRate = $poRate;
        return $this;
    }
    /**
     * Add item to poRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToPoRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The poRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->poRate[] = $item;
        return $this;
    }
    /**
     * Get purchaseOrder value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseOrderForArrayConstraintsFromSetPurchaseOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicPurchaseOrderItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicPurchaseOrderItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicPurchaseOrderItem) ? get_class($inboundShipmentSearchRowBasicPurchaseOrderItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicPurchaseOrderItem), var_export($inboundShipmentSearchRowBasicPurchaseOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The purchaseOrder property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set purchaseOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $purchaseOrder
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setPurchaseOrder(array $purchaseOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseOrderArrayErrorMessage = self::validatePurchaseOrderForArrayConstraintsFromSetPurchaseOrder($purchaseOrder))) {
            throw new \InvalidArgumentException($purchaseOrderArrayErrorMessage, __LINE__);
        }
        $this->purchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Add item to purchaseOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToPurchaseOrder(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The purchaseOrder property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->purchaseOrder[] = $item;
        return $this;
    }
    /**
     * Get quantityBilled value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityBilled()
    {
        return $this->quantityBilled;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityBilled method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityBilled method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityBilledForArrayConstraintsFromSetQuantityBilled(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicQuantityBilledItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicQuantityBilledItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicQuantityBilledItem) ? get_class($inboundShipmentSearchRowBasicQuantityBilledItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicQuantityBilledItem), var_export($inboundShipmentSearchRowBasicQuantityBilledItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityBilled property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityBilled value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityBilled
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setQuantityBilled(array $quantityBilled = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityBilledArrayErrorMessage = self::validateQuantityBilledForArrayConstraintsFromSetQuantityBilled($quantityBilled))) {
            throw new \InvalidArgumentException($quantityBilledArrayErrorMessage, __LINE__);
        }
        $this->quantityBilled = $quantityBilled;
        return $this;
    }
    /**
     * Add item to quantityBilled value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToQuantityBilled(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityBilled property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityBilled[] = $item;
        return $this;
    }
    /**
     * Get quantityExpected value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityExpected()
    {
        return $this->quantityExpected;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityExpected method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityExpected method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityExpectedForArrayConstraintsFromSetQuantityExpected(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicQuantityExpectedItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicQuantityExpectedItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicQuantityExpectedItem) ? get_class($inboundShipmentSearchRowBasicQuantityExpectedItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicQuantityExpectedItem), var_export($inboundShipmentSearchRowBasicQuantityExpectedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityExpected property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityExpected value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityExpected
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setQuantityExpected(array $quantityExpected = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityExpectedArrayErrorMessage = self::validateQuantityExpectedForArrayConstraintsFromSetQuantityExpected($quantityExpected))) {
            throw new \InvalidArgumentException($quantityExpectedArrayErrorMessage, __LINE__);
        }
        $this->quantityExpected = $quantityExpected;
        return $this;
    }
    /**
     * Add item to quantityExpected value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToQuantityExpected(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityExpected property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityExpected[] = $item;
        return $this;
    }
    /**
     * Get quantityReceived value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityReceived()
    {
        return $this->quantityReceived;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityReceived method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityReceived method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityReceivedForArrayConstraintsFromSetQuantityReceived(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicQuantityReceivedItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicQuantityReceivedItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicQuantityReceivedItem) ? get_class($inboundShipmentSearchRowBasicQuantityReceivedItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicQuantityReceivedItem), var_export($inboundShipmentSearchRowBasicQuantityReceivedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityReceived property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityReceived value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityReceived
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setQuantityReceived(array $quantityReceived = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityReceivedArrayErrorMessage = self::validateQuantityReceivedForArrayConstraintsFromSetQuantityReceived($quantityReceived))) {
            throw new \InvalidArgumentException($quantityReceivedArrayErrorMessage, __LINE__);
        }
        $this->quantityReceived = $quantityReceived;
        return $this;
    }
    /**
     * Add item to quantityReceived value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToQuantityReceived(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityReceived property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityReceived[] = $item;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityRemaining method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityRemaining method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityRemainingForArrayConstraintsFromSetQuantityRemaining(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicQuantityRemainingItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicQuantityRemainingItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicQuantityRemainingItem) ? get_class($inboundShipmentSearchRowBasicQuantityRemainingItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicQuantityRemainingItem), var_export($inboundShipmentSearchRowBasicQuantityRemainingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $quantityRemaining
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setQuantityRemaining(array $quantityRemaining = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityRemainingArrayErrorMessage = self::validateQuantityRemainingForArrayConstraintsFromSetQuantityRemaining($quantityRemaining))) {
            throw new \InvalidArgumentException($quantityRemainingArrayErrorMessage, __LINE__);
        }
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Add item to quantityRemaining value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToQuantityRemaining(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The quantityRemaining property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityRemaining[] = $item;
        return $this;
    }
    /**
     * Get receivingLocation value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getReceivingLocation()
    {
        return $this->receivingLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setReceivingLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceivingLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceivingLocationForArrayConstraintsFromSetReceivingLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicReceivingLocationItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicReceivingLocationItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicReceivingLocationItem) ? get_class($inboundShipmentSearchRowBasicReceivingLocationItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicReceivingLocationItem), var_export($inboundShipmentSearchRowBasicReceivingLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The receivingLocation property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set receivingLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $receivingLocation
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setReceivingLocation(array $receivingLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($receivingLocationArrayErrorMessage = self::validateReceivingLocationForArrayConstraintsFromSetReceivingLocation($receivingLocation))) {
            throw new \InvalidArgumentException($receivingLocationArrayErrorMessage, __LINE__);
        }
        $this->receivingLocation = $receivingLocation;
        return $this;
    }
    /**
     * Add item to receivingLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToReceivingLocation(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The receivingLocation property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->receivingLocation[] = $item;
        return $this;
    }
    /**
     * Get shipmentBaseCurrency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getShipmentBaseCurrency()
    {
        return $this->shipmentBaseCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentBaseCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentBaseCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentBaseCurrencyForArrayConstraintsFromSetShipmentBaseCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicShipmentBaseCurrencyItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicShipmentBaseCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicShipmentBaseCurrencyItem) ? get_class($inboundShipmentSearchRowBasicShipmentBaseCurrencyItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicShipmentBaseCurrencyItem), var_export($inboundShipmentSearchRowBasicShipmentBaseCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentBaseCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentBaseCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $shipmentBaseCurrency
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setShipmentBaseCurrency(array $shipmentBaseCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentBaseCurrencyArrayErrorMessage = self::validateShipmentBaseCurrencyForArrayConstraintsFromSetShipmentBaseCurrency($shipmentBaseCurrency))) {
            throw new \InvalidArgumentException($shipmentBaseCurrencyArrayErrorMessage, __LINE__);
        }
        $this->shipmentBaseCurrency = $shipmentBaseCurrency;
        return $this;
    }
    /**
     * Add item to shipmentBaseCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToShipmentBaseCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The shipmentBaseCurrency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipmentBaseCurrency[] = $item;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForArrayConstraintsFromSetShipmentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicShipmentNumberItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicShipmentNumberItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicShipmentNumberItem) ? get_class($inboundShipmentSearchRowBasicShipmentNumberItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicShipmentNumberItem), var_export($inboundShipmentSearchRowBasicShipmentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $shipmentNumber
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setShipmentNumber(array $shipmentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentNumberArrayErrorMessage = self::validateShipmentNumberForArrayConstraintsFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberArrayErrorMessage, __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Add item to shipmentNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToShipmentNumber(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The shipmentNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipmentNumber[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicStatusItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicStatusItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicStatusItem) ? get_class($inboundShipmentSearchRowBasicStatusItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicStatusItem), var_export($inboundShipmentSearchRowBasicStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The status property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set status value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $status
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: array
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Add item to status value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToStatus(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The status property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->status[] = $item;
        return $this;
    }
    /**
     * Get totalUnitCost value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getTotalUnitCost()
    {
        return $this->totalUnitCost;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalUnitCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalUnitCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalUnitCostForArrayConstraintsFromSetTotalUnitCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicTotalUnitCostItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicTotalUnitCostItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicTotalUnitCostItem) ? get_class($inboundShipmentSearchRowBasicTotalUnitCostItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicTotalUnitCostItem), var_export($inboundShipmentSearchRowBasicTotalUnitCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The totalUnitCost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set totalUnitCost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $totalUnitCost
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setTotalUnitCost(array $totalUnitCost = array())
    {
        // validation for constraint: array
        if ('' !== ($totalUnitCostArrayErrorMessage = self::validateTotalUnitCostForArrayConstraintsFromSetTotalUnitCost($totalUnitCost))) {
            throw new \InvalidArgumentException($totalUnitCostArrayErrorMessage, __LINE__);
        }
        $this->totalUnitCost = $totalUnitCost;
        return $this;
    }
    /**
     * Add item to totalUnitCost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToTotalUnitCost(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The totalUnitCost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->totalUnitCost[] = $item;
        return $this;
    }
    /**
     * Get unit value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * This method is responsible for validating the values passed to the setUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitForArrayConstraintsFromSetUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicUnitItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicUnitItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicUnitItem) ? get_class($inboundShipmentSearchRowBasicUnitItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicUnitItem), var_export($inboundShipmentSearchRowBasicUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unit property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $unit
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setUnit(array $unit = array())
    {
        // validation for constraint: array
        if ('' !== ($unitArrayErrorMessage = self::validateUnitForArrayConstraintsFromSetUnit($unit))) {
            throw new \InvalidArgumentException($unitArrayErrorMessage, __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Add item to unit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToUnit(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The unit property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unit[] = $item;
        return $this;
    }
    /**
     * Get unitLandedCost value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitLandedCost()
    {
        return $this->unitLandedCost;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitLandedCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitLandedCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitLandedCostForArrayConstraintsFromSetUnitLandedCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicUnitLandedCostItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicUnitLandedCostItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicUnitLandedCostItem) ? get_class($inboundShipmentSearchRowBasicUnitLandedCostItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicUnitLandedCostItem), var_export($inboundShipmentSearchRowBasicUnitLandedCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitLandedCost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitLandedCost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitLandedCost
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setUnitLandedCost(array $unitLandedCost = array())
    {
        // validation for constraint: array
        if ('' !== ($unitLandedCostArrayErrorMessage = self::validateUnitLandedCostForArrayConstraintsFromSetUnitLandedCost($unitLandedCost))) {
            throw new \InvalidArgumentException($unitLandedCostArrayErrorMessage, __LINE__);
        }
        $this->unitLandedCost = $unitLandedCost;
        return $this;
    }
    /**
     * Add item to unitLandedCost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToUnitLandedCost(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitLandedCost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitLandedCost[] = $item;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * This method is responsible for validating the values passed to the setVendor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorForArrayConstraintsFromSetVendor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicVendorItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicVendorItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicVendorItem) ? get_class($inboundShipmentSearchRowBasicVendorItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicVendorItem), var_export($inboundShipmentSearchRowBasicVendorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vendor property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vendor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $vendor
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setVendor(array $vendor = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorArrayErrorMessage = self::validateVendorForArrayConstraintsFromSetVendor($vendor))) {
            throw new \InvalidArgumentException($vendorArrayErrorMessage, __LINE__);
        }
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Add item to vendor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToVendor(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The vendor property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->vendor[] = $item;
        return $this;
    }
    /**
     * Get vesselNumber value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getVesselNumber()
    {
        return $this->vesselNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setVesselNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVesselNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVesselNumberForArrayConstraintsFromSetVesselNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowBasicVesselNumberItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowBasicVesselNumberItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($inboundShipmentSearchRowBasicVesselNumberItem) ? get_class($inboundShipmentSearchRowBasicVesselNumberItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowBasicVesselNumberItem), var_export($inboundShipmentSearchRowBasicVesselNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vesselNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vesselNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $vesselNumber
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setVesselNumber(array $vesselNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($vesselNumberArrayErrorMessage = self::validateVesselNumberForArrayConstraintsFromSetVesselNumber($vesselNumber))) {
            throw new \InvalidArgumentException($vesselNumberArrayErrorMessage, __LINE__);
        }
        $this->vesselNumber = $vesselNumber;
        return $this;
    }
    /**
     * Add item to vesselNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function addToVesselNumber(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The vesselNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->vesselNumber[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\InboundShipmentSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
