<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipmentSearchRow StructType
 * @subpackage Structs
 */
class InboundShipmentSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InboundShipmentSearchRowBasic
     */
    public $basic;
    /**
     * The inventoryDetailJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetailSearchRowBasic
     */
    public $inventoryDetailJoin;
    /**
     * The itemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchRowBasic
     */
    public $itemJoin;
    /**
     * The itemReceiptJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchRowBasic
     */
    public $itemReceiptJoin;
    /**
     * The purchaseOrderJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchRowBasic
     */
    public $purchaseOrderJoin;
    /**
     * The vendorJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorSearchRowBasic
     */
    public $vendorJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for InboundShipmentSearchRow
     * @uses InboundShipmentSearchRow::setBasic()
     * @uses InboundShipmentSearchRow::setInventoryDetailJoin()
     * @uses InboundShipmentSearchRow::setItemJoin()
     * @uses InboundShipmentSearchRow::setItemReceiptJoin()
     * @uses InboundShipmentSearchRow::setPurchaseOrderJoin()
     * @uses InboundShipmentSearchRow::setVendorJoin()
     * @uses InboundShipmentSearchRow::setCustomSearchJoin()
     * @param \StructType\InboundShipmentSearchRowBasic $basic
     * @param \StructType\InventoryDetailSearchRowBasic $inventoryDetailJoin
     * @param \StructType\ItemSearchRowBasic $itemJoin
     * @param \StructType\TransactionSearchRowBasic $itemReceiptJoin
     * @param \StructType\TransactionSearchRowBasic $purchaseOrderJoin
     * @param \StructType\VendorSearchRowBasic $vendorJoin
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\InboundShipmentSearchRowBasic $basic = null, \StructType\InventoryDetailSearchRowBasic $inventoryDetailJoin = null, \StructType\ItemSearchRowBasic $itemJoin = null, \StructType\TransactionSearchRowBasic $itemReceiptJoin = null, \StructType\TransactionSearchRowBasic $purchaseOrderJoin = null, \StructType\VendorSearchRowBasic $vendorJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setInventoryDetailJoin($inventoryDetailJoin)
            ->setItemJoin($itemJoin)
            ->setItemReceiptJoin($itemReceiptJoin)
            ->setPurchaseOrderJoin($purchaseOrderJoin)
            ->setVendorJoin($vendorJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\InboundShipmentSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\InboundShipmentSearchRowBasic $basic
     * @return \StructType\InboundShipmentSearchRow
     */
    public function setBasic(\StructType\InboundShipmentSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get inventoryDetailJoin value
     * @return \StructType\InventoryDetailSearchRowBasic|null
     */
    public function getInventoryDetailJoin()
    {
        return $this->inventoryDetailJoin;
    }
    /**
     * Set inventoryDetailJoin value
     * @param \StructType\InventoryDetailSearchRowBasic $inventoryDetailJoin
     * @return \StructType\InboundShipmentSearchRow
     */
    public function setInventoryDetailJoin(\StructType\InventoryDetailSearchRowBasic $inventoryDetailJoin = null)
    {
        $this->inventoryDetailJoin = $inventoryDetailJoin;
        return $this;
    }
    /**
     * Get itemJoin value
     * @return \StructType\ItemSearchRowBasic|null
     */
    public function getItemJoin()
    {
        return $this->itemJoin;
    }
    /**
     * Set itemJoin value
     * @param \StructType\ItemSearchRowBasic $itemJoin
     * @return \StructType\InboundShipmentSearchRow
     */
    public function setItemJoin(\StructType\ItemSearchRowBasic $itemJoin = null)
    {
        $this->itemJoin = $itemJoin;
        return $this;
    }
    /**
     * Get itemReceiptJoin value
     * @return \StructType\TransactionSearchRowBasic|null
     */
    public function getItemReceiptJoin()
    {
        return $this->itemReceiptJoin;
    }
    /**
     * Set itemReceiptJoin value
     * @param \StructType\TransactionSearchRowBasic $itemReceiptJoin
     * @return \StructType\InboundShipmentSearchRow
     */
    public function setItemReceiptJoin(\StructType\TransactionSearchRowBasic $itemReceiptJoin = null)
    {
        $this->itemReceiptJoin = $itemReceiptJoin;
        return $this;
    }
    /**
     * Get purchaseOrderJoin value
     * @return \StructType\TransactionSearchRowBasic|null
     */
    public function getPurchaseOrderJoin()
    {
        return $this->purchaseOrderJoin;
    }
    /**
     * Set purchaseOrderJoin value
     * @param \StructType\TransactionSearchRowBasic $purchaseOrderJoin
     * @return \StructType\InboundShipmentSearchRow
     */
    public function setPurchaseOrderJoin(\StructType\TransactionSearchRowBasic $purchaseOrderJoin = null)
    {
        $this->purchaseOrderJoin = $purchaseOrderJoin;
        return $this;
    }
    /**
     * Get vendorJoin value
     * @return \StructType\VendorSearchRowBasic|null
     */
    public function getVendorJoin()
    {
        return $this->vendorJoin;
    }
    /**
     * Set vendorJoin value
     * @param \StructType\VendorSearchRowBasic $vendorJoin
     * @return \StructType\InboundShipmentSearchRow
     */
    public function setVendorJoin(\StructType\VendorSearchRowBasic $vendorJoin = null)
    {
        $this->vendorJoin = $vendorJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($inboundShipmentSearchRowCustomSearchJoinItem) ? get_class($inboundShipmentSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchRowCustomSearchJoinItem), var_export($inboundShipmentSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\InboundShipmentSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\InboundShipmentSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
