<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipmentSearchBasic StructType
 * @subpackage Structs
 */
class InboundShipmentSearchBasic extends SearchRecordBasic
{
    /**
     * The actualDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $actualDeliveryDate;
    /**
     * The actualShippingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $actualShippingDate;
    /**
     * The billOfLading
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $billOfLading;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $createdDate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $currency;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $description;
    /**
     * The expectedDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $expectedDeliveryDate;
    /**
     * The expectedRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $expectedRate;
    /**
     * The expectedShippingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $expectedShippingDate;
    /**
     * The externalDocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $externalDocumentNumber;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $externalId;
    /**
     * The externalIdString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $externalIdString;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $incoterm;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $internalId;
    /**
     * The internalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $internalIdNumber;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $item;
    /**
     * The itemEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $itemEffectiveDate;
    /**
     * The itemExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $itemExchangeRate;
    /**
     * The landedCostAllocationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $landedCostAllocationMethod;
    /**
     * The landedCostAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $landedCostAmount;
    /**
     * The landedCostCostCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $landedCostCostCategory;
    /**
     * The landedCostCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $landedCostCurrency;
    /**
     * The landedCostEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $landedCostEffectiveDate;
    /**
     * The landedCostExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $landedCostExchangeRate;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $memo;
    /**
     * The poAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $poAmount;
    /**
     * The poRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $poRate;
    /**
     * The purchaseOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $purchaseOrder;
    /**
     * The quantityBilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $quantityBilled;
    /**
     * The quantityExpected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $quantityExpected;
    /**
     * The quantityReceived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $quantityReceived;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $quantityRemaining;
    /**
     * The receivingLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $receivingLocation;
    /**
     * The shipmentBaseCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $shipmentBaseCurrency;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $shipmentNumber;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $status;
    /**
     * The totalUnitCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $totalUnitCost;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $unit;
    /**
     * The unitLandedCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $unitLandedCost;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $vendor;
    /**
     * The vesselNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $vesselNumber;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for InboundShipmentSearchBasic
     * @uses InboundShipmentSearchBasic::setActualDeliveryDate()
     * @uses InboundShipmentSearchBasic::setActualShippingDate()
     * @uses InboundShipmentSearchBasic::setBillOfLading()
     * @uses InboundShipmentSearchBasic::setCreatedDate()
     * @uses InboundShipmentSearchBasic::setCurrency()
     * @uses InboundShipmentSearchBasic::setDescription()
     * @uses InboundShipmentSearchBasic::setExpectedDeliveryDate()
     * @uses InboundShipmentSearchBasic::setExpectedRate()
     * @uses InboundShipmentSearchBasic::setExpectedShippingDate()
     * @uses InboundShipmentSearchBasic::setExternalDocumentNumber()
     * @uses InboundShipmentSearchBasic::setExternalId()
     * @uses InboundShipmentSearchBasic::setExternalIdString()
     * @uses InboundShipmentSearchBasic::setIncoterm()
     * @uses InboundShipmentSearchBasic::setInternalId()
     * @uses InboundShipmentSearchBasic::setInternalIdNumber()
     * @uses InboundShipmentSearchBasic::setItem()
     * @uses InboundShipmentSearchBasic::setItemEffectiveDate()
     * @uses InboundShipmentSearchBasic::setItemExchangeRate()
     * @uses InboundShipmentSearchBasic::setLandedCostAllocationMethod()
     * @uses InboundShipmentSearchBasic::setLandedCostAmount()
     * @uses InboundShipmentSearchBasic::setLandedCostCostCategory()
     * @uses InboundShipmentSearchBasic::setLandedCostCurrency()
     * @uses InboundShipmentSearchBasic::setLandedCostEffectiveDate()
     * @uses InboundShipmentSearchBasic::setLandedCostExchangeRate()
     * @uses InboundShipmentSearchBasic::setMemo()
     * @uses InboundShipmentSearchBasic::setPoAmount()
     * @uses InboundShipmentSearchBasic::setPoRate()
     * @uses InboundShipmentSearchBasic::setPurchaseOrder()
     * @uses InboundShipmentSearchBasic::setQuantityBilled()
     * @uses InboundShipmentSearchBasic::setQuantityExpected()
     * @uses InboundShipmentSearchBasic::setQuantityReceived()
     * @uses InboundShipmentSearchBasic::setQuantityRemaining()
     * @uses InboundShipmentSearchBasic::setReceivingLocation()
     * @uses InboundShipmentSearchBasic::setShipmentBaseCurrency()
     * @uses InboundShipmentSearchBasic::setShipmentNumber()
     * @uses InboundShipmentSearchBasic::setStatus()
     * @uses InboundShipmentSearchBasic::setTotalUnitCost()
     * @uses InboundShipmentSearchBasic::setUnit()
     * @uses InboundShipmentSearchBasic::setUnitLandedCost()
     * @uses InboundShipmentSearchBasic::setVendor()
     * @uses InboundShipmentSearchBasic::setVesselNumber()
     * @uses InboundShipmentSearchBasic::setCustomFieldList()
     * @param \StructType\SearchDateField $actualDeliveryDate
     * @param \StructType\SearchDateField $actualShippingDate
     * @param \StructType\SearchStringField $billOfLading
     * @param \StructType\SearchDateField $createdDate
     * @param \StructType\SearchMultiSelectField $currency
     * @param \StructType\SearchStringField $description
     * @param \StructType\SearchDateField $expectedDeliveryDate
     * @param \StructType\SearchDoubleField $expectedRate
     * @param \StructType\SearchDateField $expectedShippingDate
     * @param \StructType\SearchMultiSelectField $externalDocumentNumber
     * @param \StructType\SearchMultiSelectField $externalId
     * @param \StructType\SearchStringField $externalIdString
     * @param \StructType\SearchMultiSelectField $incoterm
     * @param \StructType\SearchMultiSelectField $internalId
     * @param \StructType\SearchLongField $internalIdNumber
     * @param \StructType\SearchMultiSelectField $item
     * @param \StructType\SearchDateField $itemEffectiveDate
     * @param \StructType\SearchDoubleField $itemExchangeRate
     * @param \StructType\SearchEnumMultiSelectField $landedCostAllocationMethod
     * @param \StructType\SearchDoubleField $landedCostAmount
     * @param \StructType\SearchMultiSelectField $landedCostCostCategory
     * @param \StructType\SearchMultiSelectField $landedCostCurrency
     * @param \StructType\SearchDateField $landedCostEffectiveDate
     * @param \StructType\SearchDoubleField $landedCostExchangeRate
     * @param \StructType\SearchStringField $memo
     * @param \StructType\SearchDoubleField $poAmount
     * @param \StructType\SearchDoubleField $poRate
     * @param \StructType\SearchMultiSelectField $purchaseOrder
     * @param \StructType\SearchDoubleField $quantityBilled
     * @param \StructType\SearchDoubleField $quantityExpected
     * @param \StructType\SearchDoubleField $quantityReceived
     * @param \StructType\SearchDoubleField $quantityRemaining
     * @param \StructType\SearchMultiSelectField $receivingLocation
     * @param \StructType\SearchMultiSelectField $shipmentBaseCurrency
     * @param \StructType\SearchMultiSelectField $shipmentNumber
     * @param \StructType\SearchEnumMultiSelectField $status
     * @param \StructType\SearchDoubleField $totalUnitCost
     * @param \StructType\SearchMultiSelectField $unit
     * @param \StructType\SearchDoubleField $unitLandedCost
     * @param \StructType\SearchMultiSelectField $vendor
     * @param \StructType\SearchStringField $vesselNumber
     * @param \StructType\SearchCustomFieldList $customFieldList
     */
    public function __construct(\StructType\SearchDateField $actualDeliveryDate = null, \StructType\SearchDateField $actualShippingDate = null, \StructType\SearchStringField $billOfLading = null, \StructType\SearchDateField $createdDate = null, \StructType\SearchMultiSelectField $currency = null, \StructType\SearchStringField $description = null, \StructType\SearchDateField $expectedDeliveryDate = null, \StructType\SearchDoubleField $expectedRate = null, \StructType\SearchDateField $expectedShippingDate = null, \StructType\SearchMultiSelectField $externalDocumentNumber = null, \StructType\SearchMultiSelectField $externalId = null, \StructType\SearchStringField $externalIdString = null, \StructType\SearchMultiSelectField $incoterm = null, \StructType\SearchMultiSelectField $internalId = null, \StructType\SearchLongField $internalIdNumber = null, \StructType\SearchMultiSelectField $item = null, \StructType\SearchDateField $itemEffectiveDate = null, \StructType\SearchDoubleField $itemExchangeRate = null, \StructType\SearchEnumMultiSelectField $landedCostAllocationMethod = null, \StructType\SearchDoubleField $landedCostAmount = null, \StructType\SearchMultiSelectField $landedCostCostCategory = null, \StructType\SearchMultiSelectField $landedCostCurrency = null, \StructType\SearchDateField $landedCostEffectiveDate = null, \StructType\SearchDoubleField $landedCostExchangeRate = null, \StructType\SearchStringField $memo = null, \StructType\SearchDoubleField $poAmount = null, \StructType\SearchDoubleField $poRate = null, \StructType\SearchMultiSelectField $purchaseOrder = null, \StructType\SearchDoubleField $quantityBilled = null, \StructType\SearchDoubleField $quantityExpected = null, \StructType\SearchDoubleField $quantityReceived = null, \StructType\SearchDoubleField $quantityRemaining = null, \StructType\SearchMultiSelectField $receivingLocation = null, \StructType\SearchMultiSelectField $shipmentBaseCurrency = null, \StructType\SearchMultiSelectField $shipmentNumber = null, \StructType\SearchEnumMultiSelectField $status = null, \StructType\SearchDoubleField $totalUnitCost = null, \StructType\SearchMultiSelectField $unit = null, \StructType\SearchDoubleField $unitLandedCost = null, \StructType\SearchMultiSelectField $vendor = null, \StructType\SearchStringField $vesselNumber = null, \StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualShippingDate($actualShippingDate)
            ->setBillOfLading($billOfLading)
            ->setCreatedDate($createdDate)
            ->setCurrency($currency)
            ->setDescription($description)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setExpectedRate($expectedRate)
            ->setExpectedShippingDate($expectedShippingDate)
            ->setExternalDocumentNumber($externalDocumentNumber)
            ->setExternalId($externalId)
            ->setExternalIdString($externalIdString)
            ->setIncoterm($incoterm)
            ->setInternalId($internalId)
            ->setInternalIdNumber($internalIdNumber)
            ->setItem($item)
            ->setItemEffectiveDate($itemEffectiveDate)
            ->setItemExchangeRate($itemExchangeRate)
            ->setLandedCostAllocationMethod($landedCostAllocationMethod)
            ->setLandedCostAmount($landedCostAmount)
            ->setLandedCostCostCategory($landedCostCostCategory)
            ->setLandedCostCurrency($landedCostCurrency)
            ->setLandedCostEffectiveDate($landedCostEffectiveDate)
            ->setLandedCostExchangeRate($landedCostExchangeRate)
            ->setMemo($memo)
            ->setPoAmount($poAmount)
            ->setPoRate($poRate)
            ->setPurchaseOrder($purchaseOrder)
            ->setQuantityBilled($quantityBilled)
            ->setQuantityExpected($quantityExpected)
            ->setQuantityReceived($quantityReceived)
            ->setQuantityRemaining($quantityRemaining)
            ->setReceivingLocation($receivingLocation)
            ->setShipmentBaseCurrency($shipmentBaseCurrency)
            ->setShipmentNumber($shipmentNumber)
            ->setStatus($status)
            ->setTotalUnitCost($totalUnitCost)
            ->setUnit($unit)
            ->setUnitLandedCost($unitLandedCost)
            ->setVendor($vendor)
            ->setVesselNumber($vesselNumber)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get actualDeliveryDate value
     * @return \StructType\SearchDateField|null
     */
    public function getActualDeliveryDate()
    {
        return $this->actualDeliveryDate;
    }
    /**
     * Set actualDeliveryDate value
     * @param \StructType\SearchDateField $actualDeliveryDate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setActualDeliveryDate(\StructType\SearchDateField $actualDeliveryDate = null)
    {
        $this->actualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Get actualShippingDate value
     * @return \StructType\SearchDateField|null
     */
    public function getActualShippingDate()
    {
        return $this->actualShippingDate;
    }
    /**
     * Set actualShippingDate value
     * @param \StructType\SearchDateField $actualShippingDate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setActualShippingDate(\StructType\SearchDateField $actualShippingDate = null)
    {
        $this->actualShippingDate = $actualShippingDate;
        return $this;
    }
    /**
     * Get billOfLading value
     * @return \StructType\SearchStringField|null
     */
    public function getBillOfLading()
    {
        return $this->billOfLading;
    }
    /**
     * Set billOfLading value
     * @param \StructType\SearchStringField $billOfLading
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setBillOfLading(\StructType\SearchStringField $billOfLading = null)
    {
        $this->billOfLading = $billOfLading;
        return $this;
    }
    /**
     * Get createdDate value
     * @return \StructType\SearchDateField|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param \StructType\SearchDateField $createdDate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setCreatedDate(\StructType\SearchDateField $createdDate = null)
    {
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\SearchMultiSelectField $currency
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setCurrency(\StructType\SearchMultiSelectField $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\SearchStringField|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param \StructType\SearchStringField $description
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setDescription(\StructType\SearchStringField $description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get expectedDeliveryDate value
     * @return \StructType\SearchDateField|null
     */
    public function getExpectedDeliveryDate()
    {
        return $this->expectedDeliveryDate;
    }
    /**
     * Set expectedDeliveryDate value
     * @param \StructType\SearchDateField $expectedDeliveryDate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setExpectedDeliveryDate(\StructType\SearchDateField $expectedDeliveryDate = null)
    {
        $this->expectedDeliveryDate = $expectedDeliveryDate;
        return $this;
    }
    /**
     * Get expectedRate value
     * @return \StructType\SearchDoubleField|null
     */
    public function getExpectedRate()
    {
        return $this->expectedRate;
    }
    /**
     * Set expectedRate value
     * @param \StructType\SearchDoubleField $expectedRate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setExpectedRate(\StructType\SearchDoubleField $expectedRate = null)
    {
        $this->expectedRate = $expectedRate;
        return $this;
    }
    /**
     * Get expectedShippingDate value
     * @return \StructType\SearchDateField|null
     */
    public function getExpectedShippingDate()
    {
        return $this->expectedShippingDate;
    }
    /**
     * Set expectedShippingDate value
     * @param \StructType\SearchDateField $expectedShippingDate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setExpectedShippingDate(\StructType\SearchDateField $expectedShippingDate = null)
    {
        $this->expectedShippingDate = $expectedShippingDate;
        return $this;
    }
    /**
     * Get externalDocumentNumber value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExternalDocumentNumber()
    {
        return $this->externalDocumentNumber;
    }
    /**
     * Set externalDocumentNumber value
     * @param \StructType\SearchMultiSelectField $externalDocumentNumber
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setExternalDocumentNumber(\StructType\SearchMultiSelectField $externalDocumentNumber = null)
    {
        $this->externalDocumentNumber = $externalDocumentNumber;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param \StructType\SearchMultiSelectField $externalId
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setExternalId(\StructType\SearchMultiSelectField $externalId = null)
    {
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get externalIdString value
     * @return \StructType\SearchStringField|null
     */
    public function getExternalIdString()
    {
        return $this->externalIdString;
    }
    /**
     * Set externalIdString value
     * @param \StructType\SearchStringField $externalIdString
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setExternalIdString(\StructType\SearchStringField $externalIdString = null)
    {
        $this->externalIdString = $externalIdString;
        return $this;
    }
    /**
     * Get incoterm value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * Set incoterm value
     * @param \StructType\SearchMultiSelectField $incoterm
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setIncoterm(\StructType\SearchMultiSelectField $incoterm = null)
    {
        $this->incoterm = $incoterm;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param \StructType\SearchMultiSelectField $internalId
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setInternalId(\StructType\SearchMultiSelectField $internalId = null)
    {
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get internalIdNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getInternalIdNumber()
    {
        return $this->internalIdNumber;
    }
    /**
     * Set internalIdNumber value
     * @param \StructType\SearchLongField $internalIdNumber
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setInternalIdNumber(\StructType\SearchLongField $internalIdNumber = null)
    {
        $this->internalIdNumber = $internalIdNumber;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\SearchMultiSelectField $item
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setItem(\StructType\SearchMultiSelectField $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get itemEffectiveDate value
     * @return \StructType\SearchDateField|null
     */
    public function getItemEffectiveDate()
    {
        return $this->itemEffectiveDate;
    }
    /**
     * Set itemEffectiveDate value
     * @param \StructType\SearchDateField $itemEffectiveDate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setItemEffectiveDate(\StructType\SearchDateField $itemEffectiveDate = null)
    {
        $this->itemEffectiveDate = $itemEffectiveDate;
        return $this;
    }
    /**
     * Get itemExchangeRate value
     * @return \StructType\SearchDoubleField|null
     */
    public function getItemExchangeRate()
    {
        return $this->itemExchangeRate;
    }
    /**
     * Set itemExchangeRate value
     * @param \StructType\SearchDoubleField $itemExchangeRate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setItemExchangeRate(\StructType\SearchDoubleField $itemExchangeRate = null)
    {
        $this->itemExchangeRate = $itemExchangeRate;
        return $this;
    }
    /**
     * Get landedCostAllocationMethod value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getLandedCostAllocationMethod()
    {
        return $this->landedCostAllocationMethod;
    }
    /**
     * Set landedCostAllocationMethod value
     * @param \StructType\SearchEnumMultiSelectField $landedCostAllocationMethod
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setLandedCostAllocationMethod(\StructType\SearchEnumMultiSelectField $landedCostAllocationMethod = null)
    {
        $this->landedCostAllocationMethod = $landedCostAllocationMethod;
        return $this;
    }
    /**
     * Get landedCostAmount value
     * @return \StructType\SearchDoubleField|null
     */
    public function getLandedCostAmount()
    {
        return $this->landedCostAmount;
    }
    /**
     * Set landedCostAmount value
     * @param \StructType\SearchDoubleField $landedCostAmount
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setLandedCostAmount(\StructType\SearchDoubleField $landedCostAmount = null)
    {
        $this->landedCostAmount = $landedCostAmount;
        return $this;
    }
    /**
     * Get landedCostCostCategory value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getLandedCostCostCategory()
    {
        return $this->landedCostCostCategory;
    }
    /**
     * Set landedCostCostCategory value
     * @param \StructType\SearchMultiSelectField $landedCostCostCategory
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setLandedCostCostCategory(\StructType\SearchMultiSelectField $landedCostCostCategory = null)
    {
        $this->landedCostCostCategory = $landedCostCostCategory;
        return $this;
    }
    /**
     * Get landedCostCurrency value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getLandedCostCurrency()
    {
        return $this->landedCostCurrency;
    }
    /**
     * Set landedCostCurrency value
     * @param \StructType\SearchMultiSelectField $landedCostCurrency
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setLandedCostCurrency(\StructType\SearchMultiSelectField $landedCostCurrency = null)
    {
        $this->landedCostCurrency = $landedCostCurrency;
        return $this;
    }
    /**
     * Get landedCostEffectiveDate value
     * @return \StructType\SearchDateField|null
     */
    public function getLandedCostEffectiveDate()
    {
        return $this->landedCostEffectiveDate;
    }
    /**
     * Set landedCostEffectiveDate value
     * @param \StructType\SearchDateField $landedCostEffectiveDate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setLandedCostEffectiveDate(\StructType\SearchDateField $landedCostEffectiveDate = null)
    {
        $this->landedCostEffectiveDate = $landedCostEffectiveDate;
        return $this;
    }
    /**
     * Get landedCostExchangeRate value
     * @return \StructType\SearchDoubleField|null
     */
    public function getLandedCostExchangeRate()
    {
        return $this->landedCostExchangeRate;
    }
    /**
     * Set landedCostExchangeRate value
     * @param \StructType\SearchDoubleField $landedCostExchangeRate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setLandedCostExchangeRate(\StructType\SearchDoubleField $landedCostExchangeRate = null)
    {
        $this->landedCostExchangeRate = $landedCostExchangeRate;
        return $this;
    }
    /**
     * Get memo value
     * @return \StructType\SearchStringField|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param \StructType\SearchStringField $memo
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setMemo(\StructType\SearchStringField $memo = null)
    {
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get poAmount value
     * @return \StructType\SearchDoubleField|null
     */
    public function getPoAmount()
    {
        return $this->poAmount;
    }
    /**
     * Set poAmount value
     * @param \StructType\SearchDoubleField $poAmount
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setPoAmount(\StructType\SearchDoubleField $poAmount = null)
    {
        $this->poAmount = $poAmount;
        return $this;
    }
    /**
     * Get poRate value
     * @return \StructType\SearchDoubleField|null
     */
    public function getPoRate()
    {
        return $this->poRate;
    }
    /**
     * Set poRate value
     * @param \StructType\SearchDoubleField $poRate
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setPoRate(\StructType\SearchDoubleField $poRate = null)
    {
        $this->poRate = $poRate;
        return $this;
    }
    /**
     * Get purchaseOrder value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    /**
     * Set purchaseOrder value
     * @param \StructType\SearchMultiSelectField $purchaseOrder
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setPurchaseOrder(\StructType\SearchMultiSelectField $purchaseOrder = null)
    {
        $this->purchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Get quantityBilled value
     * @return \StructType\SearchDoubleField|null
     */
    public function getQuantityBilled()
    {
        return $this->quantityBilled;
    }
    /**
     * Set quantityBilled value
     * @param \StructType\SearchDoubleField $quantityBilled
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setQuantityBilled(\StructType\SearchDoubleField $quantityBilled = null)
    {
        $this->quantityBilled = $quantityBilled;
        return $this;
    }
    /**
     * Get quantityExpected value
     * @return \StructType\SearchDoubleField|null
     */
    public function getQuantityExpected()
    {
        return $this->quantityExpected;
    }
    /**
     * Set quantityExpected value
     * @param \StructType\SearchDoubleField $quantityExpected
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setQuantityExpected(\StructType\SearchDoubleField $quantityExpected = null)
    {
        $this->quantityExpected = $quantityExpected;
        return $this;
    }
    /**
     * Get quantityReceived value
     * @return \StructType\SearchDoubleField|null
     */
    public function getQuantityReceived()
    {
        return $this->quantityReceived;
    }
    /**
     * Set quantityReceived value
     * @param \StructType\SearchDoubleField $quantityReceived
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setQuantityReceived(\StructType\SearchDoubleField $quantityReceived = null)
    {
        $this->quantityReceived = $quantityReceived;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return \StructType\SearchDoubleField|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * Set quantityRemaining value
     * @param \StructType\SearchDoubleField $quantityRemaining
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setQuantityRemaining(\StructType\SearchDoubleField $quantityRemaining = null)
    {
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Get receivingLocation value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getReceivingLocation()
    {
        return $this->receivingLocation;
    }
    /**
     * Set receivingLocation value
     * @param \StructType\SearchMultiSelectField $receivingLocation
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setReceivingLocation(\StructType\SearchMultiSelectField $receivingLocation = null)
    {
        $this->receivingLocation = $receivingLocation;
        return $this;
    }
    /**
     * Get shipmentBaseCurrency value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getShipmentBaseCurrency()
    {
        return $this->shipmentBaseCurrency;
    }
    /**
     * Set shipmentBaseCurrency value
     * @param \StructType\SearchMultiSelectField $shipmentBaseCurrency
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setShipmentBaseCurrency(\StructType\SearchMultiSelectField $shipmentBaseCurrency = null)
    {
        $this->shipmentBaseCurrency = $shipmentBaseCurrency;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param \StructType\SearchMultiSelectField $shipmentNumber
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setShipmentNumber(\StructType\SearchMultiSelectField $shipmentNumber = null)
    {
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\SearchEnumMultiSelectField $status
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setStatus(\StructType\SearchEnumMultiSelectField $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalUnitCost value
     * @return \StructType\SearchDoubleField|null
     */
    public function getTotalUnitCost()
    {
        return $this->totalUnitCost;
    }
    /**
     * Set totalUnitCost value
     * @param \StructType\SearchDoubleField $totalUnitCost
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setTotalUnitCost(\StructType\SearchDoubleField $totalUnitCost = null)
    {
        $this->totalUnitCost = $totalUnitCost;
        return $this;
    }
    /**
     * Get unit value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param \StructType\SearchMultiSelectField $unit
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setUnit(\StructType\SearchMultiSelectField $unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get unitLandedCost value
     * @return \StructType\SearchDoubleField|null
     */
    public function getUnitLandedCost()
    {
        return $this->unitLandedCost;
    }
    /**
     * Set unitLandedCost value
     * @param \StructType\SearchDoubleField $unitLandedCost
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setUnitLandedCost(\StructType\SearchDoubleField $unitLandedCost = null)
    {
        $this->unitLandedCost = $unitLandedCost;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param \StructType\SearchMultiSelectField $vendor
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setVendor(\StructType\SearchMultiSelectField $vendor = null)
    {
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get vesselNumber value
     * @return \StructType\SearchStringField|null
     */
    public function getVesselNumber()
    {
        return $this->vesselNumber;
    }
    /**
     * Set vesselNumber value
     * @param \StructType\SearchStringField $vesselNumber
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setVesselNumber(\StructType\SearchStringField $vesselNumber = null)
    {
        $this->vesselNumber = $vesselNumber;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchCustomFieldList $customFieldList
     * @return \StructType\InboundShipmentSearchBasic
     */
    public function setCustomFieldList(\StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
