<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipmentSearch StructType
 * @subpackage Structs
 */
class InboundShipmentSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InboundShipmentSearchBasic
     */
    public $basic;
    /**
     * The inventoryDetailJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetailSearchBasic
     */
    public $inventoryDetailJoin;
    /**
     * The itemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $itemJoin;
    /**
     * The itemReceiptJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $itemReceiptJoin;
    /**
     * The purchaseOrderJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $purchaseOrderJoin;
    /**
     * The vendorJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorSearchBasic
     */
    public $vendorJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for InboundShipmentSearch
     * @uses InboundShipmentSearch::setBasic()
     * @uses InboundShipmentSearch::setInventoryDetailJoin()
     * @uses InboundShipmentSearch::setItemJoin()
     * @uses InboundShipmentSearch::setItemReceiptJoin()
     * @uses InboundShipmentSearch::setPurchaseOrderJoin()
     * @uses InboundShipmentSearch::setVendorJoin()
     * @uses InboundShipmentSearch::setCustomSearchJoin()
     * @param \StructType\InboundShipmentSearchBasic $basic
     * @param \StructType\InventoryDetailSearchBasic $inventoryDetailJoin
     * @param \StructType\ItemSearchBasic $itemJoin
     * @param \StructType\TransactionSearchBasic $itemReceiptJoin
     * @param \StructType\TransactionSearchBasic $purchaseOrderJoin
     * @param \StructType\VendorSearchBasic $vendorJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\InboundShipmentSearchBasic $basic = null, \StructType\InventoryDetailSearchBasic $inventoryDetailJoin = null, \StructType\ItemSearchBasic $itemJoin = null, \StructType\TransactionSearchBasic $itemReceiptJoin = null, \StructType\TransactionSearchBasic $purchaseOrderJoin = null, \StructType\VendorSearchBasic $vendorJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setInventoryDetailJoin($inventoryDetailJoin)
            ->setItemJoin($itemJoin)
            ->setItemReceiptJoin($itemReceiptJoin)
            ->setPurchaseOrderJoin($purchaseOrderJoin)
            ->setVendorJoin($vendorJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\InboundShipmentSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\InboundShipmentSearchBasic $basic
     * @return \StructType\InboundShipmentSearch
     */
    public function setBasic(\StructType\InboundShipmentSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get inventoryDetailJoin value
     * @return \StructType\InventoryDetailSearchBasic|null
     */
    public function getInventoryDetailJoin()
    {
        return $this->inventoryDetailJoin;
    }
    /**
     * Set inventoryDetailJoin value
     * @param \StructType\InventoryDetailSearchBasic $inventoryDetailJoin
     * @return \StructType\InboundShipmentSearch
     */
    public function setInventoryDetailJoin(\StructType\InventoryDetailSearchBasic $inventoryDetailJoin = null)
    {
        $this->inventoryDetailJoin = $inventoryDetailJoin;
        return $this;
    }
    /**
     * Get itemJoin value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getItemJoin()
    {
        return $this->itemJoin;
    }
    /**
     * Set itemJoin value
     * @param \StructType\ItemSearchBasic $itemJoin
     * @return \StructType\InboundShipmentSearch
     */
    public function setItemJoin(\StructType\ItemSearchBasic $itemJoin = null)
    {
        $this->itemJoin = $itemJoin;
        return $this;
    }
    /**
     * Get itemReceiptJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getItemReceiptJoin()
    {
        return $this->itemReceiptJoin;
    }
    /**
     * Set itemReceiptJoin value
     * @param \StructType\TransactionSearchBasic $itemReceiptJoin
     * @return \StructType\InboundShipmentSearch
     */
    public function setItemReceiptJoin(\StructType\TransactionSearchBasic $itemReceiptJoin = null)
    {
        $this->itemReceiptJoin = $itemReceiptJoin;
        return $this;
    }
    /**
     * Get purchaseOrderJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getPurchaseOrderJoin()
    {
        return $this->purchaseOrderJoin;
    }
    /**
     * Set purchaseOrderJoin value
     * @param \StructType\TransactionSearchBasic $purchaseOrderJoin
     * @return \StructType\InboundShipmentSearch
     */
    public function setPurchaseOrderJoin(\StructType\TransactionSearchBasic $purchaseOrderJoin = null)
    {
        $this->purchaseOrderJoin = $purchaseOrderJoin;
        return $this;
    }
    /**
     * Get vendorJoin value
     * @return \StructType\VendorSearchBasic|null
     */
    public function getVendorJoin()
    {
        return $this->vendorJoin;
    }
    /**
     * Set vendorJoin value
     * @param \StructType\VendorSearchBasic $vendorJoin
     * @return \StructType\InboundShipmentSearch
     */
    public function setVendorJoin(\StructType\VendorSearchBasic $vendorJoin = null)
    {
        $this->vendorJoin = $vendorJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($inboundShipmentSearchCustomSearchJoinItem) ? get_class($inboundShipmentSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($inboundShipmentSearchCustomSearchJoinItem), var_export($inboundShipmentSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\InboundShipmentSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\InboundShipmentSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
