<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundShipmentItemsList StructType
 * @subpackage Structs
 */
class InboundShipmentItemsList extends AbstractStructBase
{
    /**
     * The inboundShipmentItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InboundShipmentItems[]
     */
    public $inboundShipmentItems;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for InboundShipmentItemsList
     * @uses InboundShipmentItemsList::setInboundShipmentItems()
     * @uses InboundShipmentItemsList::setReplaceAll()
     * @param \StructType\InboundShipmentItems[] $inboundShipmentItems
     * @param bool $replaceAll
     */
    public function __construct(array $inboundShipmentItems = array(), $replaceAll = true)
    {
        $this
            ->setInboundShipmentItems($inboundShipmentItems)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get inboundShipmentItems value
     * @return \StructType\InboundShipmentItems[]|null
     */
    public function getInboundShipmentItems()
    {
        return $this->inboundShipmentItems;
    }
    /**
     * This method is responsible for validating the values passed to the setInboundShipmentItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInboundShipmentItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInboundShipmentItemsForArrayConstraintsFromSetInboundShipmentItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundShipmentItemsListInboundShipmentItemsItem) {
            // validation for constraint: itemType
            if (!$inboundShipmentItemsListInboundShipmentItemsItem instanceof \StructType\InboundShipmentItems) {
                $invalidValues[] = is_object($inboundShipmentItemsListInboundShipmentItemsItem) ? get_class($inboundShipmentItemsListInboundShipmentItemsItem) : sprintf('%s(%s)', gettype($inboundShipmentItemsListInboundShipmentItemsItem), var_export($inboundShipmentItemsListInboundShipmentItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inboundShipmentItems property can only contain items of type \StructType\InboundShipmentItems, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inboundShipmentItems value
     * @throws \InvalidArgumentException
     * @param \StructType\InboundShipmentItems[] $inboundShipmentItems
     * @return \StructType\InboundShipmentItemsList
     */
    public function setInboundShipmentItems(array $inboundShipmentItems = array())
    {
        // validation for constraint: array
        if ('' !== ($inboundShipmentItemsArrayErrorMessage = self::validateInboundShipmentItemsForArrayConstraintsFromSetInboundShipmentItems($inboundShipmentItems))) {
            throw new \InvalidArgumentException($inboundShipmentItemsArrayErrorMessage, __LINE__);
        }
        $this->inboundShipmentItems = $inboundShipmentItems;
        return $this;
    }
    /**
     * Add item to inboundShipmentItems value
     * @throws \InvalidArgumentException
     * @param \StructType\InboundShipmentItems $item
     * @return \StructType\InboundShipmentItemsList
     */
    public function addToInboundShipmentItems(\StructType\InboundShipmentItems $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InboundShipmentItems) {
            throw new \InvalidArgumentException(sprintf('The inboundShipmentItems property can only contain items of type \StructType\InboundShipmentItems, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inboundShipmentItems[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\InboundShipmentItemsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
