<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSelectValueResult StructType
 * @subpackage Structs
 */
class GetSelectValueResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The totalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRecords;
    /**
     * The totalPages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalPages;
    /**
     * The baseRefList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:baseRefList
     * @var \StructType\BaseRefList
     */
    public $baseRefList;
    /**
     * Constructor method for GetSelectValueResult
     * @uses GetSelectValueResult::setStatus()
     * @uses GetSelectValueResult::setTotalRecords()
     * @uses GetSelectValueResult::setTotalPages()
     * @uses GetSelectValueResult::setBaseRefList()
     * @param \StructType\Status $status
     * @param int $totalRecords
     * @param int $totalPages
     * @param \StructType\BaseRefList $baseRefList
     */
    public function __construct(\StructType\Status $status = null, $totalRecords = null, $totalPages = null, \StructType\BaseRefList $baseRefList = null)
    {
        $this
            ->setStatus($status)
            ->setTotalRecords($totalRecords)
            ->setTotalPages($totalPages)
            ->setBaseRefList($baseRefList);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetSelectValueResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->totalRecords;
    }
    /**
     * Set totalRecords value
     * @param int $totalRecords
     * @return \StructType\GetSelectValueResult
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->totalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get totalPages value
     * @return int|null
     */
    public function getTotalPages()
    {
        return $this->totalPages;
    }
    /**
     * Set totalPages value
     * @param int $totalPages
     * @return \StructType\GetSelectValueResult
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->totalPages = $totalPages;
        return $this;
    }
    /**
     * Get baseRefList value
     * @return \StructType\BaseRefList|null
     */
    public function getBaseRefList()
    {
        return $this->baseRefList;
    }
    /**
     * Set baseRefList value
     * @param \StructType\BaseRefList $baseRefList
     * @return \StructType\GetSelectValueResult
     */
    public function setBaseRefList(\StructType\BaseRefList $baseRefList = null)
    {
        $this->baseRefList = $baseRefList;
        return $this;
    }
}
