<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSelectValueRequest StructType
 * @subpackage Structs
 */
class GetSelectValueRequest extends AbstractStructBase
{
    /**
     * The fieldDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GetSelectValueFieldDescription
     */
    public $fieldDescription;
    /**
     * The pageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageIndex;
    /**
     * Constructor method for getSelectValueRequest
     * @uses GetSelectValueRequest::setFieldDescription()
     * @uses GetSelectValueRequest::setPageIndex()
     * @param \StructType\GetSelectValueFieldDescription $fieldDescription
     * @param int $pageIndex
     */
    public function __construct(\StructType\GetSelectValueFieldDescription $fieldDescription = null, $pageIndex = null)
    {
        $this
            ->setFieldDescription($fieldDescription)
            ->setPageIndex($pageIndex);
    }
    /**
     * Get fieldDescription value
     * @return \StructType\GetSelectValueFieldDescription
     */
    public function getFieldDescription()
    {
        return $this->fieldDescription;
    }
    /**
     * Set fieldDescription value
     * @param \StructType\GetSelectValueFieldDescription $fieldDescription
     * @return \StructType\GetSelectValueRequest
     */
    public function setFieldDescription(\StructType\GetSelectValueFieldDescription $fieldDescription = null)
    {
        $this->fieldDescription = $fieldDescription;
        return $this;
    }
    /**
     * Get pageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }
    /**
     * Set pageIndex value
     * @param int $pageIndex
     * @return \StructType\GetSelectValueRequest
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->pageIndex = $pageIndex;
        return $this;
    }
}
