<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomizationIdRequest StructType
 * @subpackage Structs
 */
class GetCustomizationIdRequest extends AbstractStructBase
{
    /**
     * The customizationType
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\CustomizationType
     */
    public $customizationType;
    /**
     * The includeInactives
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var bool
     */
    public $includeInactives;
    /**
     * Constructor method for GetCustomizationIdRequest
     * @uses GetCustomizationIdRequest::setCustomizationType()
     * @uses GetCustomizationIdRequest::setIncludeInactives()
     * @param \StructType\CustomizationType $customizationType
     * @param bool $includeInactives
     */
    public function __construct(\StructType\CustomizationType $customizationType = null, $includeInactives = null)
    {
        $this
            ->setCustomizationType($customizationType)
            ->setIncludeInactives($includeInactives);
    }
    /**
     * Get customizationType value
     * @return \StructType\CustomizationType
     */
    public function getCustomizationType()
    {
        return $this->customizationType;
    }
    /**
     * Set customizationType value
     * @param \StructType\CustomizationType $customizationType
     * @return \StructType\GetCustomizationIdRequest
     */
    public function setCustomizationType(\StructType\CustomizationType $customizationType = null)
    {
        $this->customizationType = $customizationType;
        return $this;
    }
    /**
     * Get includeInactives value
     * @return bool
     */
    public function getIncludeInactives()
    {
        return $this->includeInactives;
    }
    /**
     * Set includeInactives value
     * @param bool $includeInactives
     * @return \StructType\GetCustomizationIdRequest
     */
    public function setIncludeInactives($includeInactives = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactives) && !is_bool($includeInactives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInactives, true), gettype($includeInactives)), __LINE__);
        }
        $this->includeInactives = $includeInactives;
        return $this;
    }
}
