<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAsyncResultRequest StructType
 * @subpackage Structs
 */
class GetAsyncResultRequest extends AbstractStructBase
{
    /**
     * The jobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $jobId;
    /**
     * The pageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageIndex;
    /**
     * Constructor method for GetAsyncResultRequest
     * @uses GetAsyncResultRequest::setJobId()
     * @uses GetAsyncResultRequest::setPageIndex()
     * @param string $jobId
     * @param int $pageIndex
     */
    public function __construct($jobId = null, $pageIndex = null)
    {
        $this
            ->setJobId($jobId)
            ->setPageIndex($pageIndex);
    }
    /**
     * Get jobId value
     * @return string
     */
    public function getJobId()
    {
        return $this->jobId;
    }
    /**
     * Set jobId value
     * @param string $jobId
     * @return \StructType\GetAsyncResultRequest
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->jobId = $jobId;
        return $this;
    }
    /**
     * Get pageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }
    /**
     * Set pageIndex value
     * @param int $pageIndex
     * @return \StructType\GetAsyncResultRequest
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->pageIndex = $pageIndex;
        return $this;
    }
}
