<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllResult StructType
 * @subpackage Structs
 */
class GetAllResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The totalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRecords;
    /**
     * The recordList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:recordList
     * @var \StructType\RecordList
     */
    public $recordList;
    /**
     * Constructor method for GetAllResult
     * @uses GetAllResult::setStatus()
     * @uses GetAllResult::setTotalRecords()
     * @uses GetAllResult::setRecordList()
     * @param \StructType\Status $status
     * @param int $totalRecords
     * @param \StructType\RecordList $recordList
     */
    public function __construct(\StructType\Status $status = null, $totalRecords = null, \StructType\RecordList $recordList = null)
    {
        $this
            ->setStatus($status)
            ->setTotalRecords($totalRecords)
            ->setRecordList($recordList);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\GetAllResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->totalRecords;
    }
    /**
     * Set totalRecords value
     * @param int $totalRecords
     * @return \StructType\GetAllResult
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->totalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get recordList value
     * @return \StructType\RecordList|null
     */
    public function getRecordList()
    {
        return $this->recordList;
    }
    /**
     * Set recordList value
     * @param \StructType\RecordList $recordList
     * @return \StructType\GetAllResult
     */
    public function setRecordList(\StructType\RecordList $recordList = null)
    {
        $this->recordList = $recordList;
        return $this;
    }
}
