<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralToken StructType
 * @subpackage Structs
 */
class GeneralToken extends Record
{
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mask;
    /**
     * The supportedOperationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GeneralTokenSupportedOperationsListList
     */
    public $supportedOperationsList;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The preserveOnFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $preserveOnFile;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * The tokenExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tokenExpirationDate;
    /**
     * The tokenFamily
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tokenFamily;
    /**
     * The tokenNamespace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tokenNamespace;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for GeneralToken
     * @uses GeneralToken::setEntity()
     * @uses GeneralToken::setMask()
     * @uses GeneralToken::setSupportedOperationsList()
     * @uses GeneralToken::setPaymentMethod()
     * @uses GeneralToken::setMemo()
     * @uses GeneralToken::setState()
     * @uses GeneralToken::setIsInactive()
     * @uses GeneralToken::setPreserveOnFile()
     * @uses GeneralToken::setIsDefault()
     * @uses GeneralToken::setToken()
     * @uses GeneralToken::setTokenExpirationDate()
     * @uses GeneralToken::setTokenFamily()
     * @uses GeneralToken::setTokenNamespace()
     * @uses GeneralToken::setInternalId()
     * @uses GeneralToken::setExternalId()
     * @param \StructType\RecordRef $entity
     * @param string $mask
     * @param \StructType\GeneralTokenSupportedOperationsListList $supportedOperationsList
     * @param \StructType\RecordRef $paymentMethod
     * @param string $memo
     * @param string $state
     * @param bool $isInactive
     * @param bool $preserveOnFile
     * @param bool $isDefault
     * @param string $token
     * @param string $tokenExpirationDate
     * @param string $tokenFamily
     * @param string $tokenNamespace
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $entity = null, $mask = null, \StructType\GeneralTokenSupportedOperationsListList $supportedOperationsList = null, \StructType\RecordRef $paymentMethod = null, $memo = null, $state = null, $isInactive = null, $preserveOnFile = null, $isDefault = null, $token = null, $tokenExpirationDate = null, $tokenFamily = null, $tokenNamespace = null, $internalId = null, $externalId = null)
    {
        $this
            ->setEntity($entity)
            ->setMask($mask)
            ->setSupportedOperationsList($supportedOperationsList)
            ->setPaymentMethod($paymentMethod)
            ->setMemo($memo)
            ->setState($state)
            ->setIsInactive($isInactive)
            ->setPreserveOnFile($preserveOnFile)
            ->setIsDefault($isDefault)
            ->setToken($token)
            ->setTokenExpirationDate($tokenExpirationDate)
            ->setTokenFamily($tokenFamily)
            ->setTokenNamespace($tokenNamespace)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\GeneralToken
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get mask value
     * @return string|null
     */
    public function getMask()
    {
        return $this->mask;
    }
    /**
     * Set mask value
     * @param string $mask
     * @return \StructType\GeneralToken
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mask, true), gettype($mask)), __LINE__);
        }
        $this->mask = $mask;
        return $this;
    }
    /**
     * Get supportedOperationsList value
     * @return \StructType\GeneralTokenSupportedOperationsListList|null
     */
    public function getSupportedOperationsList()
    {
        return $this->supportedOperationsList;
    }
    /**
     * Set supportedOperationsList value
     * @param \StructType\GeneralTokenSupportedOperationsListList $supportedOperationsList
     * @return \StructType\GeneralToken
     */
    public function setSupportedOperationsList(\StructType\GeneralTokenSupportedOperationsListList $supportedOperationsList = null)
    {
        $this->supportedOperationsList = $supportedOperationsList;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\GeneralToken
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\GeneralToken
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\PaymentInstrumentState::valueIsValid()
     * @uses \EnumType\PaymentInstrumentState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\GeneralToken
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentInstrumentState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentInstrumentState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\PaymentInstrumentState::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\GeneralToken
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get preserveOnFile value
     * @return bool|null
     */
    public function getPreserveOnFile()
    {
        return $this->preserveOnFile;
    }
    /**
     * Set preserveOnFile value
     * @param bool $preserveOnFile
     * @return \StructType\GeneralToken
     */
    public function setPreserveOnFile($preserveOnFile = null)
    {
        // validation for constraint: boolean
        if (!is_null($preserveOnFile) && !is_bool($preserveOnFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preserveOnFile, true), gettype($preserveOnFile)), __LINE__);
        }
        $this->preserveOnFile = $preserveOnFile;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\GeneralToken
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\GeneralToken
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get tokenExpirationDate value
     * @return string|null
     */
    public function getTokenExpirationDate()
    {
        return $this->tokenExpirationDate;
    }
    /**
     * Set tokenExpirationDate value
     * @param string $tokenExpirationDate
     * @return \StructType\GeneralToken
     */
    public function setTokenExpirationDate($tokenExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($tokenExpirationDate) && !is_string($tokenExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenExpirationDate, true), gettype($tokenExpirationDate)), __LINE__);
        }
        $this->tokenExpirationDate = $tokenExpirationDate;
        return $this;
    }
    /**
     * Get tokenFamily value
     * @return string|null
     */
    public function getTokenFamily()
    {
        return $this->tokenFamily;
    }
    /**
     * Set tokenFamily value
     * @uses \EnumType\TokenFamily::valueIsValid()
     * @uses \EnumType\TokenFamily::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tokenFamily
     * @return \StructType\GeneralToken
     */
    public function setTokenFamily($tokenFamily = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TokenFamily::valueIsValid($tokenFamily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TokenFamily', is_array($tokenFamily) ? implode(', ', $tokenFamily) : var_export($tokenFamily, true), implode(', ', \EnumType\TokenFamily::getValidValues())), __LINE__);
        }
        $this->tokenFamily = $tokenFamily;
        return $this;
    }
    /**
     * Get tokenNamespace value
     * @return string|null
     */
    public function getTokenNamespace()
    {
        return $this->tokenNamespace;
    }
    /**
     * Set tokenNamespace value
     * @param string $tokenNamespace
     * @return \StructType\GeneralToken
     */
    public function setTokenNamespace($tokenNamespace = null)
    {
        // validation for constraint: string
        if (!is_null($tokenNamespace) && !is_string($tokenNamespace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenNamespace, true), gettype($tokenNamespace)), __LINE__);
        }
        $this->tokenNamespace = $tokenNamespace;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\GeneralToken
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\GeneralToken
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
