<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FairValuePriceSearchRowBasic StructType
 * @subpackage Structs
 */
class FairValuePriceSearchRowBasic extends SearchRowBasic
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $currency;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $endDate;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The fairValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $fairValue;
    /**
     * The fairValueFormula
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $fairValueFormula;
    /**
     * The fairValueRangePolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $fairValueRangePolicy;
    /**
     * The highValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $highValue;
    /**
     * The highValuePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $highValuePercent;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isVsoePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isVsoePrice;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $item;
    /**
     * The itemRevenueCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $itemRevenueCategory;
    /**
     * The lowValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $lowValue;
    /**
     * The lowValuePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $lowValuePercent;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startDate;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $units;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $unitsType;
    /**
     * Constructor method for FairValuePriceSearchRowBasic
     * @uses FairValuePriceSearchRowBasic::setCurrency()
     * @uses FairValuePriceSearchRowBasic::setEndDate()
     * @uses FairValuePriceSearchRowBasic::setExternalId()
     * @uses FairValuePriceSearchRowBasic::setFairValue()
     * @uses FairValuePriceSearchRowBasic::setFairValueFormula()
     * @uses FairValuePriceSearchRowBasic::setFairValueRangePolicy()
     * @uses FairValuePriceSearchRowBasic::setHighValue()
     * @uses FairValuePriceSearchRowBasic::setHighValuePercent()
     * @uses FairValuePriceSearchRowBasic::setInternalId()
     * @uses FairValuePriceSearchRowBasic::setIsVsoePrice()
     * @uses FairValuePriceSearchRowBasic::setItem()
     * @uses FairValuePriceSearchRowBasic::setItemRevenueCategory()
     * @uses FairValuePriceSearchRowBasic::setLowValue()
     * @uses FairValuePriceSearchRowBasic::setLowValuePercent()
     * @uses FairValuePriceSearchRowBasic::setStartDate()
     * @uses FairValuePriceSearchRowBasic::setUnits()
     * @uses FairValuePriceSearchRowBasic::setUnitsType()
     * @param \StructType\SearchColumnSelectField[] $currency
     * @param \StructType\SearchColumnDateField[] $endDate
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnDoubleField[] $fairValue
     * @param \StructType\SearchColumnSelectField[] $fairValueFormula
     * @param \StructType\SearchColumnEnumSelectField[] $fairValueRangePolicy
     * @param \StructType\SearchColumnDoubleField[] $highValue
     * @param \StructType\SearchColumnDoubleField[] $highValuePercent
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isVsoePrice
     * @param \StructType\SearchColumnSelectField[] $item
     * @param \StructType\SearchColumnSelectField[] $itemRevenueCategory
     * @param \StructType\SearchColumnDoubleField[] $lowValue
     * @param \StructType\SearchColumnDoubleField[] $lowValuePercent
     * @param \StructType\SearchColumnDateField[] $startDate
     * @param \StructType\SearchColumnSelectField[] $units
     * @param \StructType\SearchColumnSelectField[] $unitsType
     */
    public function __construct(array $currency = array(), array $endDate = array(), array $externalId = array(), array $fairValue = array(), array $fairValueFormula = array(), array $fairValueRangePolicy = array(), array $highValue = array(), array $highValuePercent = array(), array $internalId = array(), array $isVsoePrice = array(), array $item = array(), array $itemRevenueCategory = array(), array $lowValue = array(), array $lowValuePercent = array(), array $startDate = array(), array $units = array(), array $unitsType = array())
    {
        $this
            ->setCurrency($currency)
            ->setEndDate($endDate)
            ->setExternalId($externalId)
            ->setFairValue($fairValue)
            ->setFairValueFormula($fairValueFormula)
            ->setFairValueRangePolicy($fairValueRangePolicy)
            ->setHighValue($highValue)
            ->setHighValuePercent($highValuePercent)
            ->setInternalId($internalId)
            ->setIsVsoePrice($isVsoePrice)
            ->setItem($item)
            ->setItemRevenueCategory($itemRevenueCategory)
            ->setLowValue($lowValue)
            ->setLowValuePercent($lowValuePercent)
            ->setStartDate($startDate)
            ->setUnits($units)
            ->setUnitsType($unitsType);
    }
    /**
     * Get currency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicCurrencyItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicCurrencyItem) ? get_class($fairValuePriceSearchRowBasicCurrencyItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicCurrencyItem), var_export($fairValuePriceSearchRowBasicCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $currency
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * This method is responsible for validating the values passed to the setEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateForArrayConstraintsFromSetEndDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicEndDateItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicEndDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicEndDateItem) ? get_class($fairValuePriceSearchRowBasicEndDateItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicEndDateItem), var_export($fairValuePriceSearchRowBasicEndDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $endDate
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setEndDate(array $endDate = array())
    {
        // validation for constraint: array
        if ('' !== ($endDateArrayErrorMessage = self::validateEndDateForArrayConstraintsFromSetEndDate($endDate))) {
            throw new \InvalidArgumentException($endDateArrayErrorMessage, __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Add item to endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToEndDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endDate[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicExternalIdItem) ? get_class($fairValuePriceSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicExternalIdItem), var_export($fairValuePriceSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get fairValue value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getFairValue()
    {
        return $this->fairValue;
    }
    /**
     * This method is responsible for validating the values passed to the setFairValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFairValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFairValueForArrayConstraintsFromSetFairValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicFairValueItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicFairValueItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicFairValueItem) ? get_class($fairValuePriceSearchRowBasicFairValueItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicFairValueItem), var_export($fairValuePriceSearchRowBasicFairValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fairValue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fairValue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $fairValue
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setFairValue(array $fairValue = array())
    {
        // validation for constraint: array
        if ('' !== ($fairValueArrayErrorMessage = self::validateFairValueForArrayConstraintsFromSetFairValue($fairValue))) {
            throw new \InvalidArgumentException($fairValueArrayErrorMessage, __LINE__);
        }
        $this->fairValue = $fairValue;
        return $this;
    }
    /**
     * Add item to fairValue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToFairValue(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The fairValue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fairValue[] = $item;
        return $this;
    }
    /**
     * Get fairValueFormula value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getFairValueFormula()
    {
        return $this->fairValueFormula;
    }
    /**
     * This method is responsible for validating the values passed to the setFairValueFormula method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFairValueFormula method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFairValueFormulaForArrayConstraintsFromSetFairValueFormula(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicFairValueFormulaItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicFairValueFormulaItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicFairValueFormulaItem) ? get_class($fairValuePriceSearchRowBasicFairValueFormulaItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicFairValueFormulaItem), var_export($fairValuePriceSearchRowBasicFairValueFormulaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fairValueFormula property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fairValueFormula value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $fairValueFormula
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setFairValueFormula(array $fairValueFormula = array())
    {
        // validation for constraint: array
        if ('' !== ($fairValueFormulaArrayErrorMessage = self::validateFairValueFormulaForArrayConstraintsFromSetFairValueFormula($fairValueFormula))) {
            throw new \InvalidArgumentException($fairValueFormulaArrayErrorMessage, __LINE__);
        }
        $this->fairValueFormula = $fairValueFormula;
        return $this;
    }
    /**
     * Add item to fairValueFormula value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToFairValueFormula(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The fairValueFormula property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fairValueFormula[] = $item;
        return $this;
    }
    /**
     * Get fairValueRangePolicy value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getFairValueRangePolicy()
    {
        return $this->fairValueRangePolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setFairValueRangePolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFairValueRangePolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFairValueRangePolicyForArrayConstraintsFromSetFairValueRangePolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicFairValueRangePolicyItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicFairValueRangePolicyItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicFairValueRangePolicyItem) ? get_class($fairValuePriceSearchRowBasicFairValueRangePolicyItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicFairValueRangePolicyItem), var_export($fairValuePriceSearchRowBasicFairValueRangePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fairValueRangePolicy property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fairValueRangePolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $fairValueRangePolicy
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setFairValueRangePolicy(array $fairValueRangePolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($fairValueRangePolicyArrayErrorMessage = self::validateFairValueRangePolicyForArrayConstraintsFromSetFairValueRangePolicy($fairValueRangePolicy))) {
            throw new \InvalidArgumentException($fairValueRangePolicyArrayErrorMessage, __LINE__);
        }
        $this->fairValueRangePolicy = $fairValueRangePolicy;
        return $this;
    }
    /**
     * Add item to fairValueRangePolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToFairValueRangePolicy(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The fairValueRangePolicy property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fairValueRangePolicy[] = $item;
        return $this;
    }
    /**
     * Get highValue value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getHighValue()
    {
        return $this->highValue;
    }
    /**
     * This method is responsible for validating the values passed to the setHighValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHighValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHighValueForArrayConstraintsFromSetHighValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicHighValueItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicHighValueItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicHighValueItem) ? get_class($fairValuePriceSearchRowBasicHighValueItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicHighValueItem), var_export($fairValuePriceSearchRowBasicHighValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The highValue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set highValue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $highValue
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setHighValue(array $highValue = array())
    {
        // validation for constraint: array
        if ('' !== ($highValueArrayErrorMessage = self::validateHighValueForArrayConstraintsFromSetHighValue($highValue))) {
            throw new \InvalidArgumentException($highValueArrayErrorMessage, __LINE__);
        }
        $this->highValue = $highValue;
        return $this;
    }
    /**
     * Add item to highValue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToHighValue(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The highValue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->highValue[] = $item;
        return $this;
    }
    /**
     * Get highValuePercent value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getHighValuePercent()
    {
        return $this->highValuePercent;
    }
    /**
     * This method is responsible for validating the values passed to the setHighValuePercent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHighValuePercent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHighValuePercentForArrayConstraintsFromSetHighValuePercent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicHighValuePercentItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicHighValuePercentItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicHighValuePercentItem) ? get_class($fairValuePriceSearchRowBasicHighValuePercentItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicHighValuePercentItem), var_export($fairValuePriceSearchRowBasicHighValuePercentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The highValuePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set highValuePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $highValuePercent
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setHighValuePercent(array $highValuePercent = array())
    {
        // validation for constraint: array
        if ('' !== ($highValuePercentArrayErrorMessage = self::validateHighValuePercentForArrayConstraintsFromSetHighValuePercent($highValuePercent))) {
            throw new \InvalidArgumentException($highValuePercentArrayErrorMessage, __LINE__);
        }
        $this->highValuePercent = $highValuePercent;
        return $this;
    }
    /**
     * Add item to highValuePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToHighValuePercent(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The highValuePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->highValuePercent[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicInternalIdItem) ? get_class($fairValuePriceSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicInternalIdItem), var_export($fairValuePriceSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isVsoePrice value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsVsoePrice()
    {
        return $this->isVsoePrice;
    }
    /**
     * This method is responsible for validating the values passed to the setIsVsoePrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsVsoePrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsVsoePriceForArrayConstraintsFromSetIsVsoePrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicIsVsoePriceItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicIsVsoePriceItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicIsVsoePriceItem) ? get_class($fairValuePriceSearchRowBasicIsVsoePriceItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicIsVsoePriceItem), var_export($fairValuePriceSearchRowBasicIsVsoePriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isVsoePrice property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isVsoePrice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isVsoePrice
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setIsVsoePrice(array $isVsoePrice = array())
    {
        // validation for constraint: array
        if ('' !== ($isVsoePriceArrayErrorMessage = self::validateIsVsoePriceForArrayConstraintsFromSetIsVsoePrice($isVsoePrice))) {
            throw new \InvalidArgumentException($isVsoePriceArrayErrorMessage, __LINE__);
        }
        $this->isVsoePrice = $isVsoePrice;
        return $this;
    }
    /**
     * Add item to isVsoePrice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToIsVsoePrice(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isVsoePrice property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isVsoePrice[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicItemItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicItemItem) ? get_class($fairValuePriceSearchRowBasicItemItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicItemItem), var_export($fairValuePriceSearchRowBasicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get itemRevenueCategory value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getItemRevenueCategory()
    {
        return $this->itemRevenueCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setItemRevenueCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemRevenueCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemRevenueCategoryForArrayConstraintsFromSetItemRevenueCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicItemRevenueCategoryItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicItemRevenueCategoryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicItemRevenueCategoryItem) ? get_class($fairValuePriceSearchRowBasicItemRevenueCategoryItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicItemRevenueCategoryItem), var_export($fairValuePriceSearchRowBasicItemRevenueCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemRevenueCategory property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemRevenueCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $itemRevenueCategory
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setItemRevenueCategory(array $itemRevenueCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($itemRevenueCategoryArrayErrorMessage = self::validateItemRevenueCategoryForArrayConstraintsFromSetItemRevenueCategory($itemRevenueCategory))) {
            throw new \InvalidArgumentException($itemRevenueCategoryArrayErrorMessage, __LINE__);
        }
        $this->itemRevenueCategory = $itemRevenueCategory;
        return $this;
    }
    /**
     * Add item to itemRevenueCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToItemRevenueCategory(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The itemRevenueCategory property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemRevenueCategory[] = $item;
        return $this;
    }
    /**
     * Get lowValue value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getLowValue()
    {
        return $this->lowValue;
    }
    /**
     * This method is responsible for validating the values passed to the setLowValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLowValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLowValueForArrayConstraintsFromSetLowValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicLowValueItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicLowValueItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicLowValueItem) ? get_class($fairValuePriceSearchRowBasicLowValueItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicLowValueItem), var_export($fairValuePriceSearchRowBasicLowValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lowValue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lowValue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $lowValue
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setLowValue(array $lowValue = array())
    {
        // validation for constraint: array
        if ('' !== ($lowValueArrayErrorMessage = self::validateLowValueForArrayConstraintsFromSetLowValue($lowValue))) {
            throw new \InvalidArgumentException($lowValueArrayErrorMessage, __LINE__);
        }
        $this->lowValue = $lowValue;
        return $this;
    }
    /**
     * Add item to lowValue value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToLowValue(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The lowValue property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lowValue[] = $item;
        return $this;
    }
    /**
     * Get lowValuePercent value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getLowValuePercent()
    {
        return $this->lowValuePercent;
    }
    /**
     * This method is responsible for validating the values passed to the setLowValuePercent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLowValuePercent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLowValuePercentForArrayConstraintsFromSetLowValuePercent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicLowValuePercentItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicLowValuePercentItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicLowValuePercentItem) ? get_class($fairValuePriceSearchRowBasicLowValuePercentItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicLowValuePercentItem), var_export($fairValuePriceSearchRowBasicLowValuePercentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lowValuePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lowValuePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $lowValuePercent
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setLowValuePercent(array $lowValuePercent = array())
    {
        // validation for constraint: array
        if ('' !== ($lowValuePercentArrayErrorMessage = self::validateLowValuePercentForArrayConstraintsFromSetLowValuePercent($lowValuePercent))) {
            throw new \InvalidArgumentException($lowValuePercentArrayErrorMessage, __LINE__);
        }
        $this->lowValuePercent = $lowValuePercent;
        return $this;
    }
    /**
     * Add item to lowValuePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToLowValuePercent(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The lowValuePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lowValuePercent[] = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateForArrayConstraintsFromSetStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicStartDateItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicStartDateItem) ? get_class($fairValuePriceSearchRowBasicStartDateItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicStartDateItem), var_export($fairValuePriceSearchRowBasicStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startDate
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setStartDate(array $startDate = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateArrayErrorMessage = self::validateStartDateForArrayConstraintsFromSetStartDate($startDate))) {
            throw new \InvalidArgumentException($startDateArrayErrorMessage, __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Add item to startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDate[] = $item;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * This method is responsible for validating the values passed to the setUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitsForArrayConstraintsFromSetUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicUnitsItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicUnitsItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicUnitsItem) ? get_class($fairValuePriceSearchRowBasicUnitsItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicUnitsItem), var_export($fairValuePriceSearchRowBasicUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The units property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $units
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setUnits(array $units = array())
    {
        // validation for constraint: array
        if ('' !== ($unitsArrayErrorMessage = self::validateUnitsForArrayConstraintsFromSetUnits($units))) {
            throw new \InvalidArgumentException($unitsArrayErrorMessage, __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Add item to units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToUnits(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The units property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->units[] = $item;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitsType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitsType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitsTypeForArrayConstraintsFromSetUnitsType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairValuePriceSearchRowBasicUnitsTypeItem) {
            // validation for constraint: itemType
            if (!$fairValuePriceSearchRowBasicUnitsTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($fairValuePriceSearchRowBasicUnitsTypeItem) ? get_class($fairValuePriceSearchRowBasicUnitsTypeItem) : sprintf('%s(%s)', gettype($fairValuePriceSearchRowBasicUnitsTypeItem), var_export($fairValuePriceSearchRowBasicUnitsTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitsType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitsType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $unitsType
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function setUnitsType(array $unitsType = array())
    {
        // validation for constraint: array
        if ('' !== ($unitsTypeArrayErrorMessage = self::validateUnitsTypeForArrayConstraintsFromSetUnitsType($unitsType))) {
            throw new \InvalidArgumentException($unitsTypeArrayErrorMessage, __LINE__);
        }
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Add item to unitsType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\FairValuePriceSearchRowBasic
     */
    public function addToUnitsType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The unitsType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitsType[] = $item;
        return $this;
    }
}
