<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FairValuePrice StructType
 * @subpackage Structs
 */
class FairValuePrice extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The itemRevenueCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemRevenueCategory;
    /**
     * The fairValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fairValue;
    /**
     * The fairValueFormula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $fairValueFormula;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unitsType;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The fairValueRangePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fairValueRangePolicy;
    /**
     * The lowValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lowValue;
    /**
     * The lowValuePercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lowValuePercent;
    /**
     * The highValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $highValue;
    /**
     * The highValuePercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $highValuePercent;
    /**
     * The isVsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isVsoePrice;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The dimensionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DimensionList
     */
    public $dimensionList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for FairValuePrice
     * @uses FairValuePrice::setCustomForm()
     * @uses FairValuePrice::setItem()
     * @uses FairValuePrice::setItemRevenueCategory()
     * @uses FairValuePrice::setFairValue()
     * @uses FairValuePrice::setFairValueFormula()
     * @uses FairValuePrice::setCurrency()
     * @uses FairValuePrice::setUnitsType()
     * @uses FairValuePrice::setUnits()
     * @uses FairValuePrice::setFairValueRangePolicy()
     * @uses FairValuePrice::setLowValue()
     * @uses FairValuePrice::setLowValuePercent()
     * @uses FairValuePrice::setHighValue()
     * @uses FairValuePrice::setHighValuePercent()
     * @uses FairValuePrice::setIsVsoePrice()
     * @uses FairValuePrice::setStartDate()
     * @uses FairValuePrice::setEndDate()
     * @uses FairValuePrice::setCustomFieldList()
     * @uses FairValuePrice::setDimensionList()
     * @uses FairValuePrice::setInternalId()
     * @uses FairValuePrice::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $itemRevenueCategory
     * @param float $fairValue
     * @param \StructType\RecordRef $fairValueFormula
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $unitsType
     * @param \StructType\RecordRef $units
     * @param string $fairValueRangePolicy
     * @param float $lowValue
     * @param float $lowValuePercent
     * @param float $highValue
     * @param float $highValuePercent
     * @param bool $isVsoePrice
     * @param string $startDate
     * @param string $endDate
     * @param \StructType\CustomFieldList $customFieldList
     * @param \StructType\DimensionList $dimensionList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $item = null, \StructType\RecordRef $itemRevenueCategory = null, $fairValue = null, \StructType\RecordRef $fairValueFormula = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $unitsType = null, \StructType\RecordRef $units = null, $fairValueRangePolicy = null, $lowValue = null, $lowValuePercent = null, $highValue = null, $highValuePercent = null, $isVsoePrice = null, $startDate = null, $endDate = null, \StructType\CustomFieldList $customFieldList = null, \StructType\DimensionList $dimensionList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setItem($item)
            ->setItemRevenueCategory($itemRevenueCategory)
            ->setFairValue($fairValue)
            ->setFairValueFormula($fairValueFormula)
            ->setCurrency($currency)
            ->setUnitsType($unitsType)
            ->setUnits($units)
            ->setFairValueRangePolicy($fairValueRangePolicy)
            ->setLowValue($lowValue)
            ->setLowValuePercent($lowValuePercent)
            ->setHighValue($highValue)
            ->setHighValuePercent($highValuePercent)
            ->setIsVsoePrice($isVsoePrice)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCustomFieldList($customFieldList)
            ->setDimensionList($dimensionList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\FairValuePrice
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\FairValuePrice
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get itemRevenueCategory value
     * @return \StructType\RecordRef|null
     */
    public function getItemRevenueCategory()
    {
        return $this->itemRevenueCategory;
    }
    /**
     * Set itemRevenueCategory value
     * @param \StructType\RecordRef $itemRevenueCategory
     * @return \StructType\FairValuePrice
     */
    public function setItemRevenueCategory(\StructType\RecordRef $itemRevenueCategory = null)
    {
        $this->itemRevenueCategory = $itemRevenueCategory;
        return $this;
    }
    /**
     * Get fairValue value
     * @return float|null
     */
    public function getFairValue()
    {
        return $this->fairValue;
    }
    /**
     * Set fairValue value
     * @param float $fairValue
     * @return \StructType\FairValuePrice
     */
    public function setFairValue($fairValue = null)
    {
        // validation for constraint: float
        if (!is_null($fairValue) && !(is_float($fairValue) || is_numeric($fairValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fairValue, true), gettype($fairValue)), __LINE__);
        }
        $this->fairValue = $fairValue;
        return $this;
    }
    /**
     * Get fairValueFormula value
     * @return \StructType\RecordRef|null
     */
    public function getFairValueFormula()
    {
        return $this->fairValueFormula;
    }
    /**
     * Set fairValueFormula value
     * @param \StructType\RecordRef $fairValueFormula
     * @return \StructType\FairValuePrice
     */
    public function setFairValueFormula(\StructType\RecordRef $fairValueFormula = null)
    {
        $this->fairValueFormula = $fairValueFormula;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\FairValuePrice
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\RecordRef|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * Set unitsType value
     * @param \StructType\RecordRef $unitsType
     * @return \StructType\FairValuePrice
     */
    public function setUnitsType(\StructType\RecordRef $unitsType = null)
    {
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\FairValuePrice
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get fairValueRangePolicy value
     * @return string|null
     */
    public function getFairValueRangePolicy()
    {
        return $this->fairValueRangePolicy;
    }
    /**
     * Set fairValueRangePolicy value
     * @uses \EnumType\FairValuePriceFairValueRangePolicy::valueIsValid()
     * @uses \EnumType\FairValuePriceFairValueRangePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fairValueRangePolicy
     * @return \StructType\FairValuePrice
     */
    public function setFairValueRangePolicy($fairValueRangePolicy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FairValuePriceFairValueRangePolicy::valueIsValid($fairValueRangePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FairValuePriceFairValueRangePolicy', is_array($fairValueRangePolicy) ? implode(', ', $fairValueRangePolicy) : var_export($fairValueRangePolicy, true), implode(', ', \EnumType\FairValuePriceFairValueRangePolicy::getValidValues())), __LINE__);
        }
        $this->fairValueRangePolicy = $fairValueRangePolicy;
        return $this;
    }
    /**
     * Get lowValue value
     * @return float|null
     */
    public function getLowValue()
    {
        return $this->lowValue;
    }
    /**
     * Set lowValue value
     * @param float $lowValue
     * @return \StructType\FairValuePrice
     */
    public function setLowValue($lowValue = null)
    {
        // validation for constraint: float
        if (!is_null($lowValue) && !(is_float($lowValue) || is_numeric($lowValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lowValue, true), gettype($lowValue)), __LINE__);
        }
        $this->lowValue = $lowValue;
        return $this;
    }
    /**
     * Get lowValuePercent value
     * @return float|null
     */
    public function getLowValuePercent()
    {
        return $this->lowValuePercent;
    }
    /**
     * Set lowValuePercent value
     * @param float $lowValuePercent
     * @return \StructType\FairValuePrice
     */
    public function setLowValuePercent($lowValuePercent = null)
    {
        // validation for constraint: float
        if (!is_null($lowValuePercent) && !(is_float($lowValuePercent) || is_numeric($lowValuePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lowValuePercent, true), gettype($lowValuePercent)), __LINE__);
        }
        $this->lowValuePercent = $lowValuePercent;
        return $this;
    }
    /**
     * Get highValue value
     * @return float|null
     */
    public function getHighValue()
    {
        return $this->highValue;
    }
    /**
     * Set highValue value
     * @param float $highValue
     * @return \StructType\FairValuePrice
     */
    public function setHighValue($highValue = null)
    {
        // validation for constraint: float
        if (!is_null($highValue) && !(is_float($highValue) || is_numeric($highValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($highValue, true), gettype($highValue)), __LINE__);
        }
        $this->highValue = $highValue;
        return $this;
    }
    /**
     * Get highValuePercent value
     * @return float|null
     */
    public function getHighValuePercent()
    {
        return $this->highValuePercent;
    }
    /**
     * Set highValuePercent value
     * @param float $highValuePercent
     * @return \StructType\FairValuePrice
     */
    public function setHighValuePercent($highValuePercent = null)
    {
        // validation for constraint: float
        if (!is_null($highValuePercent) && !(is_float($highValuePercent) || is_numeric($highValuePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($highValuePercent, true), gettype($highValuePercent)), __LINE__);
        }
        $this->highValuePercent = $highValuePercent;
        return $this;
    }
    /**
     * Get isVsoePrice value
     * @return bool|null
     */
    public function getIsVsoePrice()
    {
        return $this->isVsoePrice;
    }
    /**
     * Set isVsoePrice value
     * @param bool $isVsoePrice
     * @return \StructType\FairValuePrice
     */
    public function setIsVsoePrice($isVsoePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVsoePrice) && !is_bool($isVsoePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVsoePrice, true), gettype($isVsoePrice)), __LINE__);
        }
        $this->isVsoePrice = $isVsoePrice;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\FairValuePrice
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\FairValuePrice
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\FairValuePrice
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get dimensionList value
     * @return \StructType\DimensionList|null
     */
    public function getDimensionList()
    {
        return $this->dimensionList;
    }
    /**
     * Set dimensionList value
     * @param \StructType\DimensionList $dimensionList
     * @return \StructType\FairValuePrice
     */
    public function setDimensionList(\StructType\DimensionList $dimensionList = null)
    {
        $this->dimensionList = $dimensionList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\FairValuePrice
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\FairValuePrice
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
