<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseReportExpense StructType
 * @subpackage Structs
 */
class ExpenseReportExpense extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The expenseDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expenseDate;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The foreignAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $foreignAmount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The expMediaItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expMediaItem;
    /**
     * The isNonReimbursable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isNonReimbursable;
    /**
     * The corporateCreditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $corporateCreditCard;
    /**
     * The receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $receipt;
    /**
     * The refNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $refNumber;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ExpenseReportExpense
     * @uses ExpenseReportExpense::setLine()
     * @uses ExpenseReportExpense::setExpenseDate()
     * @uses ExpenseReportExpense::setCategory()
     * @uses ExpenseReportExpense::setQuantity()
     * @uses ExpenseReportExpense::setRate()
     * @uses ExpenseReportExpense::setForeignAmount()
     * @uses ExpenseReportExpense::setCurrency()
     * @uses ExpenseReportExpense::setExchangeRate()
     * @uses ExpenseReportExpense::setAmount()
     * @uses ExpenseReportExpense::setTaxCode()
     * @uses ExpenseReportExpense::setMemo()
     * @uses ExpenseReportExpense::setTaxRate1()
     * @uses ExpenseReportExpense::setTax1Amt()
     * @uses ExpenseReportExpense::setDepartment()
     * @uses ExpenseReportExpense::setGrossAmt()
     * @uses ExpenseReportExpense::setTaxRate2()
     * @uses ExpenseReportExpense::setClass()
     * @uses ExpenseReportExpense::setCustomer()
     * @uses ExpenseReportExpense::setLocation()
     * @uses ExpenseReportExpense::setIsBillable()
     * @uses ExpenseReportExpense::setExpMediaItem()
     * @uses ExpenseReportExpense::setIsNonReimbursable()
     * @uses ExpenseReportExpense::setCorporateCreditCard()
     * @uses ExpenseReportExpense::setReceipt()
     * @uses ExpenseReportExpense::setRefNumber()
     * @uses ExpenseReportExpense::setTaxDetailsReference()
     * @uses ExpenseReportExpense::setCustomFieldList()
     * @param int $line
     * @param string $expenseDate
     * @param \StructType\RecordRef $category
     * @param float $quantity
     * @param float $rate
     * @param float $foreignAmount
     * @param \StructType\RecordRef $currency
     * @param float $exchangeRate
     * @param float $amount
     * @param \StructType\RecordRef $taxCode
     * @param string $memo
     * @param float $taxRate1
     * @param float $tax1Amt
     * @param \StructType\RecordRef $department
     * @param float $grossAmt
     * @param float $taxRate2
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRef $location
     * @param bool $isBillable
     * @param \StructType\RecordRef $expMediaItem
     * @param bool $isNonReimbursable
     * @param bool $corporateCreditCard
     * @param bool $receipt
     * @param int $refNumber
     * @param string $taxDetailsReference
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($line = null, $expenseDate = null, \StructType\RecordRef $category = null, $quantity = null, $rate = null, $foreignAmount = null, \StructType\RecordRef $currency = null, $exchangeRate = null, $amount = null, \StructType\RecordRef $taxCode = null, $memo = null, $taxRate1 = null, $tax1Amt = null, \StructType\RecordRef $department = null, $grossAmt = null, $taxRate2 = null, \StructType\RecordRef $class = null, \StructType\RecordRef $customer = null, \StructType\RecordRef $location = null, $isBillable = null, \StructType\RecordRef $expMediaItem = null, $isNonReimbursable = null, $corporateCreditCard = null, $receipt = null, $refNumber = null, $taxDetailsReference = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setLine($line)
            ->setExpenseDate($expenseDate)
            ->setCategory($category)
            ->setQuantity($quantity)
            ->setRate($rate)
            ->setForeignAmount($foreignAmount)
            ->setCurrency($currency)
            ->setExchangeRate($exchangeRate)
            ->setAmount($amount)
            ->setTaxCode($taxCode)
            ->setMemo($memo)
            ->setTaxRate1($taxRate1)
            ->setTax1Amt($tax1Amt)
            ->setDepartment($department)
            ->setGrossAmt($grossAmt)
            ->setTaxRate2($taxRate2)
            ->setClass($class)
            ->setCustomer($customer)
            ->setLocation($location)
            ->setIsBillable($isBillable)
            ->setExpMediaItem($expMediaItem)
            ->setIsNonReimbursable($isNonReimbursable)
            ->setCorporateCreditCard($corporateCreditCard)
            ->setReceipt($receipt)
            ->setRefNumber($refNumber)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\ExpenseReportExpense
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get expenseDate value
     * @return string|null
     */
    public function getExpenseDate()
    {
        return $this->expenseDate;
    }
    /**
     * Set expenseDate value
     * @param string $expenseDate
     * @return \StructType\ExpenseReportExpense
     */
    public function setExpenseDate($expenseDate = null)
    {
        // validation for constraint: string
        if (!is_null($expenseDate) && !is_string($expenseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expenseDate, true), gettype($expenseDate)), __LINE__);
        }
        $this->expenseDate = $expenseDate;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\ExpenseReportExpense
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\ExpenseReportExpense
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\ExpenseReportExpense
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get foreignAmount value
     * @return float|null
     */
    public function getForeignAmount()
    {
        return $this->foreignAmount;
    }
    /**
     * Set foreignAmount value
     * @param float $foreignAmount
     * @return \StructType\ExpenseReportExpense
     */
    public function setForeignAmount($foreignAmount = null)
    {
        // validation for constraint: float
        if (!is_null($foreignAmount) && !(is_float($foreignAmount) || is_numeric($foreignAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foreignAmount, true), gettype($foreignAmount)), __LINE__);
        }
        $this->foreignAmount = $foreignAmount;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\ExpenseReportExpense
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\ExpenseReportExpense
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\ExpenseReportExpense
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\ExpenseReportExpense
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ExpenseReportExpense
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\ExpenseReportExpense
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\ExpenseReportExpense
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\ExpenseReportExpense
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\ExpenseReportExpense
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\ExpenseReportExpense
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\ExpenseReportExpense
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\ExpenseReportExpense
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ExpenseReportExpense
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\ExpenseReportExpense
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get expMediaItem value
     * @return \StructType\RecordRef|null
     */
    public function getExpMediaItem()
    {
        return $this->expMediaItem;
    }
    /**
     * Set expMediaItem value
     * @param \StructType\RecordRef $expMediaItem
     * @return \StructType\ExpenseReportExpense
     */
    public function setExpMediaItem(\StructType\RecordRef $expMediaItem = null)
    {
        $this->expMediaItem = $expMediaItem;
        return $this;
    }
    /**
     * Get isNonReimbursable value
     * @return bool|null
     */
    public function getIsNonReimbursable()
    {
        return $this->isNonReimbursable;
    }
    /**
     * Set isNonReimbursable value
     * @param bool $isNonReimbursable
     * @return \StructType\ExpenseReportExpense
     */
    public function setIsNonReimbursable($isNonReimbursable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNonReimbursable) && !is_bool($isNonReimbursable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNonReimbursable, true), gettype($isNonReimbursable)), __LINE__);
        }
        $this->isNonReimbursable = $isNonReimbursable;
        return $this;
    }
    /**
     * Get corporateCreditCard value
     * @return bool|null
     */
    public function getCorporateCreditCard()
    {
        return $this->corporateCreditCard;
    }
    /**
     * Set corporateCreditCard value
     * @param bool $corporateCreditCard
     * @return \StructType\ExpenseReportExpense
     */
    public function setCorporateCreditCard($corporateCreditCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($corporateCreditCard) && !is_bool($corporateCreditCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($corporateCreditCard, true), gettype($corporateCreditCard)), __LINE__);
        }
        $this->corporateCreditCard = $corporateCreditCard;
        return $this;
    }
    /**
     * Get receipt value
     * @return bool|null
     */
    public function getReceipt()
    {
        return $this->receipt;
    }
    /**
     * Set receipt value
     * @param bool $receipt
     * @return \StructType\ExpenseReportExpense
     */
    public function setReceipt($receipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($receipt) && !is_bool($receipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($receipt, true), gettype($receipt)), __LINE__);
        }
        $this->receipt = $receipt;
        return $this;
    }
    /**
     * Get refNumber value
     * @return int|null
     */
    public function getRefNumber()
    {
        return $this->refNumber;
    }
    /**
     * Set refNumber value
     * @param int $refNumber
     * @return \StructType\ExpenseReportExpense
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: int
        if (!is_null($refNumber) && !(is_int($refNumber) || ctype_digit($refNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refNumber, true), gettype($refNumber)), __LINE__);
        }
        $this->refNumber = $refNumber;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\ExpenseReportExpense
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ExpenseReportExpense
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
