<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseReport StructType
 * @subpackage Structs
 */
class ExpenseReport extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The expenseReportCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expenseReportCurrency;
    /**
     * The expenseReportExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expenseReportExchangeRate;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The acctCorpCardExp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $acctCorpCardExp;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nextApprover;
    /**
     * The advance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $advance;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The complete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $complete;
    /**
     * The supervisorApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $supervisorApproval;
    /**
     * The accountingApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $accountingApproval;
    /**
     * The useMultiCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useMultiCurrency;
    /**
     * The tax2Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Amt;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExpenseReportExpenseList
     */
    public $expenseList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ExpenseReport
     * @uses ExpenseReport::setCreatedDate()
     * @uses ExpenseReport::setLastModifiedDate()
     * @uses ExpenseReport::setStatus()
     * @uses ExpenseReport::setCustomForm()
     * @uses ExpenseReport::setAccount()
     * @uses ExpenseReport::setEntity()
     * @uses ExpenseReport::setExpenseReportCurrency()
     * @uses ExpenseReport::setExpenseReportExchangeRate()
     * @uses ExpenseReport::setSubsidiary()
     * @uses ExpenseReport::setTaxPointDate()
     * @uses ExpenseReport::setTranId()
     * @uses ExpenseReport::setAcctCorpCardExp()
     * @uses ExpenseReport::setPostingPeriod()
     * @uses ExpenseReport::setTranDate()
     * @uses ExpenseReport::setDueDate()
     * @uses ExpenseReport::setApprovalStatus()
     * @uses ExpenseReport::setTotal()
     * @uses ExpenseReport::setNextApprover()
     * @uses ExpenseReport::setAdvance()
     * @uses ExpenseReport::setTax1Amt()
     * @uses ExpenseReport::setAmount()
     * @uses ExpenseReport::setMemo()
     * @uses ExpenseReport::setComplete()
     * @uses ExpenseReport::setSupervisorApproval()
     * @uses ExpenseReport::setAccountingApproval()
     * @uses ExpenseReport::setUseMultiCurrency()
     * @uses ExpenseReport::setTax2Amt()
     * @uses ExpenseReport::setDepartment()
     * @uses ExpenseReport::setClass()
     * @uses ExpenseReport::setLocation()
     * @uses ExpenseReport::setExpenseList()
     * @uses ExpenseReport::setAccountingBookDetailList()
     * @uses ExpenseReport::setTaxDetailsList()
     * @uses ExpenseReport::setNexus()
     * @uses ExpenseReport::setSubsidiaryTaxRegNum()
     * @uses ExpenseReport::setCustomFieldList()
     * @uses ExpenseReport::setInternalId()
     * @uses ExpenseReport::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $status
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $expenseReportCurrency
     * @param float $expenseReportExchangeRate
     * @param \StructType\RecordRef $subsidiary
     * @param string $taxPointDate
     * @param string $tranId
     * @param \StructType\RecordRef $acctCorpCardExp
     * @param \StructType\RecordRef $postingPeriod
     * @param string $tranDate
     * @param string $dueDate
     * @param \StructType\RecordRef $approvalStatus
     * @param float $total
     * @param \StructType\RecordRef $nextApprover
     * @param float $advance
     * @param float $tax1Amt
     * @param float $amount
     * @param string $memo
     * @param bool $complete
     * @param bool $supervisorApproval
     * @param bool $accountingApproval
     * @param bool $useMultiCurrency
     * @param float $tax2Amt
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\ExpenseReportExpenseList $expenseList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $status = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $account = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $expenseReportCurrency = null, $expenseReportExchangeRate = null, \StructType\RecordRef $subsidiary = null, $taxPointDate = null, $tranId = null, \StructType\RecordRef $acctCorpCardExp = null, \StructType\RecordRef $postingPeriod = null, $tranDate = null, $dueDate = null, \StructType\RecordRef $approvalStatus = null, $total = null, \StructType\RecordRef $nextApprover = null, $advance = null, $tax1Amt = null, $amount = null, $memo = null, $complete = null, $supervisorApproval = null, $accountingApproval = null, $useMultiCurrency = null, $tax2Amt = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\ExpenseReportExpenseList $expenseList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setStatus($status)
            ->setCustomForm($customForm)
            ->setAccount($account)
            ->setEntity($entity)
            ->setExpenseReportCurrency($expenseReportCurrency)
            ->setExpenseReportExchangeRate($expenseReportExchangeRate)
            ->setSubsidiary($subsidiary)
            ->setTaxPointDate($taxPointDate)
            ->setTranId($tranId)
            ->setAcctCorpCardExp($acctCorpCardExp)
            ->setPostingPeriod($postingPeriod)
            ->setTranDate($tranDate)
            ->setDueDate($dueDate)
            ->setApprovalStatus($approvalStatus)
            ->setTotal($total)
            ->setNextApprover($nextApprover)
            ->setAdvance($advance)
            ->setTax1Amt($tax1Amt)
            ->setAmount($amount)
            ->setMemo($memo)
            ->setComplete($complete)
            ->setSupervisorApproval($supervisorApproval)
            ->setAccountingApproval($accountingApproval)
            ->setUseMultiCurrency($useMultiCurrency)
            ->setTax2Amt($tax2Amt)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setExpenseList($expenseList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setTaxDetailsList($taxDetailsList)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\ExpenseReport
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\ExpenseReport
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ExpenseReport
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ExpenseReport
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\ExpenseReport
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\ExpenseReport
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get expenseReportCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getExpenseReportCurrency()
    {
        return $this->expenseReportCurrency;
    }
    /**
     * Set expenseReportCurrency value
     * @param \StructType\RecordRef $expenseReportCurrency
     * @return \StructType\ExpenseReport
     */
    public function setExpenseReportCurrency(\StructType\RecordRef $expenseReportCurrency = null)
    {
        $this->expenseReportCurrency = $expenseReportCurrency;
        return $this;
    }
    /**
     * Get expenseReportExchangeRate value
     * @return float|null
     */
    public function getExpenseReportExchangeRate()
    {
        return $this->expenseReportExchangeRate;
    }
    /**
     * Set expenseReportExchangeRate value
     * @param float $expenseReportExchangeRate
     * @return \StructType\ExpenseReport
     */
    public function setExpenseReportExchangeRate($expenseReportExchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($expenseReportExchangeRate) && !(is_float($expenseReportExchangeRate) || is_numeric($expenseReportExchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expenseReportExchangeRate, true), gettype($expenseReportExchangeRate)), __LINE__);
        }
        $this->expenseReportExchangeRate = $expenseReportExchangeRate;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\ExpenseReport
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\ExpenseReport
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\ExpenseReport
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get acctCorpCardExp value
     * @return \StructType\RecordRef|null
     */
    public function getAcctCorpCardExp()
    {
        return $this->acctCorpCardExp;
    }
    /**
     * Set acctCorpCardExp value
     * @param \StructType\RecordRef $acctCorpCardExp
     * @return \StructType\ExpenseReport
     */
    public function setAcctCorpCardExp(\StructType\RecordRef $acctCorpCardExp = null)
    {
        $this->acctCorpCardExp = $acctCorpCardExp;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\ExpenseReport
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\ExpenseReport
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\ExpenseReport
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\ExpenseReport
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\ExpenseReport
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\RecordRef|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * Set nextApprover value
     * @param \StructType\RecordRef $nextApprover
     * @return \StructType\ExpenseReport
     */
    public function setNextApprover(\StructType\RecordRef $nextApprover = null)
    {
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Get advance value
     * @return float|null
     */
    public function getAdvance()
    {
        return $this->advance;
    }
    /**
     * Set advance value
     * @param float $advance
     * @return \StructType\ExpenseReport
     */
    public function setAdvance($advance = null)
    {
        // validation for constraint: float
        if (!is_null($advance) && !(is_float($advance) || is_numeric($advance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($advance, true), gettype($advance)), __LINE__);
        }
        $this->advance = $advance;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\ExpenseReport
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\ExpenseReport
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\ExpenseReport
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get complete value
     * @return bool|null
     */
    public function getComplete()
    {
        return $this->complete;
    }
    /**
     * Set complete value
     * @param bool $complete
     * @return \StructType\ExpenseReport
     */
    public function setComplete($complete = null)
    {
        // validation for constraint: boolean
        if (!is_null($complete) && !is_bool($complete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($complete, true), gettype($complete)), __LINE__);
        }
        $this->complete = $complete;
        return $this;
    }
    /**
     * Get supervisorApproval value
     * @return bool|null
     */
    public function getSupervisorApproval()
    {
        return $this->supervisorApproval;
    }
    /**
     * Set supervisorApproval value
     * @param bool $supervisorApproval
     * @return \StructType\ExpenseReport
     */
    public function setSupervisorApproval($supervisorApproval = null)
    {
        // validation for constraint: boolean
        if (!is_null($supervisorApproval) && !is_bool($supervisorApproval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supervisorApproval, true), gettype($supervisorApproval)), __LINE__);
        }
        $this->supervisorApproval = $supervisorApproval;
        return $this;
    }
    /**
     * Get accountingApproval value
     * @return bool|null
     */
    public function getAccountingApproval()
    {
        return $this->accountingApproval;
    }
    /**
     * Set accountingApproval value
     * @param bool $accountingApproval
     * @return \StructType\ExpenseReport
     */
    public function setAccountingApproval($accountingApproval = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountingApproval) && !is_bool($accountingApproval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accountingApproval, true), gettype($accountingApproval)), __LINE__);
        }
        $this->accountingApproval = $accountingApproval;
        return $this;
    }
    /**
     * Get useMultiCurrency value
     * @return bool|null
     */
    public function getUseMultiCurrency()
    {
        return $this->useMultiCurrency;
    }
    /**
     * Set useMultiCurrency value
     * @param bool $useMultiCurrency
     * @return \StructType\ExpenseReport
     */
    public function setUseMultiCurrency($useMultiCurrency = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMultiCurrency) && !is_bool($useMultiCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMultiCurrency, true), gettype($useMultiCurrency)), __LINE__);
        }
        $this->useMultiCurrency = $useMultiCurrency;
        return $this;
    }
    /**
     * Get tax2Amt value
     * @return float|null
     */
    public function getTax2Amt()
    {
        return $this->tax2Amt;
    }
    /**
     * Set tax2Amt value
     * @param float $tax2Amt
     * @return \StructType\ExpenseReport
     */
    public function setTax2Amt($tax2Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Amt) && !(is_float($tax2Amt) || is_numeric($tax2Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Amt, true), gettype($tax2Amt)), __LINE__);
        }
        $this->tax2Amt = $tax2Amt;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\ExpenseReport
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\ExpenseReport
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ExpenseReport
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\ExpenseReportExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\ExpenseReportExpenseList $expenseList
     * @return \StructType\ExpenseReport
     */
    public function setExpenseList(\StructType\ExpenseReportExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\ExpenseReport
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\ExpenseReport
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\ExpenseReport
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\ExpenseReport
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ExpenseReport
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ExpenseReport
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ExpenseReport
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
