<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseCategorySearchRowBasic StructType
 * @subpackage Structs
 */
class ExpenseCategorySearchRowBasic extends SearchRowBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $account;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $description;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The rateRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $rateRequired;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ExpenseCategorySearchRowBasic
     * @uses ExpenseCategorySearchRowBasic::setAccount()
     * @uses ExpenseCategorySearchRowBasic::setDescription()
     * @uses ExpenseCategorySearchRowBasic::setExternalId()
     * @uses ExpenseCategorySearchRowBasic::setInternalId()
     * @uses ExpenseCategorySearchRowBasic::setIsInactive()
     * @uses ExpenseCategorySearchRowBasic::setName()
     * @uses ExpenseCategorySearchRowBasic::setRateRequired()
     * @uses ExpenseCategorySearchRowBasic::setSubsidiary()
     * @uses ExpenseCategorySearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnSelectField[] $account
     * @param \StructType\SearchColumnStringField[] $description
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnBooleanField[] $rateRequired
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $account = array(), array $description = array(), array $externalId = array(), array $internalId = array(), array $isInactive = array(), array $name = array(), array $rateRequired = array(), array $subsidiary = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAccount($account)
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setIsInactive($isInactive)
            ->setName($name)
            ->setRateRequired($rateRequired)
            ->setSubsidiary($subsidiary)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get account value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicAccountItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicAccountItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicAccountItem) ? get_class($expenseCategorySearchRowBasicAccountItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicAccountItem), var_export($expenseCategorySearchRowBasicAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $account
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToAccount(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicDescriptionItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicDescriptionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicDescriptionItem) ? get_class($expenseCategorySearchRowBasicDescriptionItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicDescriptionItem), var_export($expenseCategorySearchRowBasicDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $description
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToDescription(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicExternalIdItem) ? get_class($expenseCategorySearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicExternalIdItem), var_export($expenseCategorySearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicInternalIdItem) ? get_class($expenseCategorySearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicInternalIdItem), var_export($expenseCategorySearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicIsInactiveItem) ? get_class($expenseCategorySearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicIsInactiveItem), var_export($expenseCategorySearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicNameItem) ? get_class($expenseCategorySearchRowBasicNameItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicNameItem), var_export($expenseCategorySearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get rateRequired value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getRateRequired()
    {
        return $this->rateRequired;
    }
    /**
     * This method is responsible for validating the values passed to the setRateRequired method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateRequired method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateRequiredForArrayConstraintsFromSetRateRequired(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicRateRequiredItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicRateRequiredItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicRateRequiredItem) ? get_class($expenseCategorySearchRowBasicRateRequiredItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicRateRequiredItem), var_export($expenseCategorySearchRowBasicRateRequiredItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rateRequired property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rateRequired value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $rateRequired
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setRateRequired(array $rateRequired = array())
    {
        // validation for constraint: array
        if ('' !== ($rateRequiredArrayErrorMessage = self::validateRateRequiredForArrayConstraintsFromSetRateRequired($rateRequired))) {
            throw new \InvalidArgumentException($rateRequiredArrayErrorMessage, __LINE__);
        }
        $this->rateRequired = $rateRequired;
        return $this;
    }
    /**
     * Add item to rateRequired value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToRateRequired(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The rateRequired property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rateRequired[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategorySearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$expenseCategorySearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($expenseCategorySearchRowBasicSubsidiaryItem) ? get_class($expenseCategorySearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($expenseCategorySearchRowBasicSubsidiaryItem), var_export($expenseCategorySearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\ExpenseCategorySearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
