<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseCategoryRatesList StructType
 * @subpackage Structs
 */
class ExpenseCategoryRatesList extends AbstractStructBase
{
    /**
     * The expenseCategoryRates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExpenseCategoryRates[]
     */
    public $expenseCategoryRates;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ExpenseCategoryRatesList
     * @uses ExpenseCategoryRatesList::setExpenseCategoryRates()
     * @uses ExpenseCategoryRatesList::setReplaceAll()
     * @param \StructType\ExpenseCategoryRates[] $expenseCategoryRates
     * @param bool $replaceAll
     */
    public function __construct(array $expenseCategoryRates = array(), $replaceAll = true)
    {
        $this
            ->setExpenseCategoryRates($expenseCategoryRates)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get expenseCategoryRates value
     * @return \StructType\ExpenseCategoryRates[]|null
     */
    public function getExpenseCategoryRates()
    {
        return $this->expenseCategoryRates;
    }
    /**
     * This method is responsible for validating the values passed to the setExpenseCategoryRates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpenseCategoryRates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseCategoryRatesForArrayConstraintsFromSetExpenseCategoryRates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expenseCategoryRatesListExpenseCategoryRatesItem) {
            // validation for constraint: itemType
            if (!$expenseCategoryRatesListExpenseCategoryRatesItem instanceof \StructType\ExpenseCategoryRates) {
                $invalidValues[] = is_object($expenseCategoryRatesListExpenseCategoryRatesItem) ? get_class($expenseCategoryRatesListExpenseCategoryRatesItem) : sprintf('%s(%s)', gettype($expenseCategoryRatesListExpenseCategoryRatesItem), var_export($expenseCategoryRatesListExpenseCategoryRatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expenseCategoryRates property can only contain items of type \StructType\ExpenseCategoryRates, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expenseCategoryRates value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseCategoryRates[] $expenseCategoryRates
     * @return \StructType\ExpenseCategoryRatesList
     */
    public function setExpenseCategoryRates(array $expenseCategoryRates = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseCategoryRatesArrayErrorMessage = self::validateExpenseCategoryRatesForArrayConstraintsFromSetExpenseCategoryRates($expenseCategoryRates))) {
            throw new \InvalidArgumentException($expenseCategoryRatesArrayErrorMessage, __LINE__);
        }
        $this->expenseCategoryRates = $expenseCategoryRates;
        return $this;
    }
    /**
     * Add item to expenseCategoryRates value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseCategoryRates $item
     * @return \StructType\ExpenseCategoryRatesList
     */
    public function addToExpenseCategoryRates(\StructType\ExpenseCategoryRates $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExpenseCategoryRates) {
            throw new \InvalidArgumentException(sprintf('The expenseCategoryRates property can only contain items of type \StructType\ExpenseCategoryRates, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expenseCategoryRates[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ExpenseCategoryRatesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
