<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseCategoryRates StructType
 * @subpackage Structs
 */
class ExpenseCategoryRates extends AbstractStructBase
{
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The defaultRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $defaultRate;
    /**
     * Constructor method for ExpenseCategoryRates
     * @uses ExpenseCategoryRates::setSubsidiary()
     * @uses ExpenseCategoryRates::setCurrency()
     * @uses ExpenseCategoryRates::setDefaultRate()
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $currency
     * @param float $defaultRate
     */
    public function __construct(\StructType\RecordRef $subsidiary = null, \StructType\RecordRef $currency = null, $defaultRate = null)
    {
        $this
            ->setSubsidiary($subsidiary)
            ->setCurrency($currency)
            ->setDefaultRate($defaultRate);
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\ExpenseCategoryRates
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\ExpenseCategoryRates
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get defaultRate value
     * @return float|null
     */
    public function getDefaultRate()
    {
        return $this->defaultRate;
    }
    /**
     * Set defaultRate value
     * @param float $defaultRate
     * @return \StructType\ExpenseCategoryRates
     */
    public function setDefaultRate($defaultRate = null)
    {
        // validation for constraint: float
        if (!is_null($defaultRate) && !(is_float($defaultRate) || is_numeric($defaultRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultRate, true), gettype($defaultRate)), __LINE__);
        }
        $this->defaultRate = $defaultRate;
        return $this;
    }
}
