<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseCategory StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:ExpenseCategory
 * @subpackage Structs
 */
class ExpenseCategory extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The expenseAcct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expenseAcct;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The rateRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $rateRequired;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The defaultRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $defaultRate;
    /**
     * The ratesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExpenseCategoryRatesList
     */
    public $ratesList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ExpenseCategory
     * @uses ExpenseCategory::setCustomForm()
     * @uses ExpenseCategory::setName()
     * @uses ExpenseCategory::setDescription()
     * @uses ExpenseCategory::setExpenseAcct()
     * @uses ExpenseCategory::setIsInactive()
     * @uses ExpenseCategory::setRateRequired()
     * @uses ExpenseCategory::setSubsidiaryList()
     * @uses ExpenseCategory::setDefaultRate()
     * @uses ExpenseCategory::setRatesList()
     * @uses ExpenseCategory::setTranslationsList()
     * @uses ExpenseCategory::setCustomFieldList()
     * @uses ExpenseCategory::setInternalId()
     * @uses ExpenseCategory::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $name
     * @param string $description
     * @param \StructType\RecordRef $expenseAcct
     * @param bool $isInactive
     * @param bool $rateRequired
     * @param \StructType\RecordRefList $subsidiaryList
     * @param float $defaultRate
     * @param \StructType\ExpenseCategoryRatesList $ratesList
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $name = null, $description = null, \StructType\RecordRef $expenseAcct = null, $isInactive = null, $rateRequired = null, \StructType\RecordRefList $subsidiaryList = null, $defaultRate = null, \StructType\ExpenseCategoryRatesList $ratesList = null, \StructType\TranslationList $translationsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setName($name)
            ->setDescription($description)
            ->setExpenseAcct($expenseAcct)
            ->setIsInactive($isInactive)
            ->setRateRequired($rateRequired)
            ->setSubsidiaryList($subsidiaryList)
            ->setDefaultRate($defaultRate)
            ->setRatesList($ratesList)
            ->setTranslationsList($translationsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ExpenseCategory
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ExpenseCategory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExpenseCategory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get expenseAcct value
     * @return \StructType\RecordRef|null
     */
    public function getExpenseAcct()
    {
        return $this->expenseAcct;
    }
    /**
     * Set expenseAcct value
     * @param \StructType\RecordRef $expenseAcct
     * @return \StructType\ExpenseCategory
     */
    public function setExpenseAcct(\StructType\RecordRef $expenseAcct = null)
    {
        $this->expenseAcct = $expenseAcct;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\ExpenseCategory
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get rateRequired value
     * @return bool|null
     */
    public function getRateRequired()
    {
        return $this->rateRequired;
    }
    /**
     * Set rateRequired value
     * @param bool $rateRequired
     * @return \StructType\ExpenseCategory
     */
    public function setRateRequired($rateRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateRequired) && !is_bool($rateRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateRequired, true), gettype($rateRequired)), __LINE__);
        }
        $this->rateRequired = $rateRequired;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\ExpenseCategory
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get defaultRate value
     * @return float|null
     */
    public function getDefaultRate()
    {
        return $this->defaultRate;
    }
    /**
     * Set defaultRate value
     * @param float $defaultRate
     * @return \StructType\ExpenseCategory
     */
    public function setDefaultRate($defaultRate = null)
    {
        // validation for constraint: float
        if (!is_null($defaultRate) && !(is_float($defaultRate) || is_numeric($defaultRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultRate, true), gettype($defaultRate)), __LINE__);
        }
        $this->defaultRate = $defaultRate;
        return $this;
    }
    /**
     * Get ratesList value
     * @return \StructType\ExpenseCategoryRatesList|null
     */
    public function getRatesList()
    {
        return $this->ratesList;
    }
    /**
     * Set ratesList value
     * @param \StructType\ExpenseCategoryRatesList $ratesList
     * @return \StructType\ExpenseCategory
     */
    public function setRatesList(\StructType\ExpenseCategoryRatesList $ratesList = null)
    {
        $this->ratesList = $ratesList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\ExpenseCategory
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ExpenseCategory
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ExpenseCategory
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ExpenseCategory
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
