<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExclusionDateList StructType
 * @subpackage Structs
 */
class ExclusionDateList extends AbstractStructBase
{
    /**
     * The exclusionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $exclusionDate;
    /**
     * Constructor method for ExclusionDateList
     * @uses ExclusionDateList::setExclusionDate()
     * @param string[] $exclusionDate
     */
    public function __construct(array $exclusionDate = array())
    {
        $this
            ->setExclusionDate($exclusionDate);
    }
    /**
     * Get exclusionDate value
     * @return string[]|null
     */
    public function getExclusionDate()
    {
        return $this->exclusionDate;
    }
    /**
     * This method is responsible for validating the values passed to the setExclusionDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExclusionDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExclusionDateForArrayConstraintsFromSetExclusionDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $exclusionDateListExclusionDateItem) {
            // validation for constraint: itemType
            if (!is_string($exclusionDateListExclusionDateItem)) {
                $invalidValues[] = is_object($exclusionDateListExclusionDateItem) ? get_class($exclusionDateListExclusionDateItem) : sprintf('%s(%s)', gettype($exclusionDateListExclusionDateItem), var_export($exclusionDateListExclusionDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The exclusionDate property can only contain items of type dateTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set exclusionDate value
     * @throws \InvalidArgumentException
     * @param string[] $exclusionDate
     * @return \StructType\ExclusionDateList
     */
    public function setExclusionDate(array $exclusionDate = array())
    {
        // validation for constraint: array
        if ('' !== ($exclusionDateArrayErrorMessage = self::validateExclusionDateForArrayConstraintsFromSetExclusionDate($exclusionDate))) {
            throw new \InvalidArgumentException($exclusionDateArrayErrorMessage, __LINE__);
        }
        $this->exclusionDate = $exclusionDate;
        return $this;
    }
    /**
     * Add item to exclusionDate value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ExclusionDateList
     */
    public function addToExclusionDate($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The exclusionDate property can only contain items of type dateTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->exclusionDate[] = $item;
        return $this;
    }
}
