<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimateSalesTeamList StructType
 * @subpackage Structs
 */
class EstimateSalesTeamList extends AbstractStructBase
{
    /**
     * The salesTeam
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EstimateSalesTeam[]
     */
    public $salesTeam;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EstimateSalesTeamList
     * @uses EstimateSalesTeamList::setSalesTeam()
     * @uses EstimateSalesTeamList::setReplaceAll()
     * @param \StructType\EstimateSalesTeam[] $salesTeam
     * @param bool $replaceAll
     */
    public function __construct(array $salesTeam = array(), $replaceAll = true)
    {
        $this
            ->setSalesTeam($salesTeam)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get salesTeam value
     * @return \StructType\EstimateSalesTeam[]|null
     */
    public function getSalesTeam()
    {
        return $this->salesTeam;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesTeam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesTeam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesTeamForArrayConstraintsFromSetSalesTeam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $estimateSalesTeamListSalesTeamItem) {
            // validation for constraint: itemType
            if (!$estimateSalesTeamListSalesTeamItem instanceof \StructType\EstimateSalesTeam) {
                $invalidValues[] = is_object($estimateSalesTeamListSalesTeamItem) ? get_class($estimateSalesTeamListSalesTeamItem) : sprintf('%s(%s)', gettype($estimateSalesTeamListSalesTeamItem), var_export($estimateSalesTeamListSalesTeamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The salesTeam property can only contain items of type \StructType\EstimateSalesTeam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimateSalesTeam[] $salesTeam
     * @return \StructType\EstimateSalesTeamList
     */
    public function setSalesTeam(array $salesTeam = array())
    {
        // validation for constraint: array
        if ('' !== ($salesTeamArrayErrorMessage = self::validateSalesTeamForArrayConstraintsFromSetSalesTeam($salesTeam))) {
            throw new \InvalidArgumentException($salesTeamArrayErrorMessage, __LINE__);
        }
        $this->salesTeam = $salesTeam;
        return $this;
    }
    /**
     * Add item to salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimateSalesTeam $item
     * @return \StructType\EstimateSalesTeamList
     */
    public function addToSalesTeam(\StructType\EstimateSalesTeam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EstimateSalesTeam) {
            throw new \InvalidArgumentException(sprintf('The salesTeam property can only contain items of type \StructType\EstimateSalesTeam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->salesTeam[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EstimateSalesTeamList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
