<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimateItem StructType
 * @subpackage Structs
 */
class EstimateItem extends AbstractStructBase
{
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The expandItemGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $expandItemGroup;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The revRecTermInMonths
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $revRecTermInMonths;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The altSalesAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altSalesAmt;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The fromJob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fromJob;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The isEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isEstimate;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscription;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The excludeFromRateRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromRateRequest;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The shipGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shipGroup;
    /**
     * The itemIsFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemIsFulfilled;
    /**
     * The shipAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddress;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The expectedShipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedShipDate;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $chargeType;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for EstimateItem
     * @uses EstimateItem::setJob()
     * @uses EstimateItem::setItem()
     * @uses EstimateItem::setLine()
     * @uses EstimateItem::setExpandItemGroup()
     * @uses EstimateItem::setQuantityAvailable()
     * @uses EstimateItem::setQuantityOnHand()
     * @uses EstimateItem::setQuantity()
     * @uses EstimateItem::setUnits()
     * @uses EstimateItem::setDescription()
     * @uses EstimateItem::setSerialNumbers()
     * @uses EstimateItem::setPrice()
     * @uses EstimateItem::setRate()
     * @uses EstimateItem::setAmount()
     * @uses EstimateItem::setOptions()
     * @uses EstimateItem::setRevRecTermInMonths()
     * @uses EstimateItem::setDepartment()
     * @uses EstimateItem::setClass()
     * @uses EstimateItem::setLocation()
     * @uses EstimateItem::setIsTaxable()
     * @uses EstimateItem::setAltSalesAmt()
     * @uses EstimateItem::setTaxAmount()
     * @uses EstimateItem::setFromJob()
     * @uses EstimateItem::setGrossAmt()
     * @uses EstimateItem::setIsEstimate()
     * @uses EstimateItem::setSubscription()
     * @uses EstimateItem::setTax1Amt()
     * @uses EstimateItem::setTaxCode()
     * @uses EstimateItem::setCostEstimateType()
     * @uses EstimateItem::setCostEstimate()
     * @uses EstimateItem::setExcludeFromRateRequest()
     * @uses EstimateItem::setTaxDetailsReference()
     * @uses EstimateItem::setTaxRate1()
     * @uses EstimateItem::setTaxRate2()
     * @uses EstimateItem::setShipGroup()
     * @uses EstimateItem::setItemIsFulfilled()
     * @uses EstimateItem::setShipAddress()
     * @uses EstimateItem::setShipMethod()
     * @uses EstimateItem::setExpectedShipDate()
     * @uses EstimateItem::setChargeType()
     * @uses EstimateItem::setCustomFieldList()
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param bool $expandItemGroup
     * @param float $quantityAvailable
     * @param float $quantityOnHand
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param string $description
     * @param string $serialNumbers
     * @param \StructType\RecordRef $price
     * @param string $rate
     * @param float $amount
     * @param \StructType\CustomFieldList $options
     * @param int $revRecTermInMonths
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param bool $isTaxable
     * @param float $altSalesAmt
     * @param float $taxAmount
     * @param bool $fromJob
     * @param float $grossAmt
     * @param bool $isEstimate
     * @param \StructType\RecordRef $subscription
     * @param float $tax1Amt
     * @param \StructType\RecordRef $taxCode
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param bool $excludeFromRateRequest
     * @param string $taxDetailsReference
     * @param float $taxRate1
     * @param float $taxRate2
     * @param int $shipGroup
     * @param bool $itemIsFulfilled
     * @param \StructType\RecordRef $shipAddress
     * @param \StructType\RecordRef $shipMethod
     * @param string $expectedShipDate
     * @param \StructType\RecordRef $chargeType
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $job = null, \StructType\RecordRef $item = null, $line = null, $expandItemGroup = null, $quantityAvailable = null, $quantityOnHand = null, $quantity = null, \StructType\RecordRef $units = null, $description = null, $serialNumbers = null, \StructType\RecordRef $price = null, $rate = null, $amount = null, \StructType\CustomFieldList $options = null, $revRecTermInMonths = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $isTaxable = null, $altSalesAmt = null, $taxAmount = null, $fromJob = null, $grossAmt = null, $isEstimate = null, \StructType\RecordRef $subscription = null, $tax1Amt = null, \StructType\RecordRef $taxCode = null, $costEstimateType = null, $costEstimate = null, $excludeFromRateRequest = null, $taxDetailsReference = null, $taxRate1 = null, $taxRate2 = null, $shipGroup = null, $itemIsFulfilled = null, \StructType\RecordRef $shipAddress = null, \StructType\RecordRef $shipMethod = null, $expectedShipDate = null, \StructType\RecordRef $chargeType = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setJob($job)
            ->setItem($item)
            ->setLine($line)
            ->setExpandItemGroup($expandItemGroup)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setDescription($description)
            ->setSerialNumbers($serialNumbers)
            ->setPrice($price)
            ->setRate($rate)
            ->setAmount($amount)
            ->setOptions($options)
            ->setRevRecTermInMonths($revRecTermInMonths)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setIsTaxable($isTaxable)
            ->setAltSalesAmt($altSalesAmt)
            ->setTaxAmount($taxAmount)
            ->setFromJob($fromJob)
            ->setGrossAmt($grossAmt)
            ->setIsEstimate($isEstimate)
            ->setSubscription($subscription)
            ->setTax1Amt($tax1Amt)
            ->setTaxCode($taxCode)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setExcludeFromRateRequest($excludeFromRateRequest)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setShipGroup($shipGroup)
            ->setItemIsFulfilled($itemIsFulfilled)
            ->setShipAddress($shipAddress)
            ->setShipMethod($shipMethod)
            ->setExpectedShipDate($expectedShipDate)
            ->setChargeType($chargeType)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\EstimateItem
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\EstimateItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\EstimateItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get expandItemGroup value
     * @return bool|null
     */
    public function getExpandItemGroup()
    {
        return $this->expandItemGroup;
    }
    /**
     * Set expandItemGroup value
     * @param bool $expandItemGroup
     * @return \StructType\EstimateItem
     */
    public function setExpandItemGroup($expandItemGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($expandItemGroup) && !is_bool($expandItemGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expandItemGroup, true), gettype($expandItemGroup)), __LINE__);
        }
        $this->expandItemGroup = $expandItemGroup;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\EstimateItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\EstimateItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\EstimateItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\EstimateItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\EstimateItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\EstimateItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\EstimateItem
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\EstimateItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\EstimateItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\EstimateItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get revRecTermInMonths value
     * @return int|null
     */
    public function getRevRecTermInMonths()
    {
        return $this->revRecTermInMonths;
    }
    /**
     * Set revRecTermInMonths value
     * @param int $revRecTermInMonths
     * @return \StructType\EstimateItem
     */
    public function setRevRecTermInMonths($revRecTermInMonths = null)
    {
        // validation for constraint: int
        if (!is_null($revRecTermInMonths) && !(is_int($revRecTermInMonths) || ctype_digit($revRecTermInMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revRecTermInMonths, true), gettype($revRecTermInMonths)), __LINE__);
        }
        $this->revRecTermInMonths = $revRecTermInMonths;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\EstimateItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\EstimateItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\EstimateItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\EstimateItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get altSalesAmt value
     * @return float|null
     */
    public function getAltSalesAmt()
    {
        return $this->altSalesAmt;
    }
    /**
     * Set altSalesAmt value
     * @param float $altSalesAmt
     * @return \StructType\EstimateItem
     */
    public function setAltSalesAmt($altSalesAmt = null)
    {
        // validation for constraint: float
        if (!is_null($altSalesAmt) && !(is_float($altSalesAmt) || is_numeric($altSalesAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altSalesAmt, true), gettype($altSalesAmt)), __LINE__);
        }
        $this->altSalesAmt = $altSalesAmt;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\EstimateItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get fromJob value
     * @return bool|null
     */
    public function getFromJob()
    {
        return $this->fromJob;
    }
    /**
     * Set fromJob value
     * @param bool $fromJob
     * @return \StructType\EstimateItem
     */
    public function setFromJob($fromJob = null)
    {
        // validation for constraint: boolean
        if (!is_null($fromJob) && !is_bool($fromJob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fromJob, true), gettype($fromJob)), __LINE__);
        }
        $this->fromJob = $fromJob;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\EstimateItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get isEstimate value
     * @return bool|null
     */
    public function getIsEstimate()
    {
        return $this->isEstimate;
    }
    /**
     * Set isEstimate value
     * @param bool $isEstimate
     * @return \StructType\EstimateItem
     */
    public function setIsEstimate($isEstimate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEstimate) && !is_bool($isEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEstimate, true), gettype($isEstimate)), __LINE__);
        }
        $this->isEstimate = $isEstimate;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\RecordRef|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\RecordRef $subscription
     * @return \StructType\EstimateItem
     */
    public function setSubscription(\StructType\RecordRef $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\EstimateItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\EstimateItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\EstimateItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\EstimateItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get excludeFromRateRequest value
     * @return bool|null
     */
    public function getExcludeFromRateRequest()
    {
        return $this->excludeFromRateRequest;
    }
    /**
     * Set excludeFromRateRequest value
     * @param bool $excludeFromRateRequest
     * @return \StructType\EstimateItem
     */
    public function setExcludeFromRateRequest($excludeFromRateRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromRateRequest) && !is_bool($excludeFromRateRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromRateRequest, true), gettype($excludeFromRateRequest)), __LINE__);
        }
        $this->excludeFromRateRequest = $excludeFromRateRequest;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\EstimateItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\EstimateItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\EstimateItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get shipGroup value
     * @return int|null
     */
    public function getShipGroup()
    {
        return $this->shipGroup;
    }
    /**
     * Set shipGroup value
     * @param int $shipGroup
     * @return \StructType\EstimateItem
     */
    public function setShipGroup($shipGroup = null)
    {
        // validation for constraint: int
        if (!is_null($shipGroup) && !(is_int($shipGroup) || ctype_digit($shipGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipGroup, true), gettype($shipGroup)), __LINE__);
        }
        $this->shipGroup = $shipGroup;
        return $this;
    }
    /**
     * Get itemIsFulfilled value
     * @return bool|null
     */
    public function getItemIsFulfilled()
    {
        return $this->itemIsFulfilled;
    }
    /**
     * Set itemIsFulfilled value
     * @param bool $itemIsFulfilled
     * @return \StructType\EstimateItem
     */
    public function setItemIsFulfilled($itemIsFulfilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemIsFulfilled) && !is_bool($itemIsFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemIsFulfilled, true), gettype($itemIsFulfilled)), __LINE__);
        }
        $this->itemIsFulfilled = $itemIsFulfilled;
        return $this;
    }
    /**
     * Get shipAddress value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddress()
    {
        return $this->shipAddress;
    }
    /**
     * Set shipAddress value
     * @param \StructType\RecordRef $shipAddress
     * @return \StructType\EstimateItem
     */
    public function setShipAddress(\StructType\RecordRef $shipAddress = null)
    {
        $this->shipAddress = $shipAddress;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\EstimateItem
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get expectedShipDate value
     * @return string|null
     */
    public function getExpectedShipDate()
    {
        return $this->expectedShipDate;
    }
    /**
     * Set expectedShipDate value
     * @param string $expectedShipDate
     * @return \StructType\EstimateItem
     */
    public function setExpectedShipDate($expectedShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedShipDate) && !is_string($expectedShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedShipDate, true), gettype($expectedShipDate)), __LINE__);
        }
        $this->expectedShipDate = $expectedShipDate;
        return $this;
    }
    /**
     * Get chargeType value
     * @return \StructType\RecordRef|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param \StructType\RecordRef $chargeType
     * @return \StructType\EstimateItem
     */
    public function setChargeType(\StructType\RecordRef $chargeType = null)
    {
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\EstimateItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
