<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityTaxRegistrationSearchRowBasic StructType
 * @subpackage Structs
 */
class EntityTaxRegistrationSearchRowBasic extends SearchRowBasic
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $address;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $id;
    /**
     * The nexusCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $nexusCountry;
    /**
     * The taxRegistrationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $taxRegistrationNumber;
    /**
     * Constructor method for EntityTaxRegistrationSearchRowBasic
     * @uses EntityTaxRegistrationSearchRowBasic::setAddress()
     * @uses EntityTaxRegistrationSearchRowBasic::setId()
     * @uses EntityTaxRegistrationSearchRowBasic::setNexusCountry()
     * @uses EntityTaxRegistrationSearchRowBasic::setTaxRegistrationNumber()
     * @param \StructType\SearchColumnSelectField[] $address
     * @param \StructType\SearchColumnLongField[] $id
     * @param \StructType\SearchColumnEnumSelectField[] $nexusCountry
     * @param \StructType\SearchColumnStringField[] $taxRegistrationNumber
     */
    public function __construct(array $address = array(), array $id = array(), array $nexusCountry = array(), array $taxRegistrationNumber = array())
    {
        $this
            ->setAddress($address)
            ->setId($id)
            ->setNexusCountry($nexusCountry)
            ->setTaxRegistrationNumber($taxRegistrationNumber);
    }
    /**
     * Get address value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityTaxRegistrationSearchRowBasicAddressItem) {
            // validation for constraint: itemType
            if (!$entityTaxRegistrationSearchRowBasicAddressItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($entityTaxRegistrationSearchRowBasicAddressItem) ? get_class($entityTaxRegistrationSearchRowBasicAddressItem) : sprintf('%s(%s)', gettype($entityTaxRegistrationSearchRowBasicAddressItem), var_export($entityTaxRegistrationSearchRowBasicAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $address
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function addToAddress(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityTaxRegistrationSearchRowBasicIdItem) {
            // validation for constraint: itemType
            if (!$entityTaxRegistrationSearchRowBasicIdItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($entityTaxRegistrationSearchRowBasicIdItem) ? get_class($entityTaxRegistrationSearchRowBasicIdItem) : sprintf('%s(%s)', gettype($entityTaxRegistrationSearchRowBasicIdItem), var_export($entityTaxRegistrationSearchRowBasicIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $id
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function setId(array $id = array())
    {
        // validation for constraint: array
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function addToId(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Get nexusCountry value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getNexusCountry()
    {
        return $this->nexusCountry;
    }
    /**
     * This method is responsible for validating the values passed to the setNexusCountry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNexusCountry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNexusCountryForArrayConstraintsFromSetNexusCountry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityTaxRegistrationSearchRowBasicNexusCountryItem) {
            // validation for constraint: itemType
            if (!$entityTaxRegistrationSearchRowBasicNexusCountryItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($entityTaxRegistrationSearchRowBasicNexusCountryItem) ? get_class($entityTaxRegistrationSearchRowBasicNexusCountryItem) : sprintf('%s(%s)', gettype($entityTaxRegistrationSearchRowBasicNexusCountryItem), var_export($entityTaxRegistrationSearchRowBasicNexusCountryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nexusCountry property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nexusCountry value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $nexusCountry
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function setNexusCountry(array $nexusCountry = array())
    {
        // validation for constraint: array
        if ('' !== ($nexusCountryArrayErrorMessage = self::validateNexusCountryForArrayConstraintsFromSetNexusCountry($nexusCountry))) {
            throw new \InvalidArgumentException($nexusCountryArrayErrorMessage, __LINE__);
        }
        $this->nexusCountry = $nexusCountry;
        return $this;
    }
    /**
     * Add item to nexusCountry value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function addToNexusCountry(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The nexusCountry property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nexusCountry[] = $item;
        return $this;
    }
    /**
     * Get taxRegistrationNumber value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->taxRegistrationNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxRegistrationNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxRegistrationNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxRegistrationNumberForArrayConstraintsFromSetTaxRegistrationNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityTaxRegistrationSearchRowBasicTaxRegistrationNumberItem) {
            // validation for constraint: itemType
            if (!$entityTaxRegistrationSearchRowBasicTaxRegistrationNumberItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($entityTaxRegistrationSearchRowBasicTaxRegistrationNumberItem) ? get_class($entityTaxRegistrationSearchRowBasicTaxRegistrationNumberItem) : sprintf('%s(%s)', gettype($entityTaxRegistrationSearchRowBasicTaxRegistrationNumberItem), var_export($entityTaxRegistrationSearchRowBasicTaxRegistrationNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxRegistrationNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxRegistrationNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $taxRegistrationNumber
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function setTaxRegistrationNumber(array $taxRegistrationNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($taxRegistrationNumberArrayErrorMessage = self::validateTaxRegistrationNumberForArrayConstraintsFromSetTaxRegistrationNumber($taxRegistrationNumber))) {
            throw new \InvalidArgumentException($taxRegistrationNumberArrayErrorMessage, __LINE__);
        }
        $this->taxRegistrationNumber = $taxRegistrationNumber;
        return $this;
    }
    /**
     * Add item to taxRegistrationNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\EntityTaxRegistrationSearchRowBasic
     */
    public function addToTaxRegistrationNumber(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The taxRegistrationNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxRegistrationNumber[] = $item;
        return $this;
    }
}
