<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeSubscriptionsList StructType
 * @subpackage Structs
 */
class EmployeeSubscriptionsList extends AbstractStructBase
{
    /**
     * The subscriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeSubscriptions[]
     */
    public $subscriptions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EmployeeSubscriptionsList
     * @uses EmployeeSubscriptionsList::setSubscriptions()
     * @uses EmployeeSubscriptionsList::setReplaceAll()
     * @param \StructType\EmployeeSubscriptions[] $subscriptions
     * @param bool $replaceAll
     */
    public function __construct(array $subscriptions = array(), $replaceAll = true)
    {
        $this
            ->setSubscriptions($subscriptions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get subscriptions value
     * @return \StructType\EmployeeSubscriptions[]|null
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionsForArrayConstraintsFromSetSubscriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeeSubscriptionsListSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$employeeSubscriptionsListSubscriptionsItem instanceof \StructType\EmployeeSubscriptions) {
                $invalidValues[] = is_object($employeeSubscriptionsListSubscriptionsItem) ? get_class($employeeSubscriptionsListSubscriptionsItem) : sprintf('%s(%s)', gettype($employeeSubscriptionsListSubscriptionsItem), var_export($employeeSubscriptionsListSubscriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subscriptions property can only contain items of type \StructType\EmployeeSubscriptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeSubscriptions[] $subscriptions
     * @return \StructType\EmployeeSubscriptionsList
     */
    public function setSubscriptions(array $subscriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionsArrayErrorMessage = self::validateSubscriptionsForArrayConstraintsFromSetSubscriptions($subscriptions))) {
            throw new \InvalidArgumentException($subscriptionsArrayErrorMessage, __LINE__);
        }
        $this->subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Add item to subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeSubscriptions $item
     * @return \StructType\EmployeeSubscriptionsList
     */
    public function addToSubscriptions(\StructType\EmployeeSubscriptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeSubscriptions) {
            throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of type \StructType\EmployeeSubscriptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subscriptions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EmployeeSubscriptionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
