<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeRolesList StructType
 * @subpackage Structs
 */
class EmployeeRolesList extends AbstractStructBase
{
    /**
     * The roles
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeRoles[]
     */
    public $roles;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EmployeeRolesList
     * @uses EmployeeRolesList::setRoles()
     * @uses EmployeeRolesList::setReplaceAll()
     * @param \StructType\EmployeeRoles[] $roles
     * @param bool $replaceAll
     */
    public function __construct(array $roles = array(), $replaceAll = true)
    {
        $this
            ->setRoles($roles)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get roles value
     * @return \StructType\EmployeeRoles[]|null
     */
    public function getRoles()
    {
        return $this->roles;
    }
    /**
     * This method is responsible for validating the values passed to the setRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRolesForArrayConstraintsFromSetRoles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeeRolesListRolesItem) {
            // validation for constraint: itemType
            if (!$employeeRolesListRolesItem instanceof \StructType\EmployeeRoles) {
                $invalidValues[] = is_object($employeeRolesListRolesItem) ? get_class($employeeRolesListRolesItem) : sprintf('%s(%s)', gettype($employeeRolesListRolesItem), var_export($employeeRolesListRolesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The roles property can only contain items of type \StructType\EmployeeRoles, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set roles value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeRoles[] $roles
     * @return \StructType\EmployeeRolesList
     */
    public function setRoles(array $roles = array())
    {
        // validation for constraint: array
        if ('' !== ($rolesArrayErrorMessage = self::validateRolesForArrayConstraintsFromSetRoles($roles))) {
            throw new \InvalidArgumentException($rolesArrayErrorMessage, __LINE__);
        }
        $this->roles = $roles;
        return $this;
    }
    /**
     * Add item to roles value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeRoles $item
     * @return \StructType\EmployeeRolesList
     */
    public function addToRoles(\StructType\EmployeeRoles $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeRoles) {
            throw new \InvalidArgumentException(sprintf('The roles property can only contain items of type \StructType\EmployeeRoles, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->roles[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EmployeeRolesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
