<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeEarningList StructType
 * @subpackage Structs
 */
class EmployeeEarningList extends AbstractStructBase
{
    /**
     * The employeeEarning
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeEarning[]
     */
    public $employeeEarning;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EmployeeEarningList
     * @uses EmployeeEarningList::setEmployeeEarning()
     * @uses EmployeeEarningList::setReplaceAll()
     * @param \StructType\EmployeeEarning[] $employeeEarning
     * @param bool $replaceAll
     */
    public function __construct(array $employeeEarning = array(), $replaceAll = true)
    {
        $this
            ->setEmployeeEarning($employeeEarning)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get employeeEarning value
     * @return \StructType\EmployeeEarning[]|null
     */
    public function getEmployeeEarning()
    {
        return $this->employeeEarning;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeEarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeEarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeEarningForArrayConstraintsFromSetEmployeeEarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeeEarningListEmployeeEarningItem) {
            // validation for constraint: itemType
            if (!$employeeEarningListEmployeeEarningItem instanceof \StructType\EmployeeEarning) {
                $invalidValues[] = is_object($employeeEarningListEmployeeEarningItem) ? get_class($employeeEarningListEmployeeEarningItem) : sprintf('%s(%s)', gettype($employeeEarningListEmployeeEarningItem), var_export($employeeEarningListEmployeeEarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employeeEarning property can only contain items of type \StructType\EmployeeEarning, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employeeEarning value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeEarning[] $employeeEarning
     * @return \StructType\EmployeeEarningList
     */
    public function setEmployeeEarning(array $employeeEarning = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeEarningArrayErrorMessage = self::validateEmployeeEarningForArrayConstraintsFromSetEmployeeEarning($employeeEarning))) {
            throw new \InvalidArgumentException($employeeEarningArrayErrorMessage, __LINE__);
        }
        $this->employeeEarning = $employeeEarning;
        return $this;
    }
    /**
     * Add item to employeeEarning value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeEarning $item
     * @return \StructType\EmployeeEarningList
     */
    public function addToEmployeeEarning(\StructType\EmployeeEarning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeEarning) {
            throw new \InvalidArgumentException(sprintf('The employeeEarning property can only contain items of type \StructType\EmployeeEarning, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employeeEarning[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EmployeeEarningList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
