<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeDirectDeposit StructType
 * @subpackage Structs
 */
class EmployeeDirectDeposit extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The netAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $netAccount;
    /**
     * The savingsAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $savingsAccount;
    /**
     * The accountPrenoted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $accountPrenoted;
    /**
     * The accountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountStatus;
    /**
     * The bankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankName;
    /**
     * The bankId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankId;
    /**
     * The bankNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankNumber;
    /**
     * The bankRoutingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankRoutingNumber;
    /**
     * The bankAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inactive;
    /**
     * Constructor method for EmployeeDirectDeposit
     * @uses EmployeeDirectDeposit::setId()
     * @uses EmployeeDirectDeposit::setNetAccount()
     * @uses EmployeeDirectDeposit::setSavingsAccount()
     * @uses EmployeeDirectDeposit::setAccountPrenoted()
     * @uses EmployeeDirectDeposit::setAccountStatus()
     * @uses EmployeeDirectDeposit::setBankName()
     * @uses EmployeeDirectDeposit::setBankId()
     * @uses EmployeeDirectDeposit::setBankNumber()
     * @uses EmployeeDirectDeposit::setBankRoutingNumber()
     * @uses EmployeeDirectDeposit::setBankAccountNumber()
     * @uses EmployeeDirectDeposit::setAmount()
     * @uses EmployeeDirectDeposit::setInactive()
     * @param int $id
     * @param bool $netAccount
     * @param bool $savingsAccount
     * @param bool $accountPrenoted
     * @param string $accountStatus
     * @param string $bankName
     * @param string $bankId
     * @param string $bankNumber
     * @param string $bankRoutingNumber
     * @param string $bankAccountNumber
     * @param float $amount
     * @param bool $inactive
     */
    public function __construct($id = null, $netAccount = null, $savingsAccount = null, $accountPrenoted = null, $accountStatus = null, $bankName = null, $bankId = null, $bankNumber = null, $bankRoutingNumber = null, $bankAccountNumber = null, $amount = null, $inactive = null)
    {
        $this
            ->setId($id)
            ->setNetAccount($netAccount)
            ->setSavingsAccount($savingsAccount)
            ->setAccountPrenoted($accountPrenoted)
            ->setAccountStatus($accountStatus)
            ->setBankName($bankName)
            ->setBankId($bankId)
            ->setBankNumber($bankNumber)
            ->setBankRoutingNumber($bankRoutingNumber)
            ->setBankAccountNumber($bankAccountNumber)
            ->setAmount($amount)
            ->setInactive($inactive);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get netAccount value
     * @return bool|null
     */
    public function getNetAccount()
    {
        return $this->netAccount;
    }
    /**
     * Set netAccount value
     * @param bool $netAccount
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setNetAccount($netAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($netAccount) && !is_bool($netAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($netAccount, true), gettype($netAccount)), __LINE__);
        }
        $this->netAccount = $netAccount;
        return $this;
    }
    /**
     * Get savingsAccount value
     * @return bool|null
     */
    public function getSavingsAccount()
    {
        return $this->savingsAccount;
    }
    /**
     * Set savingsAccount value
     * @param bool $savingsAccount
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setSavingsAccount($savingsAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($savingsAccount) && !is_bool($savingsAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($savingsAccount, true), gettype($savingsAccount)), __LINE__);
        }
        $this->savingsAccount = $savingsAccount;
        return $this;
    }
    /**
     * Get accountPrenoted value
     * @return bool|null
     */
    public function getAccountPrenoted()
    {
        return $this->accountPrenoted;
    }
    /**
     * Set accountPrenoted value
     * @param bool $accountPrenoted
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setAccountPrenoted($accountPrenoted = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountPrenoted) && !is_bool($accountPrenoted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accountPrenoted, true), gettype($accountPrenoted)), __LINE__);
        }
        $this->accountPrenoted = $accountPrenoted;
        return $this;
    }
    /**
     * Get accountStatus value
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->accountStatus;
    }
    /**
     * Set accountStatus value
     * @uses \EnumType\EmployeeDirectDepositAccountStatus::valueIsValid()
     * @uses \EnumType\EmployeeDirectDepositAccountStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountStatus
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setAccountStatus($accountStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeDirectDepositAccountStatus::valueIsValid($accountStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeDirectDepositAccountStatus', is_array($accountStatus) ? implode(', ', $accountStatus) : var_export($accountStatus, true), implode(', ', \EnumType\EmployeeDirectDepositAccountStatus::getValidValues())), __LINE__);
        }
        $this->accountStatus = $accountStatus;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bankId value
     * @return string|null
     */
    public function getBankId()
    {
        return $this->bankId;
    }
    /**
     * Set bankId value
     * @param string $bankId
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: string
        if (!is_null($bankId) && !is_string($bankId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->bankId = $bankId;
        return $this;
    }
    /**
     * Get bankNumber value
     * @return string|null
     */
    public function getBankNumber()
    {
        return $this->bankNumber;
    }
    /**
     * Set bankNumber value
     * @param string $bankNumber
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setBankNumber($bankNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankNumber) && !is_string($bankNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankNumber, true), gettype($bankNumber)), __LINE__);
        }
        $this->bankNumber = $bankNumber;
        return $this;
    }
    /**
     * Get bankRoutingNumber value
     * @return string|null
     */
    public function getBankRoutingNumber()
    {
        return $this->bankRoutingNumber;
    }
    /**
     * Set bankRoutingNumber value
     * @param string $bankRoutingNumber
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setBankRoutingNumber($bankRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingNumber) && !is_string($bankRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankRoutingNumber, true), gettype($bankRoutingNumber)), __LINE__);
        }
        $this->bankRoutingNumber = $bankRoutingNumber;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountNumber, true), gettype($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * Set inactive value
     * @param bool $inactive
     * @return \StructType\EmployeeDirectDeposit
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
}
