<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeDeductionList StructType
 * @subpackage Structs
 */
class EmployeeDeductionList extends AbstractStructBase
{
    /**
     * The employeeDeduction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeDeduction[]
     */
    public $employeeDeduction;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EmployeeDeductionList
     * @uses EmployeeDeductionList::setEmployeeDeduction()
     * @uses EmployeeDeductionList::setReplaceAll()
     * @param \StructType\EmployeeDeduction[] $employeeDeduction
     * @param bool $replaceAll
     */
    public function __construct(array $employeeDeduction = array(), $replaceAll = true)
    {
        $this
            ->setEmployeeDeduction($employeeDeduction)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get employeeDeduction value
     * @return \StructType\EmployeeDeduction[]|null
     */
    public function getEmployeeDeduction()
    {
        return $this->employeeDeduction;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeDeduction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeDeduction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeDeductionForArrayConstraintsFromSetEmployeeDeduction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeeDeductionListEmployeeDeductionItem) {
            // validation for constraint: itemType
            if (!$employeeDeductionListEmployeeDeductionItem instanceof \StructType\EmployeeDeduction) {
                $invalidValues[] = is_object($employeeDeductionListEmployeeDeductionItem) ? get_class($employeeDeductionListEmployeeDeductionItem) : sprintf('%s(%s)', gettype($employeeDeductionListEmployeeDeductionItem), var_export($employeeDeductionListEmployeeDeductionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employeeDeduction property can only contain items of type \StructType\EmployeeDeduction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employeeDeduction value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeDeduction[] $employeeDeduction
     * @return \StructType\EmployeeDeductionList
     */
    public function setEmployeeDeduction(array $employeeDeduction = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeDeductionArrayErrorMessage = self::validateEmployeeDeductionForArrayConstraintsFromSetEmployeeDeduction($employeeDeduction))) {
            throw new \InvalidArgumentException($employeeDeductionArrayErrorMessage, __LINE__);
        }
        $this->employeeDeduction = $employeeDeduction;
        return $this;
    }
    /**
     * Add item to employeeDeduction value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeDeduction $item
     * @return \StructType\EmployeeDeductionList
     */
    public function addToEmployeeDeduction(\StructType\EmployeeDeduction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeDeduction) {
            throw new \InvalidArgumentException(sprintf('The employeeDeduction property can only contain items of type \StructType\EmployeeDeduction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employeeDeduction[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EmployeeDeductionList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
