<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeCurrencyList StructType
 * @subpackage Structs
 */
class EmployeeCurrencyList extends AbstractStructBase
{
    /**
     * The employeeCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeCurrency[]
     */
    public $employeeCurrency;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EmployeeCurrencyList
     * @uses EmployeeCurrencyList::setEmployeeCurrency()
     * @uses EmployeeCurrencyList::setReplaceAll()
     * @param \StructType\EmployeeCurrency[] $employeeCurrency
     * @param bool $replaceAll
     */
    public function __construct(array $employeeCurrency = array(), $replaceAll = true)
    {
        $this
            ->setEmployeeCurrency($employeeCurrency)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get employeeCurrency value
     * @return \StructType\EmployeeCurrency[]|null
     */
    public function getEmployeeCurrency()
    {
        return $this->employeeCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeCurrencyForArrayConstraintsFromSetEmployeeCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeeCurrencyListEmployeeCurrencyItem) {
            // validation for constraint: itemType
            if (!$employeeCurrencyListEmployeeCurrencyItem instanceof \StructType\EmployeeCurrency) {
                $invalidValues[] = is_object($employeeCurrencyListEmployeeCurrencyItem) ? get_class($employeeCurrencyListEmployeeCurrencyItem) : sprintf('%s(%s)', gettype($employeeCurrencyListEmployeeCurrencyItem), var_export($employeeCurrencyListEmployeeCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The employeeCurrency property can only contain items of type \StructType\EmployeeCurrency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set employeeCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeCurrency[] $employeeCurrency
     * @return \StructType\EmployeeCurrencyList
     */
    public function setEmployeeCurrency(array $employeeCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeCurrencyArrayErrorMessage = self::validateEmployeeCurrencyForArrayConstraintsFromSetEmployeeCurrency($employeeCurrency))) {
            throw new \InvalidArgumentException($employeeCurrencyArrayErrorMessage, __LINE__);
        }
        $this->employeeCurrency = $employeeCurrency;
        return $this;
    }
    /**
     * Add item to employeeCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeCurrency $item
     * @return \StructType\EmployeeCurrencyList
     */
    public function addToEmployeeCurrency(\StructType\EmployeeCurrency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeCurrency) {
            throw new \InvalidArgumentException(sprintf('The employeeCurrency property can only contain items of type \StructType\EmployeeCurrency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->employeeCurrency[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EmployeeCurrencyList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
