<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeCompanyContribution StructType
 * @subpackage Structs
 */
class EmployeeCompanyContribution extends AbstractStructBase
{
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payrollItem;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $limit;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inactive;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * Constructor method for EmployeeCompanyContribution
     * @uses EmployeeCompanyContribution::setPayrollItem()
     * @uses EmployeeCompanyContribution::setRate()
     * @uses EmployeeCompanyContribution::setLimit()
     * @uses EmployeeCompanyContribution::setInactive()
     * @uses EmployeeCompanyContribution::setEffectiveDate()
     * @uses EmployeeCompanyContribution::setExpirationDate()
     * @param \StructType\RecordRef $payrollItem
     * @param string $rate
     * @param float $limit
     * @param bool $inactive
     * @param string $effectiveDate
     * @param string $expirationDate
     */
    public function __construct(\StructType\RecordRef $payrollItem = null, $rate = null, $limit = null, $inactive = null, $effectiveDate = null, $expirationDate = null)
    {
        $this
            ->setPayrollItem($payrollItem)
            ->setRate($rate)
            ->setLimit($limit)
            ->setInactive($inactive)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get payrollItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * Set payrollItem value
     * @param \StructType\RecordRef $payrollItem
     * @return \StructType\EmployeeCompanyContribution
     */
    public function setPayrollItem(\StructType\RecordRef $payrollItem = null)
    {
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\EmployeeCompanyContribution
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get limit value
     * @return float|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param float $limit
     * @return \StructType\EmployeeCompanyContribution
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: float
        if (!is_null($limit) && !(is_float($limit) || is_numeric($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * Set inactive value
     * @param bool $inactive
     * @return \StructType\EmployeeCompanyContribution
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\EmployeeCompanyContribution
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\EmployeeCompanyContribution
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
}
