<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeAddressbookList StructType
 * @subpackage Structs
 */
class EmployeeAddressbookList extends AbstractStructBase
{
    /**
     * The addressbook
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeAddressbook[]
     */
    public $addressbook;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for EmployeeAddressbookList
     * @uses EmployeeAddressbookList::setAddressbook()
     * @uses EmployeeAddressbookList::setReplaceAll()
     * @param \StructType\EmployeeAddressbook[] $addressbook
     * @param bool $replaceAll
     */
    public function __construct(array $addressbook = array(), $replaceAll = true)
    {
        $this
            ->setAddressbook($addressbook)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get addressbook value
     * @return \StructType\EmployeeAddressbook[]|null
     */
    public function getAddressbook()
    {
        return $this->addressbook;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressbook method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressbook method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressbookForArrayConstraintsFromSetAddressbook(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeeAddressbookListAddressbookItem) {
            // validation for constraint: itemType
            if (!$employeeAddressbookListAddressbookItem instanceof \StructType\EmployeeAddressbook) {
                $invalidValues[] = is_object($employeeAddressbookListAddressbookItem) ? get_class($employeeAddressbookListAddressbookItem) : sprintf('%s(%s)', gettype($employeeAddressbookListAddressbookItem), var_export($employeeAddressbookListAddressbookItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The addressbook property can only contain items of type \StructType\EmployeeAddressbook, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set addressbook value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeAddressbook[] $addressbook
     * @return \StructType\EmployeeAddressbookList
     */
    public function setAddressbook(array $addressbook = array())
    {
        // validation for constraint: array
        if ('' !== ($addressbookArrayErrorMessage = self::validateAddressbookForArrayConstraintsFromSetAddressbook($addressbook))) {
            throw new \InvalidArgumentException($addressbookArrayErrorMessage, __LINE__);
        }
        $this->addressbook = $addressbook;
        return $this;
    }
    /**
     * Add item to addressbook value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeAddressbook $item
     * @return \StructType\EmployeeAddressbookList
     */
    public function addToAddressbook(\StructType\EmployeeAddressbook $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeAddressbook) {
            throw new \InvalidArgumentException(sprintf('The addressbook property can only contain items of type \StructType\EmployeeAddressbook, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->addressbook[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\EmployeeAddressbookList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
