<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeAccruedTime StructType
 * @subpackage Structs
 */
class EmployeeAccruedTime extends AbstractStructBase
{
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payrollItem;
    /**
     * The accruedHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $accruedHours;
    /**
     * The accrualRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $accrualRate;
    /**
     * The monetaryRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $monetaryRate;
    /**
     * The resetAccruedHoursAtYearEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $resetAccruedHoursAtYearEnd;
    /**
     * The accrualMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accrualMethod;
    /**
     * The maximumAccruedHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maximumAccruedHours;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inactive;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * Constructor method for EmployeeAccruedTime
     * @uses EmployeeAccruedTime::setPayrollItem()
     * @uses EmployeeAccruedTime::setAccruedHours()
     * @uses EmployeeAccruedTime::setAccrualRate()
     * @uses EmployeeAccruedTime::setMonetaryRate()
     * @uses EmployeeAccruedTime::setResetAccruedHoursAtYearEnd()
     * @uses EmployeeAccruedTime::setAccrualMethod()
     * @uses EmployeeAccruedTime::setMaximumAccruedHours()
     * @uses EmployeeAccruedTime::setInactive()
     * @uses EmployeeAccruedTime::setEffectiveDate()
     * @uses EmployeeAccruedTime::setExpirationDate()
     * @param \StructType\RecordRef $payrollItem
     * @param float $accruedHours
     * @param float $accrualRate
     * @param float $monetaryRate
     * @param bool $resetAccruedHoursAtYearEnd
     * @param string $accrualMethod
     * @param float $maximumAccruedHours
     * @param bool $inactive
     * @param string $effectiveDate
     * @param string $expirationDate
     */
    public function __construct(\StructType\RecordRef $payrollItem = null, $accruedHours = null, $accrualRate = null, $monetaryRate = null, $resetAccruedHoursAtYearEnd = null, $accrualMethod = null, $maximumAccruedHours = null, $inactive = null, $effectiveDate = null, $expirationDate = null)
    {
        $this
            ->setPayrollItem($payrollItem)
            ->setAccruedHours($accruedHours)
            ->setAccrualRate($accrualRate)
            ->setMonetaryRate($monetaryRate)
            ->setResetAccruedHoursAtYearEnd($resetAccruedHoursAtYearEnd)
            ->setAccrualMethod($accrualMethod)
            ->setMaximumAccruedHours($maximumAccruedHours)
            ->setInactive($inactive)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get payrollItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * Set payrollItem value
     * @param \StructType\RecordRef $payrollItem
     * @return \StructType\EmployeeAccruedTime
     */
    public function setPayrollItem(\StructType\RecordRef $payrollItem = null)
    {
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Get accruedHours value
     * @return float|null
     */
    public function getAccruedHours()
    {
        return $this->accruedHours;
    }
    /**
     * Set accruedHours value
     * @param float $accruedHours
     * @return \StructType\EmployeeAccruedTime
     */
    public function setAccruedHours($accruedHours = null)
    {
        // validation for constraint: float
        if (!is_null($accruedHours) && !(is_float($accruedHours) || is_numeric($accruedHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accruedHours, true), gettype($accruedHours)), __LINE__);
        }
        $this->accruedHours = $accruedHours;
        return $this;
    }
    /**
     * Get accrualRate value
     * @return float|null
     */
    public function getAccrualRate()
    {
        return $this->accrualRate;
    }
    /**
     * Set accrualRate value
     * @param float $accrualRate
     * @return \StructType\EmployeeAccruedTime
     */
    public function setAccrualRate($accrualRate = null)
    {
        // validation for constraint: float
        if (!is_null($accrualRate) && !(is_float($accrualRate) || is_numeric($accrualRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accrualRate, true), gettype($accrualRate)), __LINE__);
        }
        $this->accrualRate = $accrualRate;
        return $this;
    }
    /**
     * Get monetaryRate value
     * @return float|null
     */
    public function getMonetaryRate()
    {
        return $this->monetaryRate;
    }
    /**
     * Set monetaryRate value
     * @param float $monetaryRate
     * @return \StructType\EmployeeAccruedTime
     */
    public function setMonetaryRate($monetaryRate = null)
    {
        // validation for constraint: float
        if (!is_null($monetaryRate) && !(is_float($monetaryRate) || is_numeric($monetaryRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monetaryRate, true), gettype($monetaryRate)), __LINE__);
        }
        $this->monetaryRate = $monetaryRate;
        return $this;
    }
    /**
     * Get resetAccruedHoursAtYearEnd value
     * @return bool|null
     */
    public function getResetAccruedHoursAtYearEnd()
    {
        return $this->resetAccruedHoursAtYearEnd;
    }
    /**
     * Set resetAccruedHoursAtYearEnd value
     * @param bool $resetAccruedHoursAtYearEnd
     * @return \StructType\EmployeeAccruedTime
     */
    public function setResetAccruedHoursAtYearEnd($resetAccruedHoursAtYearEnd = null)
    {
        // validation for constraint: boolean
        if (!is_null($resetAccruedHoursAtYearEnd) && !is_bool($resetAccruedHoursAtYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resetAccruedHoursAtYearEnd, true), gettype($resetAccruedHoursAtYearEnd)), __LINE__);
        }
        $this->resetAccruedHoursAtYearEnd = $resetAccruedHoursAtYearEnd;
        return $this;
    }
    /**
     * Get accrualMethod value
     * @return string|null
     */
    public function getAccrualMethod()
    {
        return $this->accrualMethod;
    }
    /**
     * Set accrualMethod value
     * @uses \EnumType\EmployeeAccruedTimeAccrualMethod::valueIsValid()
     * @uses \EnumType\EmployeeAccruedTimeAccrualMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accrualMethod
     * @return \StructType\EmployeeAccruedTime
     */
    public function setAccrualMethod($accrualMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmployeeAccruedTimeAccrualMethod::valueIsValid($accrualMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmployeeAccruedTimeAccrualMethod', is_array($accrualMethod) ? implode(', ', $accrualMethod) : var_export($accrualMethod, true), implode(', ', \EnumType\EmployeeAccruedTimeAccrualMethod::getValidValues())), __LINE__);
        }
        $this->accrualMethod = $accrualMethod;
        return $this;
    }
    /**
     * Get maximumAccruedHours value
     * @return float|null
     */
    public function getMaximumAccruedHours()
    {
        return $this->maximumAccruedHours;
    }
    /**
     * Set maximumAccruedHours value
     * @param float $maximumAccruedHours
     * @return \StructType\EmployeeAccruedTime
     */
    public function setMaximumAccruedHours($maximumAccruedHours = null)
    {
        // validation for constraint: float
        if (!is_null($maximumAccruedHours) && !(is_float($maximumAccruedHours) || is_numeric($maximumAccruedHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumAccruedHours, true), gettype($maximumAccruedHours)), __LINE__);
        }
        $this->maximumAccruedHours = $maximumAccruedHours;
        return $this;
    }
    /**
     * Get inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * Set inactive value
     * @param bool $inactive
     * @return \StructType\EmployeeAccruedTime
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\EmployeeAccruedTime
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\EmployeeAccruedTime
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
}
