<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Duration StructType
 * @subpackage Structs
 */
class Duration extends AbstractStructBase
{
    /**
     * The timeSpan
     * @var float
     */
    public $timeSpan;
    /**
     * The unit
     * @var string
     */
    public $unit;
    /**
     * Constructor method for Duration
     * @uses Duration::setTimeSpan()
     * @uses Duration::setUnit()
     * @param float $timeSpan
     * @param string $unit
     */
    public function __construct($timeSpan = null, $unit = null)
    {
        $this
            ->setTimeSpan($timeSpan)
            ->setUnit($unit);
    }
    /**
     * Get timeSpan value
     * @return float|null
     */
    public function getTimeSpan()
    {
        return $this->timeSpan;
    }
    /**
     * Set timeSpan value
     * @param float $timeSpan
     * @return \StructType\Duration
     */
    public function setTimeSpan($timeSpan = null)
    {
        // validation for constraint: float
        if (!is_null($timeSpan) && !(is_float($timeSpan) || is_numeric($timeSpan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timeSpan, true), gettype($timeSpan)), __LINE__);
        }
        $this->timeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\DurationUnit::valueIsValid()
     * @uses \EnumType\DurationUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\Duration
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DurationUnit::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DurationUnit', is_array($unit) ? implode(', ', $unit) : var_export($unit, true), implode(', ', \EnumType\DurationUnit::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
}
